/*
 * Decompiled with CFR 0.152.
 */
package org.kie.perf;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.kie.perf.run.Duration;
import org.kie.perf.run.IRunType;
import org.kie.perf.run.Iteration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestConfig {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static TestConfig tc;
    protected String suite;
    protected String scenario;
    protected String startScriptLocation;
    protected RunType runType;
    protected int duration;
    protected int iterations;
    protected ReporterType reporterType;
    protected int periodicity;
    protected String reportDataLocation;
    protected int threads;
    protected boolean warmUp;
    protected int warmUpCount;
    protected List<Measure> measure;

    protected TestConfig() {
    }

    public Properties loadProperties() throws Exception {
        String[] mlist;
        Properties props = new Properties();
        this.suite = System.getProperty("suite");
        props.put("suite", this.suite);
        this.scenario = System.getProperty("scenario");
        if (this.scenario.isEmpty() || this.scenario.equals("${scenario}")) {
            this.scenario = null;
        }
        props.put("scenario", this.scenario);
        this.startScriptLocation = System.getProperty("startScriptLocation");
        if (this.startScriptLocation == null) {
            this.startScriptLocation = "./run.sh";
        }
        props.put("startScriptLocation", this.startScriptLocation);
        this.runType = RunType.valueOf(System.getProperty("runType").toUpperCase());
        this.duration = Integer.valueOf(System.getProperty("duration"));
        this.iterations = Integer.valueOf(System.getProperty("iterations"));
        props.put("runType", (Object)this.runType);
        props.put("duration", (Object)this.duration);
        props.put("iterations", (Object)this.iterations);
        this.reporterType = ReporterType.valueOf(System.getProperty("reporterType").toUpperCase());
        this.periodicity = Integer.valueOf(System.getProperty("periodicity"));
        this.reportDataLocation = System.getProperty("reportDataLocation");
        props.put("reporterType", (Object)this.reporterType);
        props.put("periodicity", (Object)this.periodicity);
        props.put("reportDataLocation", this.reportDataLocation);
        this.threads = Integer.valueOf(System.getProperty("threads"));
        props.put("threads", (Object)this.threads);
        this.warmUp = Boolean.valueOf(System.getProperty("warmUp"));
        this.warmUpCount = Integer.valueOf(System.getProperty("warmUpCount"));
        props.put("warmUp", (Object)this.warmUp);
        props.put("warmUpCount", (Object)this.warmUpCount);
        this.measure = new ArrayList<Measure>();
        String mprop = System.getProperty("measure");
        for (String m : mlist = mprop != null ? mprop.toUpperCase().split(",") : new String[]{}) {
            try {
                this.measure.add(Measure.valueOf(m));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        props.put("measure", this.measure);
        return props;
    }

    public static TestConfig getInstance() {
        if (tc == null) {
            tc = new TestConfig();
            try {
                tc.loadProperties();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return tc;
    }

    public String getSuite() {
        return this.suite;
    }

    public String getScenario() {
        return this.scenario;
    }

    public String getStartScriptLocation() {
        return this.startScriptLocation;
    }

    public RunType getRunType() {
        return this.runType;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getIterations() {
        return this.iterations;
    }

    public ReporterType getReporterType() {
        return this.reporterType;
    }

    public int getPeriodicity() {
        return this.periodicity;
    }

    public String getReportDataLocation() {
        return this.reportDataLocation;
    }

    public int getThreads() {
        return this.threads;
    }

    public boolean isWarmUp() {
        return this.warmUp;
    }

    public int getWarmUpCount() {
        return this.warmUpCount;
    }

    public List<Measure> getMeasure() {
        return this.measure;
    }

    public static enum RunType {
        DURATION(Duration.class),
        ITERATION(Iteration.class);

        private Class<? extends IRunType> klass;

        private RunType(Class<? extends IRunType> klass) {
            this.klass = klass;
        }

        public IRunType newInstance() {
            IRunType instance = null;
            try {
                instance = this.klass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return instance;
        }
    }

    public static enum Measure {
        MEMORYUSAGE,
        FILEDESCRIPTORS,
        THREADSTATES;

    }

    public static enum ReporterType {
        CONSOLE,
        CSV,
        CSVSINGLE;

    }
}

