/*
 * Decompiled with CFR 0.152.
 */
package org.kie.perf.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvSingleReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvReporter.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final File directory;
    private final Locale locale;
    private final Clock clock;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private CsvSingleReporter(MetricRegistry registry, File directory, Locale locale, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock, MetricFilter filter) {
        super(registry, "csv-reporter", filter, rateUnit, durationUnit);
        this.directory = directory;
        this.locale = locale;
        this.clock = clock;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.reportGauge(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            this.reportCounter(entry.getKey(), (Counter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            this.reportHistogram(entry.getKey(), (Histogram)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            this.reportMeter(entry.getKey(), (Meter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            this.reportTimer(entry.getKey(), (Timer)entry.getValue());
        }
    }

    private void reportTimer(String name, Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        this.report(name, this.getMeterName(name), timer.getCount(), this.convertRate(timer.getMeanRate()), this.convertDuration(snapshot.getMin()), this.convertDuration(snapshot.getMean()), this.convertDuration(snapshot.getMax()), this.convertDuration(snapshot.getStdDev()), this.convertDuration(snapshot.getMedian()), this.convertDuration(snapshot.get75thPercentile()), this.convertDuration(snapshot.get95thPercentile()), this.convertDuration(snapshot.get98thPercentile()), this.convertDuration(snapshot.get99thPercentile()), this.convertDuration(snapshot.get999thPercentile()));
    }

    private void reportMeter(String name, Meter meter) {
        this.report(name, this.getMeterName(name), meter.getCount(), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
    }

    private void reportHistogram(String name, Histogram histogram) {
        Snapshot snapshot = histogram.getSnapshot();
        this.report(name, this.getMeterName(name), histogram.getCount(), Float.valueOf(0.0f), snapshot.getMin(), snapshot.getMean(), snapshot.getMax(), snapshot.getStdDev(), snapshot.getMedian(), snapshot.get75thPercentile(), snapshot.get95thPercentile(), snapshot.get98thPercentile(), snapshot.get99thPercentile(), snapshot.get999thPercentile());
    }

    private void reportCounter(String name, Counter counter) {
        this.report(name, this.getMeterName(name), counter.getCount(), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
    }

    private void reportGauge(String name, Gauge gauge) {
        this.report(name, this.getMeterName(name), gauge.getValue(), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void report(String name, Object ... values) {
        block6: {
            try {
                File file = new File(this.directory, this.getFileName(name) + ".csv");
                boolean fileAlreadyExists = file.exists();
                if (!fileAlreadyExists && !file.createNewFile()) break block6;
                PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), UTF_8));
                try {
                    if (!fileAlreadyExists) {
                        out.println("Metric,Count/Value,Mean Rate [events/" + this.getRateUnit() + "],Min [" + this.getDurationUnit() + "],Mean [" + this.getDurationUnit() + "],Max [" + this.getDurationUnit() + "],Standard Deviation,Median,p75,p95,p98,p99,p99.9");
                    }
                    out.printf(this.locale, String.format(this.locale, "%s%n", "%s,%s,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f"), values);
                }
                finally {
                    out.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Error writing to {}", (Object)name, (Object)e);
            }
        }
    }

    protected String getFileName(String name) {
        String a = name.substring(name.indexOf(".", "org.kie.perf.scenario".length() + 1) + 1);
        return a.substring(0, a.indexOf("."));
    }

    protected String getMeterName(String name) {
        String a = name.substring(name.indexOf(".", "org.kie.perf.scenario".length() + 1) + 1);
        return a.substring(a.indexOf(".") + 1);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Locale locale;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private Clock clock;
        private MetricFilter filter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.locale = Locale.getDefault();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.clock = Clock.defaultClock();
            this.filter = MetricFilter.ALL;
        }

        public Builder formatFor(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public CsvSingleReporter build(File directory) {
            return new CsvSingleReporter(this.registry, directory, this.locale, this.rateUnit, this.durationUnit, this.clock, this.filter);
        }
    }
}

