/*
 * Decompiled with CFR 0.152.
 */
package org.kie.perf;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.kie.perf.Executor;
import org.kie.perf.run.Duration;
import org.kie.perf.run.IRunType;
import org.kie.perf.run.Iteration;
import org.kie.perf.suite.ConcurrentLoadSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestConfig {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static TestConfig tc;
    protected Properties properties;
    protected String projectName;
    protected String suite;
    protected String scenario;
    protected String startScriptLocation;
    protected String databaseName;
    protected RunType runType;
    protected int duration;
    protected int iterations;
    protected int expectedRate;
    protected ReporterType reporterType;
    protected int periodicity;
    protected String reportDataLocation;
    protected int threads;
    protected boolean warmUp;
    protected int warmUpCount;
    protected String perfRepoHost;
    protected String perfRepoUrlPath;
    protected String perfRepoUsername;
    protected String perfRepoPassword;
    protected String version = Executor.class.getPackage().getImplementationVersion();
    protected List<Measure> measure;
    protected List<String> tags = new ArrayList<String>();

    protected TestConfig() {
    }

    public Properties loadProperties() throws Exception {
        String[] mlist;
        this.properties = new Properties();
        this.projectName = System.getProperty("projectName");
        if (this.projectName == null || this.projectName.isEmpty()) {
            this.projectName = "Project";
        }
        this.suite = System.getProperty("suite");
        this.properties.put("suite", this.suite);
        this.properties.put("suite.version", this.version);
        this.addTag(this.version);
        this.scenario = System.getProperty("scenario");
        if (this.scenario == null || this.scenario.isEmpty() || this.scenario.equals("${scenario}")) {
            this.scenario = null;
        } else {
            this.properties.put("scenario", this.scenario);
        }
        this.startScriptLocation = System.getProperty("startScriptLocation");
        if (this.startScriptLocation == null) {
            this.startScriptLocation = "./run.sh";
        }
        this.properties.put("startScriptLocation", this.startScriptLocation);
        this.runType = RunType.valueOf(System.getProperty("runType").toUpperCase());
        this.duration = Integer.valueOf(System.getProperty("duration"));
        this.iterations = Integer.valueOf(System.getProperty("iterations"));
        String expectedRateProp = System.getProperty("expectedRate");
        this.expectedRate = expectedRateProp == null ? 10 : Integer.valueOf(expectedRateProp);
        this.properties.put("runType", (Object)this.runType);
        this.properties.put("duration", (Object)this.duration);
        this.properties.put("iterations", (Object)this.iterations);
        this.properties.put("expectedRate", (Object)this.expectedRate);
        this.reporterType = ReporterType.valueOf(System.getProperty("reporterType").toUpperCase());
        this.periodicity = Integer.valueOf(System.getProperty("periodicity"));
        this.reportDataLocation = System.getProperty("reportDataLocation");
        this.properties.put("reporterType", (Object)this.reporterType);
        this.properties.put("periodicity", (Object)this.periodicity);
        this.properties.put("reportDataLocation", this.reportDataLocation);
        this.threads = Integer.valueOf(System.getProperty("threads"));
        this.properties.put("threads", (Object)this.threads);
        if (this.suite.equals(ConcurrentLoadSuite.class.getSimpleName())) {
            this.addTag("thread-" + this.threads);
        }
        this.warmUp = Boolean.valueOf(System.getProperty("warmUp"));
        this.warmUpCount = Integer.valueOf(System.getProperty("warmUpCount"));
        this.properties.put("warmUp", (Object)this.warmUp);
        this.properties.put("warmUpCount", (Object)this.warmUpCount);
        this.measure = new ArrayList<Measure>();
        String mprop = System.getProperty("measure");
        for (String m : mlist = mprop != null ? mprop.toUpperCase().split(",") : new String[]{}) {
            try {
                this.measure.add(Measure.valueOf(m));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.properties.put("measure", this.measure);
        this.perfRepoHost = System.getProperty("perfRepo.host");
        if (this.perfRepoHost != null) {
            this.properties.put("perfRepo.host", this.perfRepoHost);
        }
        this.perfRepoUrlPath = System.getProperty("perfRepo.urlPath");
        if (this.perfRepoUrlPath != null) {
            this.properties.put("perfRepo.urlPath", this.perfRepoUrlPath);
        }
        this.perfRepoUsername = System.getProperty("perfRepo.username");
        if (this.perfRepoUsername != null) {
            this.properties.put("perfRepo.username", this.perfRepoUsername);
        }
        this.perfRepoPassword = System.getProperty("perfRepo.password");
        if (this.perfRepoPassword != null) {
            this.properties.put("perfRepo.password", this.perfRepoPassword);
        }
        return this.properties;
    }

    public static TestConfig getInstance() {
        if (tc == null) {
            tc = new TestConfig();
            try {
                tc.loadProperties();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return tc;
    }

    protected void addTag(String tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getSuite() {
        return this.suite;
    }

    public String getVersion() {
        return this.version;
    }

    public String getScenario() {
        return this.scenario;
    }

    public String getStartScriptLocation() {
        return this.startScriptLocation;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public RunType getRunType() {
        return this.runType;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getExpectedRate() {
        return this.expectedRate;
    }

    public ReporterType getReporterType() {
        return this.reporterType;
    }

    public int getPeriodicity() {
        return this.periodicity;
    }

    public String getReportDataLocation() {
        return this.reportDataLocation;
    }

    public int getThreads() {
        return this.threads;
    }

    public boolean isWarmUp() {
        return this.warmUp;
    }

    public int getWarmUpCount() {
        return this.warmUpCount;
    }

    public List<Measure> getMeasure() {
        return this.measure;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getPerfRepoHost() {
        return this.perfRepoHost;
    }

    public String getPerfRepoUrlPath() {
        return this.perfRepoUrlPath;
    }

    public String getPerfRepoUsername() {
        return this.perfRepoUsername;
    }

    public String getPerfRepoPassword() {
        return this.perfRepoPassword;
    }

    public static enum RunType {
        DURATION(Duration.class),
        ITERATION(Iteration.class);

        private Class<? extends IRunType> klass;

        private RunType(Class<? extends IRunType> klass) {
            this.klass = klass;
        }

        public IRunType newInstance() {
            IRunType instance = null;
            try {
                instance = this.klass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return instance;
        }
    }

    public static enum Measure {
        MEMORYUSAGE,
        FILEDESCRIPTORS,
        THREADSTATES,
        CPUUSAGE;

    }

    public static enum ReporterType {
        CONSOLE,
        CSV,
        CSVSINGLE,
        PERFREPO;

    }
}

