/*
 * Decompiled with CFR 0.152.
 */
package org.kie.perf.metrics;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.UniformReservoir;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class CPUUsageHistogramSet
implements MetricSet {
    private Class<?> scenario;
    private Histogram cpuUsageHistogram = new Histogram((Reservoir)new UniformReservoir());
    private OperatingSystemMXBean operatingSystemMXBean;
    private Timer timer = new Timer();
    private static CPUUsageHistogramSet instance = null;

    private CPUUsageHistogramSet(Class<?> scenario) {
        this.scenario = scenario;
        this.operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    }

    public static CPUUsageHistogramSet getInstance(Class<?> scenario) {
        if (instance == null) {
            instance = new CPUUsageHistogramSet(scenario);
        }
        return instance;
    }

    private void update() {
        Double value = null;
        try {
            if (this.operatingSystemMXBean != null) {
                value = this.operatingSystemMXBean.getProcessCpuLoad();
                value = value * 100.0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (value != null) {
            long cpu = Math.round(value);
            this.cpuUsageHistogram.update(cpu);
        }
    }

    public void start() {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                CPUUsageHistogramSet.this.update();
            }
        }, 100L, 200L);
    }

    public void stop() {
        this.timer.cancel();
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        if (this.operatingSystemMXBean != null) {
            metrics.put(MetricRegistry.name(this.scenario, (String[])new String[]{"cpu.usage"}), (Metric)this.cpuUsageHistogram);
        }
        return metrics;
    }
}

