/*
 * Decompiled with CFR 0.152.
 */
package org.kie.perf.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.ThreadDeadlockDetector;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ThreadStatesGaugeSet
implements MetricSet {
    private static final int STACK_TRACE_DEPTH = 0;
    private Class<?> scenario;
    private final ThreadMXBean threads;
    private final ThreadDeadlockDetector deadlockDetector;

    public ThreadStatesGaugeSet(Class<?> scenario) {
        this.scenario = scenario;
        this.threads = ManagementFactory.getThreadMXBean();
        this.deadlockDetector = new ThreadDeadlockDetector();
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Object> gauges = new HashMap<String, Object>();
        for (final Thread.State state : Thread.State.values()) {
            gauges.put(MetricRegistry.name(this.scenario, (String[])new String[]{"thread.state", state.toString().toLowerCase(), "count"}), new Gauge<Object>(){

                public Object getValue() {
                    return ThreadStatesGaugeSet.this.getThreadCount(state);
                }
            });
        }
        gauges.put(MetricRegistry.name(this.scenario, (String[])new String[]{"threads.count"}), new Gauge<Integer>(){

            public Integer getValue() {
                return ThreadStatesGaugeSet.this.threads.getThreadCount();
            }
        });
        gauges.put(MetricRegistry.name(this.scenario, (String[])new String[]{"daemon.count"}), new Gauge<Integer>(){

            public Integer getValue() {
                return ThreadStatesGaugeSet.this.threads.getDaemonThreadCount();
            }
        });
        gauges.put(MetricRegistry.name(this.scenario, (String[])new String[]{"deadlock.count"}), new Gauge<Integer>(){

            public Integer getValue() {
                return ThreadStatesGaugeSet.this.deadlockDetector.getDeadlockedThreads().size();
            }
        });
        gauges.put(MetricRegistry.name(this.scenario, (String[])new String[]{"deadlocks"}), new Gauge<Set<String>>(){

            public Set<String> getValue() {
                return ThreadStatesGaugeSet.this.deadlockDetector.getDeadlockedThreads();
            }
        });
        return Collections.unmodifiableMap(gauges);
    }

    private int getThreadCount(Thread.State state) {
        ThreadInfo[] allThreads = this.getThreadInfo();
        int count = 0;
        for (ThreadInfo info : allThreads) {
            if (info == null || info.getThreadState() != state) continue;
            ++count;
        }
        return count;
    }

    ThreadInfo[] getThreadInfo() {
        return this.threads.getThreadInfo(this.threads.getAllThreadIds(), 0);
    }
}

