/*
 * Decompiled with CFR 0.152.
 */
package org.kie.perf.suite;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.kie.perf.Executor;
import org.kie.perf.SharedMetricRegistry;
import org.kie.perf.TestConfig;
import org.kie.perf.metrics.CPUUsageHistogramSet;
import org.kie.perf.metrics.PerfRepoReporter;
import org.kie.perf.run.IRunType;
import org.kie.perf.scenario.IPerfTest;
import org.kie.perf.suite.ITestSuite;

public class SoakSuite
implements ITestSuite {
    protected int iterations;
    protected int expectedRate;
    protected IRunType run;

    public SoakSuite() {
        TestConfig tc = TestConfig.getInstance();
        this.iterations = tc.getIterations();
        this.expectedRate = tc.getExpectedRate();
        this.run = tc.getRunType().newInstance();
    }

    @Override
    public void start() throws Exception {
        TestConfig tc = TestConfig.getInstance();
        Executor exec = Executor.getInstance();
        Set<Class<? extends IPerfTest>> scenarios = exec.getScenarios(tc.getTestPackage());
        ArrayList<IPerfTest> scenarioInstances = new ArrayList<IPerfTest>();
        for (Class<? extends IPerfTest> c : scenarios) {
            IPerfTest scenario = c.newInstance();
            scenario.init();
            scenarioInstances.add(scenario);
        }
        boolean cpuusageEnabled = tc.getMeasure().contains((Object)TestConfig.Measure.CPUUSAGE);
        CPUUsageHistogramSet cpuusage = null;
        if (cpuusageEnabled) {
            cpuusage = CPUUsageHistogramSet.getInstance(SoakSuite.class);
            cpuusage.start();
        }
        long timeForOneRun = Math.round(60.0 / (double)this.expectedRate) * 1000L;
        ScheduledReporter reporter = exec.getReporter();
        if (reporter instanceof PerfRepoReporter) {
            ((PerfRepoReporter)reporter).setScheduled(true);
        }
        reporter.start((long)tc.getPeriodicity(), TimeUnit.SECONDS);
        this.run.start(Integer.MAX_VALUE);
        while (!this.run.isEnd()) {
            long startTime = System.currentTimeMillis();
            for (IPerfTest scenario : scenarioInstances) {
                this.startScenario(scenario);
            }
            long endTime = System.currentTimeMillis();
            long pause = timeForOneRun - (endTime - startTime);
            if (pause <= 0L) continue;
            Thread.sleep(pause);
        }
        reporter.stop();
        if (cpuusageEnabled) {
            cpuusage.stop();
        }
        for (IPerfTest scenario : scenarioInstances) {
            scenario.close();
        }
    }

    private void startScenario(IPerfTest scenario) {
        MetricRegistry metrics = SharedMetricRegistry.getInstance();
        Timer scenarioDuration = metrics.timer(MetricRegistry.name(scenario.getClass(), (String[])new String[]{"scenario.single.duration"}));
        scenario.init();
        scenario.initMetrics();
        Timer.Context context = scenarioDuration.time();
        try {
            scenario.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        context.stop();
    }
}

