/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import io.takari.maven.testing.executor.MavenRuntime;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.modelcompiler.CanonicalKieModule;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.maven.plugin.KieMavenPluginBaseIntegrationTest;
import org.kie.maven.plugin.TestUtil;

public class ExecModelParameterTest
extends KieMavenPluginBaseIntegrationTest {
    private static final String GROUP_ID = "org.kie";
    private static final String ARTIFACT_ID_WITHOUT_EXEC_MODEL = "kie-maven-plugin-test-kjar-10";
    private static final String KJAR_NAME_WITHOUT_EXEC_MODEL = "kjar-10-simple-kjar";
    private static final String KBASE_NAME_WITHOUT_EXEC_MODE = "SimpleKBase";
    private static final String ARTIFACT_ID_WITH_EXEC_MODEL = "kie-maven-plugin-test-kjar-11";
    private static final String KJAR_NAME_WITH_EXEC_MODEL = "kjar-11-simple-kjar-with-droolsmodelcompiler";
    private static final String KBASE_NAME_WITH_EXEC_MODEL = "SimpleKBase-execmodel";
    private static final String VERSION = "1.0.0.Final";

    public ExecModelParameterTest(MavenRuntime.MavenRuntimeBuilder builder) {
        super(builder);
    }

    @Test
    public void testDefaultMavenWithDroolsModelCompilerOnClassPathRunsExecModel() throws Exception {
        this.buildKJarProject(KJAR_NAME_WITH_EXEC_MODEL, new String[]{"-Dorg.kie.version=" + TestUtil.getProjectVersion()}, "clean", "install");
        KieModule kieModule = this.fireRule(ARTIFACT_ID_WITH_EXEC_MODEL, KBASE_NAME_WITH_EXEC_MODEL);
        Assert.assertTrue((boolean)(kieModule instanceof CanonicalKieModule));
    }

    @Test
    public void testYesMavenWithDroolsModelCompilerOnClassPathRunsExecModel() throws Exception {
        this.buildKJarProject(KJAR_NAME_WITH_EXEC_MODEL, new String[]{String.format("-Dorg.kie.version=%s", TestUtil.getProjectVersion()), "-DgenerateModel=YES"}, "clean", "install");
        KieModule kieModule = this.fireRule(ARTIFACT_ID_WITH_EXEC_MODEL, KBASE_NAME_WITH_EXEC_MODEL);
        Assert.assertTrue((boolean)(kieModule instanceof CanonicalKieModule));
    }

    @Test
    public void testDefaultMavenWithoutDroolsModelCompilerOnClassPathDoNotRunExecModel() throws Exception {
        this.buildKJarProject(KJAR_NAME_WITHOUT_EXEC_MODEL, new String[]{"-Dorg.kie.version=" + TestUtil.getProjectVersion()}, "clean", "install");
        KieModule kieModule = this.fireRule(ARTIFACT_ID_WITHOUT_EXEC_MODEL, KBASE_NAME_WITHOUT_EXEC_MODE);
        Assert.assertFalse((boolean)(kieModule instanceof CanonicalKieModule));
    }

    @Test
    public void testYesMavenWithoutDroolsModelCompilerOnClassPathDoNotRunExecModel() throws Exception {
        this.buildKJarProject(KJAR_NAME_WITHOUT_EXEC_MODEL, new String[]{String.format("-Dorg.kie.version=%s", TestUtil.getProjectVersion()), "-DgenerateModel=YES"}, "clean", "install");
        KieModule kieModule = this.fireRule(ARTIFACT_ID_WITHOUT_EXEC_MODEL, KBASE_NAME_WITHOUT_EXEC_MODE);
        Assert.assertFalse((boolean)(kieModule instanceof CanonicalKieModule));
    }

    @Test
    public void testNoMavenWithoutDroolsModelCompilerOnClassPathDoNotRunExecModel() throws Exception {
        this.buildKJarProject(KJAR_NAME_WITHOUT_EXEC_MODEL, new String[]{String.format("-Dorg.kie.version=%s", TestUtil.getProjectVersion()), "-DgenerateModel=NO"}, "clean", "install");
        KieModule kieModule = this.fireRule(ARTIFACT_ID_WITHOUT_EXEC_MODEL, KBASE_NAME_WITHOUT_EXEC_MODE);
        Assert.assertFalse((boolean)(kieModule instanceof CanonicalKieModule));
    }

    @Test
    public void testNoMavenWithDroolsModelCompilerOnClassPathDoNotRunExecModel() throws Exception {
        this.buildKJarProject(KJAR_NAME_WITH_EXEC_MODEL, new String[]{String.format("-Dorg.kie.version=%s", TestUtil.getProjectVersion()), "-DgenerateModel=NO"}, "clean", "install");
        KieModule kieModule = this.fireRule(ARTIFACT_ID_WITH_EXEC_MODEL, KBASE_NAME_WITH_EXEC_MODEL);
        Assert.assertFalse((boolean)(kieModule instanceof CanonicalKieModule));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KieModule fireRule(String artifactId, String kBaseName) {
        KieServices kieServices = KieServices.get();
        ReleaseId releaseId = kieServices.newReleaseId(GROUP_ID, artifactId, VERSION);
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        KieSession kSession = null;
        try {
            kSession = kieContainer.newKieSession(kBaseName + ".session");
            kSession.insert((Object)"Hello");
            int rulesFired = kSession.fireAllRules();
            kSession.dispose();
            Assert.assertEquals((long)1L, (long)rulesFired);
        }
        finally {
            kSession.dispose();
        }
        return ((KieContainerImpl)kieContainer).getKieModuleForKBase(kBaseName);
    }
}

