/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import io.takari.maven.testing.executor.MavenRuntime;
import java.lang.reflect.Constructor;
import java.util.List;
import org.drools.ancompiler.CompiledNetwork;
import org.drools.ancompiler.ObjectTypeNodeCompiler;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.maven.plugin.KieMavenPluginBaseIntegrationTest;
import org.kie.maven.plugin.TestUtil;

public class AlphaNetworkCompilerTest
extends KieMavenPluginBaseIntegrationTest {
    private static final String GROUP_ID = "org.kie";
    private static final String ARTIFACT_ID = "kie-maven-plugin-test-kjar-13";
    private static final String VERSION = "1.0.0.Final";
    private static final String KJAR_NAME = "kjar-13-with-compiledalphanetwork";

    public AlphaNetworkCompilerTest(MavenRuntime.MavenRuntimeBuilder builder) {
        super(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlphaNetworkCompiler() throws Exception {
        this.buildKJarProject(KJAR_NAME, new String[]{"-Dorg.kie.version=" + TestUtil.getProjectVersion()}, "clean", "install");
        KieServices kieServices = KieServices.get();
        ReleaseId releaseId = kieServices.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        KieContainer kieContainer = kieServices.newKieContainer(releaseId);
        KieSession kSession = null;
        try {
            kSession = kieContainer.newKieSession("kbase-compiled-alphanetwork.session");
            ClassLoader classLoader = kieContainer.getClassLoader();
            Class<?> aClass = Class.forName("org.compiledalphanetwork.Person", true, classLoader);
            Constructor<?> constructor = aClass.getConstructor(String.class);
            Object lucaFactA = constructor.newInstance("Luca");
            kSession.insert(lucaFactA);
            int rulesFired = kSession.fireAllRules();
            kSession.dispose();
            Assert.assertEquals((long)1L, (long)rulesFired);
            this.assertReteIsAlphaNetworkCompiled(kSession);
        }
        finally {
            kSession.dispose();
        }
    }

    protected void assertReteIsAlphaNetworkCompiled(KieSession ksession) {
        Rete rete = ((InternalKnowledgeBase)ksession.getKieBase()).getRete();
        List objectTypeNodes = ObjectTypeNodeCompiler.objectTypeNodes((Rete)rete);
        for (ObjectTypeNode otn : objectTypeNodes) {
            ObjectSinkPropagator objectSinkPropagator = otn.getObjectSinkPropagator();
            System.out.println(objectSinkPropagator.getClass().getCanonicalName());
            Assert.assertTrue((boolean)(objectSinkPropagator instanceof CompiledNetwork));
        }
    }
}

