/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.BUILTIN_FUNCTIONS;
import org.kie.pmml.api.exceptions.KiePMMLException;

public class BUILTIN_FUNCTIONSTest {
    private static final List<BUILTIN_FUNCTIONS> supportedBuiltinFunctions = new ArrayList<BUILTIN_FUNCTIONS>();
    private static final List<BUILTIN_FUNCTIONS> unsupportedBuiltinFunctions;

    @Test
    public void getSupportedValueEmptyInput() {
        Object[] input = new Object[]{};
        supportedBuiltinFunctions.forEach(builtinFunction -> {
            try {
                builtinFunction.getValue(input);
                Assert.fail((String)"Expecting IllegalArgumentException");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
            }
        });
    }

    @Test
    public void getUnsupportedValue() {
        Object[] input = new Object[]{35, 12};
        unsupportedBuiltinFunctions.forEach(builtinFunction -> {
            try {
                builtinFunction.getValue(input);
                Assert.fail((String)"Expecting KiePMMLException");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof KiePMMLException));
            }
        });
    }

    @Test
    public void getAvgValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12, 347, 2, 123};
        Object retrieved = BUILTIN_FUNCTIONS.AVG.getValue(input1);
        Assert.assertEquals((Object)103.8, (Object)retrieved);
        Object[] input2 = new Object[]{35, 12, -347, 2, 123};
        retrieved = BUILTIN_FUNCTIONS.AVG.getValue(input2);
        Assert.assertEquals((Object)-35.0, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAvgValueWrongTypeInput() {
        Object[] input = new Object[]{"A", 34};
        BUILTIN_FUNCTIONS.AVG.getValue(input);
    }

    @Test
    public void getDivisionValueCorrectInput() {
        Object[] input = new Object[]{35, 5};
        Object retrieved = BUILTIN_FUNCTIONS.DIVISION.getValue(input);
        Assert.assertEquals((Object)7.0, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getDivisionValueWrongSizeInput() {
        Object[] input = new Object[]{35};
        BUILTIN_FUNCTIONS.DIVISION.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getDivisionValueWrongTypeInput() {
        Object[] input = new Object[]{"A", 34};
        BUILTIN_FUNCTIONS.DIVISION.getValue(input);
    }

    @Test
    public void getLowercaseValueCorrectInput() {
        Object[] input = new Object[]{"AwdC"};
        Object retrieved = BUILTIN_FUNCTIONS.LOWERCASE.getValue(input);
        Assert.assertEquals((Object)"awdc", (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getLowercaseValueWrongSizeInput() {
        Object[] input = new Object[]{"AwdC", "AwdB"};
        BUILTIN_FUNCTIONS.LOWERCASE.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getLowercaseValueWrongTypeInput() {
        Object[] input = new Object[]{34};
        BUILTIN_FUNCTIONS.LOWERCASE.getValue(input);
    }

    @Test
    public void getMaxValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12, 347, 2, 123};
        Object retrieved = BUILTIN_FUNCTIONS.MAX.getValue(input1);
        Assert.assertEquals((Object)347.0, (Object)retrieved);
        Object[] input2 = new Object[]{35, 12, -347, 2, 123};
        retrieved = BUILTIN_FUNCTIONS.MAX.getValue(input2);
        Assert.assertEquals((Object)123.0, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getMaxValueWrongTypeInput() {
        Object[] input = new Object[]{"A", 34};
        BUILTIN_FUNCTIONS.MAX.getValue(input);
    }

    @Test
    public void getMedianValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12, 347, 2, 123};
        Object retrieved = BUILTIN_FUNCTIONS.MEDIAN.getValue(input1);
        Assert.assertEquals((Object)35.0, (Object)retrieved);
        Object[] input2 = new Object[]{35, 12, 2, 123};
        retrieved = BUILTIN_FUNCTIONS.MEDIAN.getValue(input2);
        Assert.assertEquals((Object)23.5, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getMedianValueWrongTypeInput() {
        Object[] input = new Object[]{"A", 34};
        BUILTIN_FUNCTIONS.MEDIAN.getValue(input);
    }

    @Test
    public void getMinValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12, 347, 2, 123};
        Object retrieved = BUILTIN_FUNCTIONS.MIN.getValue(input1);
        Assert.assertEquals((Object)2.0, (Object)retrieved);
        Object[] input2 = new Object[]{35, 12, -347, 2, 123};
        retrieved = BUILTIN_FUNCTIONS.MIN.getValue(input2);
        Assert.assertEquals((Object)-347.0, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getMinValueWrongTypeInput() {
        Object[] input = new Object[]{"A", 34};
        BUILTIN_FUNCTIONS.MIN.getValue(input);
    }

    @Test
    public void getMinusValueCorrectInput() {
        Object[] input = new Object[]{35, 12};
        Object retrieved = BUILTIN_FUNCTIONS.MINUS.getValue(input);
        Assert.assertEquals((Object)23.0, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getMinusValueWrongSizeInput() {
        Object[] input = new Object[]{35};
        BUILTIN_FUNCTIONS.MINUS.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getMinusValueWrongTypeInput() {
        Object[] input = new Object[]{"A", 34};
        BUILTIN_FUNCTIONS.MINUS.getValue(input);
    }

    @Test
    public void getMultiValueCorrectInput() {
        Object[] input = new Object[]{7, 5};
        Object retrieved = BUILTIN_FUNCTIONS.MULTI.getValue(input);
        Assert.assertEquals((Object)35.0, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getMultiValueWrongSizeInput() {
        Object[] input = new Object[]{35};
        BUILTIN_FUNCTIONS.MULTI.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getMultiValueWrongTypeInput() {
        Object[] input = new Object[]{"A", 34};
        BUILTIN_FUNCTIONS.MULTI.getValue(input);
    }

    @Test
    public void getPlusValueCorrectInput() {
        Object[] input = new Object[]{35, 12};
        Object retrieved = BUILTIN_FUNCTIONS.PLUS.getValue(input);
        Assert.assertEquals((Object)47.0, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getPlusValueWrongSizeInput() {
        Object[] input = new Object[]{35};
        BUILTIN_FUNCTIONS.PLUS.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getPlusValueWrongTypeInput() {
        Object[] input = new Object[]{"A", 34};
        BUILTIN_FUNCTIONS.PLUS.getValue(input);
    }

    @Test
    public void getProductValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12, 347, 2, 123};
        Object retrieved = BUILTIN_FUNCTIONS.PRODUCT.getValue(input1);
        Assert.assertEquals((Object)3.585204E7, (Object)retrieved);
        Object[] input2 = new Object[]{35, 12, -2, 123};
        retrieved = BUILTIN_FUNCTIONS.PRODUCT.getValue(input2);
        Assert.assertEquals((Object)-103320.0, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getProductValueWrongTypeInput() {
        Object[] input = new Object[]{"A", 34};
        BUILTIN_FUNCTIONS.PRODUCT.getValue(input);
    }

    @Test
    public void getSumValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12, 347, 2, 123};
        Object retrieved = BUILTIN_FUNCTIONS.SUM.getValue(input1);
        Assert.assertEquals((Object)519.0, (Object)retrieved);
        Object[] input2 = new Object[]{35, 12, -347, 2, 123};
        retrieved = BUILTIN_FUNCTIONS.SUM.getValue(input2);
        Assert.assertEquals((Object)-175.0, (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getSumValueWrongTypeInput() {
        Object[] input = new Object[]{"A", 34};
        BUILTIN_FUNCTIONS.SUM.getValue(input);
    }

    @Test
    public void getUppercaseValueCorrectInput() {
        Object[] input = new Object[]{"AwdC"};
        Object retrieved = BUILTIN_FUNCTIONS.UPPERCASE.getValue(input);
        Assert.assertEquals((Object)"AWDC", (Object)retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getUppercaseValueWrongSizeInput() {
        Object[] input = new Object[]{"AwdC", "AwdB"};
        BUILTIN_FUNCTIONS.UPPERCASE.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getUppercaseValueWrongTypeInput() {
        Object[] input = new Object[]{34};
        BUILTIN_FUNCTIONS.UPPERCASE.getValue(input);
    }

    static {
        supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.AVG);
        supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.LOWERCASE);
        supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.MAX);
        supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.MEDIAN);
        supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.MIN);
        supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.MINUS);
        supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.MULTI);
        supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.DIVISION);
        supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.PLUS);
        supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.PRODUCT);
        supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.SUM);
        supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.UPPERCASE);
        unsupportedBuiltinFunctions = new ArrayList<BUILTIN_FUNCTIONS>();
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.LOG10);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.LN);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.SQRT);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.ABS);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.EXP);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.POW);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.THRESHOLD);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.FLOOR);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.CEIL);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.ROUND);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.MODULO);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.IS_MISSING);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.IS_NOT_MISSING);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.IS_VALID);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.IS_NOT_VALID);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.EQUAL);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.NOT_EQUAL);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.LESS_THAN);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.LESS_OR_EQUAL);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.GREATER_THAN);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.GREATER_OR_EQUAL);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.AND);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.OR);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.NOT);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.IS_IN);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.IS_NOT_IN);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.IF);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.STRING_LENGTH);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.SUBSTRING);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.TRIM_BLANKS);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.CONCAT);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.REPLACE);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.MATCHES);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.FORMAT_NUMBER);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.FORMAT_DATE_TIME);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.DATE_DAYS_SINCE_YEAR);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.DATE_SECONDS_SINCE_YEAR);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.DATE_SECONDS_SINCE_MIDNIGHT);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.NORMAL_CDF);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.NORMAL_PDF);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.STD_NORMAL_CDF);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.STD_NORMAL_PDF);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.ERF);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.NORMAL_IDF);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.STD_NORMAL_IDF);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.EXPM1);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.HYPOT);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.LN1P);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.RINT);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.SIN);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.ASIN);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.SINH);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.COS);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.ACOS);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.COSH);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.TAN);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.ATAN);
        unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.TANH);
    }
}

