/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.utils;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.utils.ConverterTypeUtil;

public class ConverterTypeUtilTest {
    private static Map<String, Object> CONVERTIBLE_FROM_STRING = new HashMap<String, Object>();
    private static Map<String, Object> UNCONVERTIBLE_FROM_STRING;
    private static Map<Object, String> CONVERTIBLE_TO_STRING;
    private static Map<Double, Number> CONVERTIBLE_FROM_DOUBLE;
    private static Map<Double, Object> UNCONVERTIBLE_FROM_DOUBLE;
    private static Map<Integer, Number> CONVERTIBLE_FROM_INTEGER;
    private static Map<Integer, Object> UNCONVERTIBLE_FROM_INTEGER;

    @Test
    public void convertConvertibleToString() {
        CONVERTIBLE_TO_STRING.forEach((s, o) -> {
            Class<?> expectedClass = o.getClass();
            Object retrieved = ConverterTypeUtil.convert(expectedClass, (Object)s);
            Assert.assertEquals((Object)retrieved, (Object)o);
        });
    }

    @Test
    public void convertConvertibleFromString() {
        CONVERTIBLE_FROM_STRING.forEach((s, expected) -> {
            Class<?> expectedClass = expected.getClass();
            Object retrieved = ConverterTypeUtil.convert(expectedClass, (Object)s);
            Assert.assertEquals((Object)expected, (Object)retrieved);
        });
    }

    @Test
    public void convertUnconvertibleFromString() {
        UNCONVERTIBLE_FROM_STRING.forEach((s, o) -> {
            Class<?> expectedClass = o.getClass();
            try {
                ConverterTypeUtil.convert(expectedClass, (Object)s);
                Assert.fail((String)String.format("Expecting KiePMMLException for %s %s", s, o));
            }
            catch (Exception e) {
                Assert.assertEquals(KiePMMLException.class, e.getClass());
            }
        });
    }

    @Test
    public void convertConvertibleFromInteger() {
        CONVERTIBLE_FROM_INTEGER.forEach((s, expected) -> {
            Class<?> expectedClass = expected.getClass();
            Object retrieved = ConverterTypeUtil.convert(expectedClass, (Object)s);
            Assert.assertEquals((Object)expected, (Object)retrieved);
        });
    }

    @Test
    public void convertUnconvertibleFromInteger() {
        UNCONVERTIBLE_FROM_INTEGER.forEach((s, o) -> {
            Class<?> expectedClass = o.getClass();
            try {
                ConverterTypeUtil.convert(expectedClass, (Object)s);
                Assert.fail((String)String.format("Expecting KiePMMLException for %s %s", s, o));
            }
            catch (Exception e) {
                Assert.assertEquals(KiePMMLException.class, e.getClass());
            }
        });
    }

    @Test
    public void convertConvertibleFromDouble() {
        CONVERTIBLE_FROM_DOUBLE.forEach((s, expected) -> {
            Class<?> expectedClass = expected.getClass();
            Object retrieved = ConverterTypeUtil.convert(expectedClass, (Object)s);
            Assert.assertEquals((Object)expected, (Object)retrieved);
        });
    }

    @Test
    public void convertUnconvertibleFromDouble() {
        UNCONVERTIBLE_FROM_DOUBLE.forEach((s, o) -> {
            Class<?> expectedClass = o.getClass();
            try {
                ConverterTypeUtil.convert(expectedClass, (Object)s);
                Assert.fail((String)String.format("Expecting KiePMMLException for %s %s", s, o));
            }
            catch (Exception e) {
                Assert.assertEquals(KiePMMLException.class, e.getClass());
            }
        });
    }

    static {
        CONVERTIBLE_FROM_STRING.put("true", true);
        CONVERTIBLE_FROM_STRING.put("false", false);
        CONVERTIBLE_FROM_STRING.put("23423", 23423);
        CONVERTIBLE_FROM_STRING.put("3476345444745745746", 3476345444745745746L);
        CONVERTIBLE_FROM_STRING.put("234.23", 234.23);
        CONVERTIBLE_FROM_STRING.put("234234.23", Float.valueOf(234234.23f));
        CONVERTIBLE_FROM_STRING.put("A", Character.valueOf('A'));
        CONVERTIBLE_FROM_STRING.put("2", (byte)2);
        CONVERTIBLE_FROM_STRING.put("234", (short)234);
        UNCONVERTIBLE_FROM_STRING = new HashMap<String, Object>();
        UNCONVERTIBLE_FROM_STRING.put("true", 23423);
        UNCONVERTIBLE_FROM_STRING.put("false", 3476345444745745746L);
        UNCONVERTIBLE_FROM_STRING.put("23423", true);
        UNCONVERTIBLE_FROM_STRING.put("3476345444745745746", (byte)2);
        UNCONVERTIBLE_FROM_STRING.put("234.23", 3476345444745745746L);
        UNCONVERTIBLE_FROM_STRING.put("234234.23", (short)234);
        UNCONVERTIBLE_FROM_STRING.put("A", (byte)2);
        UNCONVERTIBLE_FROM_STRING.put("Arwtrwetwe", Character.valueOf('A'));
        CONVERTIBLE_TO_STRING = new HashMap<Object, String>();
        CONVERTIBLE_TO_STRING.put(true, "true");
        CONVERTIBLE_TO_STRING.put(false, "false");
        CONVERTIBLE_TO_STRING.put(23423, "23423");
        CONVERTIBLE_TO_STRING.put(3476345444745745746L, "3476345444745745746");
        CONVERTIBLE_TO_STRING.put(234.23, "234.23");
        CONVERTIBLE_TO_STRING.put(Float.valueOf(234234.23f), "234234.23");
        CONVERTIBLE_TO_STRING.put(Character.valueOf('A'), "A");
        CONVERTIBLE_TO_STRING.put((byte)2, "2");
        CONVERTIBLE_TO_STRING.put((short)234, "234");
        CONVERTIBLE_FROM_DOUBLE = new HashMap<Double, Number>();
        CONVERTIBLE_FROM_DOUBLE.put(23422.65, 23423);
        CONVERTIBLE_FROM_DOUBLE.put(3.4763454447449E11, 347634544474L);
        CONVERTIBLE_FROM_DOUBLE.put(234234.23, Float.valueOf(234234.23f));
        CONVERTIBLE_FROM_DOUBLE.put(2.345, (byte)2);
        CONVERTIBLE_FROM_DOUBLE.put(233.789, (short)234);
        UNCONVERTIBLE_FROM_DOUBLE = new HashMap<Double, Object>();
        UNCONVERTIBLE_FROM_DOUBLE.put(3.476345444745746E18, true);
        UNCONVERTIBLE_FROM_DOUBLE.put(234234.23, Character.valueOf('A'));
        CONVERTIBLE_FROM_INTEGER = new HashMap<Integer, Number>();
        CONVERTIBLE_FROM_INTEGER.put(23423, 23423.0);
        CONVERTIBLE_FROM_INTEGER.put(347634544, 347634544L);
        CONVERTIBLE_FROM_INTEGER.put(234234, Float.valueOf(234234.0f));
        CONVERTIBLE_FROM_INTEGER.put(2, (byte)2);
        CONVERTIBLE_FROM_INTEGER.put(233, (short)233);
        UNCONVERTIBLE_FROM_INTEGER = new HashMap<Integer, Object>();
        UNCONVERTIBLE_FROM_INTEGER.put(347634544, true);
        UNCONVERTIBLE_FROM_INTEGER.put(234234, Character.valueOf('A'));
    }
}

