/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.BUILTIN_FUNCTIONS;
import org.kie.pmml.api.enums.builtinfunctions.ArithmeticFunctionsTest;
import org.kie.pmml.api.enums.builtinfunctions.BooleanFunctionsTest;
import org.kie.pmml.api.enums.builtinfunctions.DateFunctionsTest;
import org.kie.pmml.api.enums.builtinfunctions.DistributionFunctionsTest;
import org.kie.pmml.api.enums.builtinfunctions.MathematicalFunctionsTest;
import org.kie.pmml.api.enums.builtinfunctions.StringFunctionsTest;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.models.MiningField;

public class BUILTIN_FUNCTIONSTest {
    private static final List<BUILTIN_FUNCTIONS> supportedBuiltinFunctions = new ArrayList<BUILTIN_FUNCTIONS>();
    private static final List<BUILTIN_FUNCTIONS> unsupportedBuiltinFunctions;

    @Test
    public void getSupportedValueEmptyInput() {
        Object[] input = new Object[]{};
        supportedBuiltinFunctions.forEach(builtinFunction -> {
            try {
                builtinFunction.getValue(input, new MiningField(null, null, null, null, null, null, null, null, null, null));
                Assert.fail((String)"Expecting IllegalArgumentException");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
            }
        });
    }

    @Test
    public void getUnsupportedValue() {
        Object[] input = new Object[]{35, 12};
        unsupportedBuiltinFunctions.forEach(builtinFunction -> {
            try {
                builtinFunction.getValue(input, null);
                Assert.fail((String)"Expecting KiePMMLException");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof KiePMMLException));
            }
        });
    }

    @Test
    public void checkNumbersCorrectInput() {
        Object[] input = new Object[]{35, 12, 347, 2, 123};
        BUILTIN_FUNCTIONS.checkNumbers((Object[])input, (int)input.length);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkNumbersWrongTypeInput() {
        Object[] input = new Object[]{35, 12, "347", 2, 123};
        BUILTIN_FUNCTIONS.checkNumbers((Object[])input, (int)input.length);
    }

    @Test
    public void checkStringsCorrectInput() {
        Object[] input = new Object[]{"35", "12", "347", "2", "123"};
        BUILTIN_FUNCTIONS.checkStrings((Object[])input, (int)input.length);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkStringsWrongTypeInput() {
        Object[] input = new Object[]{"35", 12, "347", "2", "123"};
        BUILTIN_FUNCTIONS.checkStrings((Object[])input, (int)input.length);
    }

    @Test
    public void checkBooleansCorrectInput() {
        Object[] input = new Object[]{true, Boolean.valueOf("false")};
        BUILTIN_FUNCTIONS.checkBooleans((Object[])input, (int)input.length);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkBooleansWrongTypeInput() {
        Object[] input = new Object[]{true, "false"};
        BUILTIN_FUNCTIONS.checkBooleans((Object[])input, (int)input.length);
    }

    static {
        ArithmeticFunctionsTest.supportedArithmeticFunctions.forEach(fun -> supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.byName((String)fun.getName())));
        BooleanFunctionsTest.supportedBooleanFunctions.forEach(fun -> supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.byName((String)fun.getName())));
        DateFunctionsTest.supportedDateFunctions.forEach(fun -> supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.byName((String)fun.getName())));
        DistributionFunctionsTest.supportedDistributionFunctions.forEach(fun -> supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.byName((String)fun.getName())));
        MathematicalFunctionsTest.supportedMathematicalFunctions.forEach(fun -> supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.byName((String)fun.getName())));
        StringFunctionsTest.supportedStringFunctions.forEach(fun -> supportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.byName((String)fun.getName())));
        unsupportedBuiltinFunctions = new ArrayList<BUILTIN_FUNCTIONS>();
        ArithmeticFunctionsTest.unsupportedArithmeticFunctions.forEach(fun -> unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.byName((String)fun.getName())));
        BooleanFunctionsTest.unsupportedBooleanFunctions.forEach(fun -> unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.byName((String)fun.getName())));
        DateFunctionsTest.unsupportedDateFunctions.forEach(fun -> unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.byName((String)fun.getName())));
        DistributionFunctionsTest.unsupportedDistributionFunctions.forEach(fun -> unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.byName((String)fun.getName())));
        MathematicalFunctionsTest.unsupportedMathematicalFunctions.forEach(fun -> unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.byName((String)fun.getName())));
        StringFunctionsTest.unsupportedStringFunctions.forEach(fun -> unsupportedBuiltinFunctions.add(BUILTIN_FUNCTIONS.byName((String)fun.getName())));
    }
}

