/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.builtinfunctions.MathematicalFunctions;

public class MathematicalFunctionsTest {
    public static final List<MathematicalFunctions> supportedMathematicalFunctions = new ArrayList<MathematicalFunctions>();
    public static final List<MathematicalFunctions> unsupportedMathematicalFunctions;

    @Test
    public void getExpm1ValueCorrectInput() {
        Object[] input = new Object[]{24.11};
        Object retrieved = MathematicalFunctions.EXPM1.getValue(input);
        Assert.assertEquals((double)2.956922613825104E10, (double)((Double)retrieved), (double)1.0E-7);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getExpm1ValueWrongSizeInput() {
        Object[] input = new Object[]{34, 24.11};
        MathematicalFunctions.EXPM1.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getExpm1ValueWrongTypeInput() {
        Object[] input = new Object[]{"22.1"};
        MathematicalFunctions.EXPM1.getValue(input);
    }

    @Test
    public void getHypotValueCorrectInput() {
        Object[] input = new Object[]{24.11, 11};
        Object retrieved = MathematicalFunctions.HYPOT.getValue(input);
        Assert.assertEquals((double)26.5, (double)((Double)retrieved), (double)0.001);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getHypotValueWrongSizeInput() {
        Object[] input = new Object[]{34};
        MathematicalFunctions.HYPOT.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getHypotValueWrongTypeInput() {
        Object[] input = new Object[]{"22.1", 11};
        MathematicalFunctions.HYPOT.getValue(input);
    }

    @Test
    public void getLn1pValueCorrectInput() {
        Object[] input = new Object[]{24.11};
        Object retrieved = MathematicalFunctions.LN1P.getValue(input);
        Assert.assertEquals((double)3.223, (double)((Double)retrieved), (double)0.001);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getLn1pValueWrongSizeInput() {
        Object[] input = new Object[]{34, 11};
        MathematicalFunctions.LN1P.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getLn1pValueWrongTypeInput() {
        Object[] input = new Object[]{"22.1"};
        MathematicalFunctions.LN1P.getValue(input);
    }

    @Test
    public void getRintValueCorrectInput() {
        Object[] input1 = new Object[]{24.11};
        Object retrieved = MathematicalFunctions.RINT.getValue(input1);
        Assert.assertEquals((double)24.0, (double)((Double)retrieved), (double)0.0);
        Object[] input2 = new Object[]{24.91};
        retrieved = MathematicalFunctions.RINT.getValue(input2);
        Assert.assertEquals((double)25.0, (double)((Double)retrieved), (double)0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getRintValueWrongSizeInput() {
        Object[] input = new Object[]{34, 11};
        MathematicalFunctions.RINT.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getRintValueWrongTypeInput() {
        Object[] input = new Object[]{"22.1"};
        MathematicalFunctions.RINT.getValue(input);
    }

    @Test
    public void getSinValueCorrectInput() {
        Object[] input = new Object[]{24.11};
        Object retrieved = MathematicalFunctions.SIN.getValue(input);
        Assert.assertEquals((double)-0.8535, (double)((Double)retrieved), (double)1.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getSinValueWrongSizeInput() {
        Object[] input = new Object[]{34, 11};
        MathematicalFunctions.SIN.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getSinValueWrongTypeInput() {
        Object[] input = new Object[]{"22.1"};
        MathematicalFunctions.SIN.getValue(input);
    }

    @Test
    public void getAsinValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.ASIN.getValue(input);
        Assert.assertEquals((double)1.1944, (double)((Double)retrieved), (double)1.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAsinValueWrongSizeInput() {
        Object[] input = new Object[]{34, 11};
        MathematicalFunctions.ASIN.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAsinValueWrongTypeInput() {
        Object[] input = new Object[]{"22.1"};
        MathematicalFunctions.ASIN.getValue(input);
    }

    @Test
    public void getSinhValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.SINH.getValue(input);
        Assert.assertEquals((double)1.0699, (double)((Double)retrieved), (double)1.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getSinhValueWrongSizeInput() {
        Object[] input = new Object[]{34, 11};
        MathematicalFunctions.SINH.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getSinhValueWrongTypeInput() {
        Object[] input = new Object[]{"22.1"};
        MathematicalFunctions.SINH.getValue(input);
    }

    @Test
    public void getCosValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.COS.getValue(input);
        Assert.assertEquals((double)0.5978, (double)((Double)retrieved), (double)1.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getCosValueWrongSizeInput() {
        Object[] input = new Object[]{34, 11};
        MathematicalFunctions.COS.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getCosValueWrongTypeInput() {
        Object[] input = new Object[]{"22.1"};
        MathematicalFunctions.COS.getValue(input);
    }

    @Test
    public void getAcosValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.ACOS.getValue(input);
        Assert.assertEquals((double)0.3763, (double)((Double)retrieved), (double)1.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAcosValueWrongSizeInput() {
        Object[] input = new Object[]{34, 11};
        MathematicalFunctions.ACOS.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAcosValueWrongTypeInput() {
        Object[] input = new Object[]{"22.1"};
        MathematicalFunctions.ACOS.getValue(input);
    }

    @Test
    public void getCoshValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.COSH.getValue(input);
        Assert.assertEquals((double)1.4645, (double)((Double)retrieved), (double)1.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getCoshValueWrongSizeInput() {
        Object[] input = new Object[]{34, 11};
        MathematicalFunctions.COSH.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getCoshValueWrongTypeInput() {
        Object[] input = new Object[]{"22.1"};
        MathematicalFunctions.COSH.getValue(input);
    }

    @Test
    public void getTanValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.TAN.getValue(input);
        Assert.assertEquals((double)1.3408, (double)((Double)retrieved), (double)1.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getTanValueWrongSizeInput() {
        Object[] input = new Object[]{34, 11};
        MathematicalFunctions.TAN.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getTanValueWrongTypeInput() {
        Object[] input = new Object[]{"22.1"};
        MathematicalFunctions.TAN.getValue(input);
    }

    @Test
    public void getAtanValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.ATAN.getValue(input);
        Assert.assertEquals((double)0.7491, (double)((Double)retrieved), (double)1.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAtanValueWrongSizeInput() {
        Object[] input = new Object[]{34, 11};
        MathematicalFunctions.ATAN.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAtanValueWrongTypeInput() {
        Object[] input = new Object[]{"22.1"};
        MathematicalFunctions.ATAN.getValue(input);
    }

    @Test
    public void getTanhValueCorrectInput() {
        Object[] input = new Object[]{0.93};
        Object retrieved = MathematicalFunctions.TANH.getValue(input);
        Assert.assertEquals((double)0.7305, (double)((Double)retrieved), (double)1.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getTanhValueWrongSizeInput() {
        Object[] input = new Object[]{34, 11};
        MathematicalFunctions.TANH.getValue(input);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getTanhValueWrongTypeInput() {
        Object[] input = new Object[]{"22.1"};
        MathematicalFunctions.TANH.getValue(input);
    }

    static {
        supportedMathematicalFunctions.add(MathematicalFunctions.EXPM1);
        supportedMathematicalFunctions.add(MathematicalFunctions.HYPOT);
        supportedMathematicalFunctions.add(MathematicalFunctions.LN1P);
        supportedMathematicalFunctions.add(MathematicalFunctions.RINT);
        supportedMathematicalFunctions.add(MathematicalFunctions.SIN);
        supportedMathematicalFunctions.add(MathematicalFunctions.ASIN);
        supportedMathematicalFunctions.add(MathematicalFunctions.SINH);
        supportedMathematicalFunctions.add(MathematicalFunctions.COS);
        supportedMathematicalFunctions.add(MathematicalFunctions.ACOS);
        supportedMathematicalFunctions.add(MathematicalFunctions.COSH);
        supportedMathematicalFunctions.add(MathematicalFunctions.TAN);
        supportedMathematicalFunctions.add(MathematicalFunctions.ATAN);
        supportedMathematicalFunctions.add(MathematicalFunctions.TANH);
        unsupportedMathematicalFunctions = new ArrayList<MathematicalFunctions>();
    }
}

