/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.enums.builtinfunctions.BooleanFunctions;
import org.kie.pmml.api.models.Interval;
import org.kie.pmml.api.models.MiningField;

public class BooleanFunctionsTest {
    public static final List<BooleanFunctions> supportedBooleanFunctions;
    public static final List<BooleanFunctions> unsupportedBooleanFunctions;
    private static final MiningField EMPTY_MINING_FIELD;

    @Test
    void getIsMissingValueCorrectInput() {
        Object[] input1 = new Object[]{null};
        Object retrieved = BooleanFunctions.IS_MISSING.getValue(input1, EMPTY_MINING_FIELD);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{35};
        retrieved = BooleanFunctions.IS_MISSING.getValue(input2, EMPTY_MINING_FIELD);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        for (INVALID_VALUE_TREATMENT_METHOD invalidValueTreatmentMethod : INVALID_VALUE_TREATMENT_METHOD.values()) {
            MiningField referredByFieldRef = this.getReferredByFieldRef(invalidValueTreatmentMethod, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
            boolean expected = INVALID_VALUE_TREATMENT_METHOD.AS_MISSING.equals((Object)invalidValueTreatmentMethod);
            Assertions.assertThat((Object)BooleanFunctions.IS_MISSING.getValue(input2, referredByFieldRef)).isEqualTo((Object)expected);
        }
    }

    @Test
    void getIsMissingValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 34, 34};
            BooleanFunctions.IS_MISSING.getValue(input, EMPTY_MINING_FIELD);
        });
    }

    @Test
    void getIsMissingValueNoMiningField() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            BooleanFunctions.IS_MISSING.getValue(input, null);
        });
    }

    @Test
    void getIsNotMissingValueCorrectInput() {
        Object[] input1 = new Object[]{35};
        Object retrieved = BooleanFunctions.IS_NOT_MISSING.getValue(input1, EMPTY_MINING_FIELD);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{null};
        retrieved = BooleanFunctions.IS_NOT_MISSING.getValue(input2, EMPTY_MINING_FIELD);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        for (INVALID_VALUE_TREATMENT_METHOD invalidValueTreatmentMethod : INVALID_VALUE_TREATMENT_METHOD.values()) {
            MiningField referredByFieldRef = this.getReferredByFieldRef(invalidValueTreatmentMethod, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
            boolean expected = !INVALID_VALUE_TREATMENT_METHOD.AS_MISSING.equals((Object)invalidValueTreatmentMethod);
            Assertions.assertThat((Object)BooleanFunctions.IS_NOT_MISSING.getValue(input1, referredByFieldRef)).isEqualTo((Object)expected);
        }
    }

    @Test
    void getIsNotMissingValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 34, 34};
            BooleanFunctions.IS_NOT_MISSING.getValue(input, EMPTY_MINING_FIELD);
        });
    }

    @Test
    void getIsNotMissingValueNoMiningField() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            BooleanFunctions.IS_NOT_MISSING.getValue(input, null);
        });
    }

    @Test
    void getIsValidValueCorrectInput() {
        Object[] input1 = new Object[]{35};
        MiningField referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)30, (Number)40), new Interval((Number)41, (Number)50)));
        Object retrieved = BooleanFunctions.IS_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "35"), Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "36"), Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input2 = new Object[]{"VALUE"};
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "VALUE"), Collections.emptyList());
        retrieved = BooleanFunctions.IS_VALID.getValue(input2, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "VELUE"), Collections.emptyList());
        retrieved = BooleanFunctions.IS_VALID.getValue(input2, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input3 = new Object[]{null};
        retrieved = BooleanFunctions.IS_VALID.getValue(input3, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test
    void getIsValidValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 34};
            MiningField referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)30, (Number)40), new Interval((Number)41, (Number)50)));
            BooleanFunctions.IS_VALID.getValue(input, referredByFieldRef);
        });
    }

    @Test
    void getIsValidValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"34"};
            MiningField referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)30, (Number)40), new Interval((Number)41, (Number)50)));
            BooleanFunctions.IS_VALID.getValue(input, referredByFieldRef);
        });
    }

    @Test
    void getIsValidValueWrongNoMiningField() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            BooleanFunctions.IS_VALID.getValue(input, null);
        });
    }

    @Test
    void getIsNotValidValueCorrectInput() {
        Object[] input1 = new Object[]{35};
        MiningField referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)30, (Number)40), new Interval((Number)41, (Number)50)));
        Object retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "35"), Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        referredByFieldRef = this.getReferredByFieldRef(INVALID_VALUE_TREATMENT_METHOD.AS_MISSING, Arrays.asList("123", "36"), Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        referredByFieldRef = this.getReferredByFieldRef(INVALID_VALUE_TREATMENT_METHOD.AS_IS, Arrays.asList("123", "36"), Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "36"), Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)41, (Number)50)));
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input1, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{"VALUE"};
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "VALUE"), Collections.emptyList());
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input2, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        referredByFieldRef = this.getReferredByFieldRef(null, Arrays.asList("123", "VELUE"), Collections.emptyList());
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input2, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input3 = new Object[]{null};
        retrieved = BooleanFunctions.IS_NOT_VALID.getValue(input3, referredByFieldRef);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test
    void getIsNotValidValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 34};
            MiningField referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)30, (Number)40), new Interval((Number)41, (Number)50)));
            BooleanFunctions.IS_NOT_VALID.getValue(input, referredByFieldRef);
        });
    }

    @Test
    void getIsNotValidValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"34"};
            MiningField referredByFieldRef = this.getReferredByFieldRef(null, null, Arrays.asList(new Interval((Number)20, (Number)29), new Interval((Number)30, (Number)40), new Interval((Number)41, (Number)50)));
            BooleanFunctions.IS_NOT_VALID.getValue(input, referredByFieldRef);
        });
    }

    @Test
    void getIsNotValidValueWrongNoMiningField() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            BooleanFunctions.IS_NOT_VALID.getValue(input, null);
        });
    }

    @Test
    void getEqualValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12};
        Object retrieved = BooleanFunctions.EQUAL.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input2 = new Object[]{35, 35};
        retrieved = BooleanFunctions.EQUAL.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
    }

    @Test
    void getEqualValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 34, 34};
            BooleanFunctions.EQUAL.getValue(input, null);
        });
    }

    @Test
    void getNotEqualValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12};
        Object retrieved = BooleanFunctions.NOT_EQUAL.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{35, 35};
        retrieved = BooleanFunctions.NOT_EQUAL.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test
    void getNotEqualValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, 34, 34};
            BooleanFunctions.NOT_EQUAL.getValue(input, null);
        });
    }

    @Test
    void getLessThanValueCorrectInput() {
        Object[] input1 = new Object[]{35, 37};
        Object retrieved = BooleanFunctions.LESS_THAN.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{35, 35};
        retrieved = BooleanFunctions.LESS_THAN.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input3 = new Object[]{35, 12};
        retrieved = BooleanFunctions.LESS_THAN.getValue(input3, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test
    void getLessThanValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, "A"};
            BooleanFunctions.LESS_THAN.getValue(input, null);
        });
    }

    @Test
    void getLessOrEqualValueCorrectInput() {
        Object[] input1 = new Object[]{35, 37};
        Object retrieved = BooleanFunctions.LESS_OR_EQUAL.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{35, 35};
        retrieved = BooleanFunctions.LESS_OR_EQUAL.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input3 = new Object[]{35, 12};
        retrieved = BooleanFunctions.LESS_OR_EQUAL.getValue(input3, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test
    void getLessOrEqualValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, "A"};
            BooleanFunctions.LESS_OR_EQUAL.getValue(input, null);
        });
    }

    @Test
    void getGreaterThanValueCorrectInput() {
        Object[] input1 = new Object[]{35, 37};
        Object retrieved = BooleanFunctions.GREATER_THAN.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input2 = new Object[]{35, 35};
        retrieved = BooleanFunctions.GREATER_THAN.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input3 = new Object[]{35, 12};
        retrieved = BooleanFunctions.GREATER_THAN.getValue(input3, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
    }

    @Test
    void getGreaterThanValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, "A"};
            BooleanFunctions.GREATER_THAN.getValue(input, null);
        });
    }

    @Test
    void getGreaterOrEqualValueCorrectInput() {
        Object[] input1 = new Object[]{35, 37};
        Object retrieved = BooleanFunctions.GREATER_OR_EQUAL.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input2 = new Object[]{35, 35};
        retrieved = BooleanFunctions.GREATER_OR_EQUAL.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input3 = new Object[]{35, 12};
        retrieved = BooleanFunctions.GREATER_OR_EQUAL.getValue(input3, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
    }

    @Test
    void getGreaterOrEqualValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34, "A"};
            BooleanFunctions.GREATER_OR_EQUAL.getValue(input, null);
        });
    }

    @Test
    void getAndValueCorrectInput() {
        Object[] input1 = new Object[]{true, Boolean.valueOf("false")};
        Object retrieved = BooleanFunctions.AND.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input2 = new Object[]{true, Boolean.valueOf("true")};
        retrieved = BooleanFunctions.AND.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
    }

    @Test
    void getAndValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{true, "false"};
            BooleanFunctions.AND.getValue(input, null);
        });
    }

    @Test
    void getOrValueCorrectInput() {
        Object[] input1 = new Object[]{true, Boolean.valueOf("false")};
        Object retrieved = BooleanFunctions.OR.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{false, Boolean.valueOf("true")};
        retrieved = BooleanFunctions.OR.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input3 = new Object[]{false, Boolean.valueOf("false")};
        retrieved = BooleanFunctions.OR.getValue(input3, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test
    void getOrValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{true, "false"};
            BooleanFunctions.OR.getValue(input, null);
        });
    }

    @Test
    void getNotValueCorrectInput() {
        Object[] input1 = new Object[]{true};
        Object retrieved = BooleanFunctions.NOT.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
        Object[] input2 = new Object[]{Boolean.valueOf("false")};
        retrieved = BooleanFunctions.NOT.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
    }

    @Test
    void getNotValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"false"};
            BooleanFunctions.NOT.getValue(input, null);
        });
    }

    @Test
    void getIsInValueCorrectInput() {
        Object[] input1 = new Object[]{35, 12, 35, 435, "A"};
        Object retrieved = BooleanFunctions.IS_IN.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{35, 36, "35"};
        retrieved = BooleanFunctions.IS_IN.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test
    void getIsInEqualValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            BooleanFunctions.IS_IN.getValue(input, null);
        });
    }

    @Test
    void getIsNotInValueCorrectInput() {
        Object[] input1 = new Object[]{35, 36, "35"};
        Object retrieved = BooleanFunctions.IS_NOT_IN.getValue(input1, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        Object[] input2 = new Object[]{35, 12, 35, 435, "A"};
        retrieved = BooleanFunctions.IS_NOT_IN.getValue(input2, null);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test
    void getIsNotInEqualValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            BooleanFunctions.IS_NOT_IN.getValue(input, null);
        });
    }

    @Test
    void getIfFValueCorrectInput() {
        Object[] input1 = new Object[]{true, 36, "35"};
        Object retrieved = BooleanFunctions.IF.getValue(input1, null);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)36);
        Object[] input2 = new Object[]{false, 12, 35};
        retrieved = BooleanFunctions.IF.getValue(input2, null);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)35);
        Object[] input3 = new Object[]{false, 12};
        retrieved = BooleanFunctions.IF.getValue(input3, null);
        Assertions.assertThat((Object)retrieved).isNull();
    }

    @Test
    void getIfFEqualValueWrongSizeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{34};
            BooleanFunctions.IF.getValue(input, null);
        });
    }

    @Test
    void getIfFEqualValueWrongTypeInput() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            Object[] input = new Object[]{"true", 36, "35"};
            BooleanFunctions.IF.getValue(input, null);
        });
    }

    private MiningField getReferredByFieldRef(INVALID_VALUE_TREATMENT_METHOD invalidValueTreatmentMethod, List<String> allowedValues, List<Interval> intervals) {
        return new MiningField("TEST", null, null, null, null, invalidValueTreatmentMethod, null, null, allowedValues, intervals);
    }

    static {
        EMPTY_MINING_FIELD = new MiningField("TEST", null, null, null, null, null, null, null, null, null);
        supportedBooleanFunctions = new ArrayList<BooleanFunctions>();
        supportedBooleanFunctions.add(BooleanFunctions.EQUAL);
        supportedBooleanFunctions.add(BooleanFunctions.NOT_EQUAL);
        supportedBooleanFunctions.add(BooleanFunctions.LESS_THAN);
        supportedBooleanFunctions.add(BooleanFunctions.LESS_OR_EQUAL);
        supportedBooleanFunctions.add(BooleanFunctions.GREATER_THAN);
        supportedBooleanFunctions.add(BooleanFunctions.GREATER_OR_EQUAL);
        supportedBooleanFunctions.add(BooleanFunctions.AND);
        supportedBooleanFunctions.add(BooleanFunctions.OR);
        supportedBooleanFunctions.add(BooleanFunctions.NOT);
        supportedBooleanFunctions.add(BooleanFunctions.IS_MISSING);
        supportedBooleanFunctions.add(BooleanFunctions.IS_NOT_MISSING);
        supportedBooleanFunctions.add(BooleanFunctions.IS_VALID);
        supportedBooleanFunctions.add(BooleanFunctions.IS_NOT_VALID);
        supportedBooleanFunctions.add(BooleanFunctions.IS_IN);
        supportedBooleanFunctions.add(BooleanFunctions.IS_NOT_IN);
        supportedBooleanFunctions.add(BooleanFunctions.IF);
        unsupportedBooleanFunctions = new ArrayList<BooleanFunctions>();
    }
}

