/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.benchmarks.regression;

import java.util.concurrent.TimeUnit;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.io.ResourceType;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.runtime.KieSession;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.evaluator.api.executor.PMMLRuntimeInternal;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.SingleShotTime})
@State(value=Scope.Thread)
@Warmup(iterations=30000)
@Measurement(iterations=5000)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public abstract class AbstractRegressionBenchmark {
    protected String modelName;
    protected String fileName;
    protected PMMLContext pmmlContext;
    private PMMLRuntimeInternal pmmlRuntime;
    private KiePMMLModel model;

    protected void setupModel() throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write(KieServices.get().getResources().newClassPathResource(this.fileName).setResourceType(ResourceType.PMML));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs).buildAll();
        ReleaseId relId = kieBuilder.getKieModule().getReleaseId();
        Results res = kieBuilder.getResults();
        KieBase kbase = ks.newKieContainer(relId).getKieBase();
        KieSession session = kbase.newKieSession();
        this.pmmlRuntime = (PMMLRuntimeInternal)session.getKieRuntime(PMMLRuntimeInternal.class);
        this.model = (KiePMMLModel)this.pmmlRuntime.getKiePMMLModel(this.modelName).orElseThrow(() -> new KiePMMLException("Failed to retrieve the model"));
    }

    protected PMML4Result evaluate() {
        return this.pmmlRuntime.evaluate(this.model.getName(), this.pmmlContext);
    }
}

