/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.benchmarks.regression;

import java.util.concurrent.TimeUnit;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.pmml.benchmarks.regression.AbstractRegressionBenchmark;
import org.kie.pmml.evaluator.core.PMMLContextImpl;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BenchmarkMode(value={Mode.Throughput})
@State(value=Scope.Thread)
@Warmup(iterations=2)
@Measurement(iterations=5, time=30)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=5)
public class RegressionBenchmark
extends AbstractRegressionBenchmark {
    private static final Logger logger = LoggerFactory.getLogger(RegressionBenchmark.class);

    @Override
    @Setup
    public void setupModel() throws Exception {
        logger.debug("setup model...");
        this.modelName = "Sample for linear regression";
        this.fileName = "LinearRegressionSample.pmml";
        super.setupModel();
        logger.debug("setup pmmlContext...");
        PMMLRequestData pmmlRequestData = new PMMLRequestData("123", this.modelName);
        pmmlRequestData.addRequestParam("age", (Object)22);
        pmmlRequestData.addRequestParam("salary", (Object)2345.43);
        pmmlRequestData.addRequestParam("car_location", (Object)"carpark");
        this.pmmlContext = new PMMLContextImpl(pmmlRequestData);
    }

    @Override
    @Benchmark
    public PMML4Result evaluate() {
        return super.evaluate();
    }
}

