/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.enums;

import java.util.Arrays;
import org.kie.pmml.commons.exceptions.KieEnumException;
import org.kie.pmml.commons.exceptions.KiePMMLException;

public enum ARRAY_TYPE {
    INT("int"),
    STRING("string"),
    REAL("real");

    private final String name;

    private ARRAY_TYPE(String name) {
        this.name = name;
    }

    public static ARRAY_TYPE byName(String name) {
        return Arrays.stream(ARRAY_TYPE.values()).filter(value -> name.equals(value.name)).findFirst().orElseThrow(() -> new KieEnumException("Failed to find ARRAY_TYPE with name: " + name));
    }

    public String getName() {
        return this.name;
    }

    public Object getValue(String rawValue) {
        switch (this) {
            case INT: {
                return Integer.valueOf(rawValue);
            }
            case STRING: {
                return rawValue;
            }
            case REAL: {
                return Double.valueOf(rawValue);
            }
        }
        throw new KiePMMLException("Unknown ARRAY_TYPE " + (Object)((Object)this));
    }
}

