/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.abstracts;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.kie.pmml.commons.model.KiePMMLExtension;

public abstract class AbstractKiePMMLComponent {
    protected final String name;
    protected final List<KiePMMLExtension> extensions;
    protected String id;
    protected String parentId;

    protected AbstractKiePMMLComponent(String name, List<KiePMMLExtension> extensions) {
        this.name = name;
        this.extensions = extensions;
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return this.name;
    }

    public List<KiePMMLExtension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public static class Builder<T extends AbstractKiePMMLComponent> {
        private static final AtomicInteger counter = new AtomicInteger(1);
        protected T toBuild;

        protected Builder(String prefix, Supplier<T> supplier) {
            this.toBuild = (AbstractKiePMMLComponent)supplier.get();
            ((AbstractKiePMMLComponent)this.toBuild).id = prefix + counter.getAndAdd(1);
        }

        protected Builder withParentId(String parentId) {
            ((AbstractKiePMMLComponent)this.toBuild).parentId = parentId;
            return this;
        }

        public T build() {
            return this.toBuild;
        }
    }
}

