/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.predicates;

import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.OPERATOR;
import org.kie.pmml.commons.model.predicates.KiePMMLSimplePredicate;

public class KiePMMLSimplePredicateTest {
    private final String SIMPLE_PREDICATE_NAME = "SIMPLEPREDICATENAME";

    @Test
    public void evaluateStringEqual() {
        String value = "43";
        KiePMMLSimplePredicate kiePMMLSimplePredicate = this.getKiePMMLSimplePredicate(OPERATOR.EQUAL, value);
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("FAKE", "NOT");
        Assert.assertFalse((boolean)kiePMMLSimplePredicate.evaluate(inputData));
        inputData = new HashMap();
        inputData.put("SIMPLEPREDICATENAME", "NOT");
        Assert.assertFalse((boolean)kiePMMLSimplePredicate.evaluate(inputData));
        inputData = new HashMap();
        inputData.put("SIMPLEPREDICATENAME", value);
        Assert.assertTrue((boolean)kiePMMLSimplePredicate.evaluate(inputData));
    }

    @Test
    public void evaluateStringNotEqual() {
        String value = "43";
        KiePMMLSimplePredicate kiePMMLSimplePredicate = this.getKiePMMLSimplePredicate(OPERATOR.NOT_EQUAL, value);
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("FAKE", "NOT");
        Assert.assertFalse((boolean)kiePMMLSimplePredicate.evaluate(inputData));
        inputData = new HashMap();
        inputData.put("SIMPLEPREDICATENAME", value);
        Assert.assertFalse((boolean)kiePMMLSimplePredicate.evaluate(inputData));
        inputData = new HashMap();
        inputData.put("SIMPLEPREDICATENAME", "NOT");
        Assert.assertTrue((boolean)kiePMMLSimplePredicate.evaluate(inputData));
    }

    @Test(expected=IllegalArgumentException.class)
    public void evaluateStringIsNotMissing() {
        String value = "43";
        KiePMMLSimplePredicate kiePMMLSimplePredicate = this.getKiePMMLSimplePredicate(OPERATOR.IS_NOT_MISSING, value);
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("SIMPLEPREDICATENAME", value);
        kiePMMLSimplePredicate.evaluate(inputData);
    }

    @Test(expected=IllegalArgumentException.class)
    public void evaluateStringIsMissing() {
        String value = "43";
        KiePMMLSimplePredicate kiePMMLSimplePredicate = this.getKiePMMLSimplePredicate(OPERATOR.IS_MISSING, value);
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("SIMPLEPREDICATENAME", value);
        kiePMMLSimplePredicate.evaluate(inputData);
    }

    @Test
    public void evaluationStringEqual() {
        String value = "43";
        KiePMMLSimplePredicate kiePMMLSimplePredicate = this.getKiePMMLSimplePredicate(OPERATOR.EQUAL, value);
        Assert.assertFalse((boolean)kiePMMLSimplePredicate.evaluation((Object)"NOT"));
        Assert.assertTrue((boolean)kiePMMLSimplePredicate.evaluation((Object)value));
    }

    @Test
    public void evaluationStringNotEqual() {
        String value = "43";
        KiePMMLSimplePredicate kiePMMLSimplePredicate = this.getKiePMMLSimplePredicate(OPERATOR.NOT_EQUAL, value);
        Assert.assertFalse((boolean)kiePMMLSimplePredicate.evaluation((Object)value));
        Assert.assertTrue((boolean)kiePMMLSimplePredicate.evaluation((Object)"NOT"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void evaluationStringIsNotMissing() {
        String value = "43";
        KiePMMLSimplePredicate kiePMMLSimplePredicate = this.getKiePMMLSimplePredicate(OPERATOR.IS_NOT_MISSING, value);
        kiePMMLSimplePredicate.evaluation((Object)value);
    }

    @Test(expected=IllegalArgumentException.class)
    public void evaluationStringIsMissing() {
        String value = "43";
        KiePMMLSimplePredicate kiePMMLSimplePredicate = this.getKiePMMLSimplePredicate(OPERATOR.IS_MISSING, value);
        kiePMMLSimplePredicate.evaluation((Object)value);
    }

    private KiePMMLSimplePredicate getKiePMMLSimplePredicate(OPERATOR operator, Object value) {
        return (KiePMMLSimplePredicate)KiePMMLSimplePredicate.builder((String)"SIMPLEPREDICATENAME", Collections.emptyList(), (OPERATOR)operator).withValue(value).build();
    }
}

