/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.utils;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;

public class KiePMMLModelUtilsTest {
    private static Map<String, String> packageNameMap;
    private static Map<String, String> classNameMap;

    @BeforeClass
    public static void setup() {
        packageNameMap = new HashMap<String, String>();
        packageNameMap.put("a-dashed-name", "adashedname");
        packageNameMap.put("an_underscored_name", "anunderscoredname");
        packageNameMap.put("a spaced name", "aspacedname");
        packageNameMap.put("AnUpperCasedMame", "anuppercasedmame");
        packageNameMap.put("a_Mixed -name", "amixedname");
        packageNameMap.put("C:\\w-ind_ow Path", "cwindowpath");
        packageNameMap.put("a.Dotted.pA th", "a.dotted.path");
        classNameMap = new HashMap<String, String>();
        classNameMap.put("a-dashed-name", "Adashedname");
        classNameMap.put("an_underscored_name", "Anunderscoredname");
        classNameMap.put("a spaced name", "Aspacedname");
        classNameMap.put("anUpperCasedName", "AnUpperCasedName");
        classNameMap.put("a.dotted.name", "Adottedname");
        classNameMap.put("a_.Mixed -name", "AMixedname");
        classNameMap.put("C:\\w-ind_ow Path", "CwindowPath");
    }

    @Test
    public void getSanitizedPackageName() {
        packageNameMap.forEach((originalName, expectedName) -> Assert.assertEquals((Object)expectedName, (Object)KiePMMLModelUtils.getSanitizedPackageName((String)originalName)));
    }

    @Test
    public void getSanitizedClassName() {
        classNameMap.forEach((originalName, expectedName) -> Assert.assertEquals((Object)expectedName, (Object)KiePMMLModelUtils.getSanitizedClassName((String)originalName)));
    }
}

