/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.transformations;

import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLParameterField;

public class KiePMMLDefineFunctionTest {
    private static final String CUSTOM_FUNCTION = "CUSTOM_FUNCTION";
    private static final String PARAM_1 = "PARAM_1";
    private static final String PARAM_2 = "PARAM_2";
    private static final Double value1 = 100.0;
    private static final Double value2 = 5.0;

    @Test(expected=IllegalArgumentException.class)
    public void evaluateNoParamValues() {
        KiePMMLParameterField parameterField1 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_1, Collections.emptyList()).build();
        KiePMMLParameterField parameterField2 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_2, Collections.emptyList()).build();
        KiePMMLDefineFunction defineFunction = new KiePMMLDefineFunction(CUSTOM_FUNCTION, Collections.emptyList(), OP_TYPE.CONTINUOUS.getName(), Arrays.asList(parameterField1, parameterField2), null);
        defineFunction.evaluate(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void evaluateEmptyParamValues() {
        KiePMMLParameterField parameterField1 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_1, Collections.emptyList()).build();
        KiePMMLParameterField parameterField2 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_2, Collections.emptyList()).build();
        KiePMMLDefineFunction defineFunction = new KiePMMLDefineFunction(CUSTOM_FUNCTION, Collections.emptyList(), OP_TYPE.CONTINUOUS.getName(), Arrays.asList(parameterField1, parameterField2), null);
        defineFunction.evaluate(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Test
    public void evaluateFromConstant() {
        KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant(PARAM_1, Collections.emptyList(), (Object)value1);
        KiePMMLDefineFunction defineFunction = new KiePMMLDefineFunction(CUSTOM_FUNCTION, Collections.emptyList(), OP_TYPE.CONTINUOUS.getName(), Collections.emptyList(), (KiePMMLExpression)kiePMMLConstant1);
        Object retrieved = defineFunction.evaluate(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        Assert.assertEquals((Object)value1, (Object)retrieved);
    }

    @Test
    public void evaluateFromFieldRef() {
        KiePMMLFieldRef kiePMMLFieldRef = new KiePMMLFieldRef(PARAM_1, Collections.emptyList(), null);
        KiePMMLDefineFunction defineFunction = new KiePMMLDefineFunction(CUSTOM_FUNCTION, Collections.emptyList(), OP_TYPE.CONTINUOUS.getName(), Collections.singletonList(KiePMMLParameterField.builder((String)PARAM_1, Collections.emptyList()).build()), (KiePMMLExpression)kiePMMLFieldRef);
        Object retrieved = defineFunction.evaluate(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(value1));
        Assert.assertEquals((Object)value1, (Object)retrieved);
    }

    @Test
    public void evaluateFromApply() {
        KiePMMLFieldRef kiePMMLFieldRef1 = new KiePMMLFieldRef(PARAM_1, Collections.emptyList(), null);
        KiePMMLFieldRef kiePMMLFieldRef2 = new KiePMMLFieldRef(PARAM_2, Collections.emptyList(), null);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"/").withKiePMMLExpressions(Arrays.asList(kiePMMLFieldRef1, kiePMMLFieldRef2)).build();
        KiePMMLParameterField parameterField1 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_1, Collections.emptyList()).build();
        KiePMMLParameterField parameterField2 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_2, Collections.emptyList()).build();
        KiePMMLDefineFunction defineFunction = new KiePMMLDefineFunction(CUSTOM_FUNCTION, Collections.emptyList(), OP_TYPE.CONTINUOUS.getName(), Arrays.asList(parameterField1, parameterField2), (KiePMMLExpression)kiePMMLApply);
        Object retrieved = defineFunction.evaluate(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Arrays.asList(value1, value2));
        Double expected = value1 / value2;
        Assert.assertEquals((Object)expected, (Object)retrieved);
    }
}

