/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.kie.pmml.commons.model.expressions.KiePMMLTextIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLRow
implements Serializable {
    private static final long serialVersionUID = -5245266051098683475L;
    private static final Logger logger = LoggerFactory.getLogger(KiePMMLRow.class);
    private final Map<String, Object> columnValues;

    public KiePMMLRow(Map<String, Object> columnValues) {
        this.columnValues = columnValues;
    }

    public Optional<Object> evaluate(Map<String, Object> columnPairsMap, String outputColumn, String regexField) {
        boolean matching = true;
        boolean isRegex = regexField != null && this.columnValues.containsKey(regexField) && (Boolean)this.columnValues.get(regexField) != false;
        for (Map.Entry<String, Object> columnPairEntry : columnPairsMap.entrySet()) {
            Object value = this.columnValues.get(columnPairEntry.getKey());
            matching = isRegex ? this.isRegexMatching(value.toString(), (String)columnPairEntry.getValue()) : this.isMatching(value, columnPairEntry.getValue());
            if (matching) continue;
            break;
        }
        return matching ? Optional.ofNullable(this.columnValues.get(outputColumn)) : Optional.empty();
    }

    public void replace(AtomicReference<String> text, String inField, String outField, String regexField, boolean isCaseSensitive, int maxLevenshteinDistance, boolean tokenize, String wordSeparatorCharacterRE) {
        boolean isRegex = regexField != null && this.columnValues.containsKey(regexField) && Boolean.parseBoolean((String)this.columnValues.get(regexField));
        String replaced = isRegex ? this.regexReplace(text.get(), (String)this.columnValues.get(outField), (String)this.columnValues.get(inField)) : this.replace(text.get(), (String)this.columnValues.get(outField), (String)this.columnValues.get(inField), isCaseSensitive, maxLevenshteinDistance, tokenize, wordSeparatorCharacterRE);
        text.set(replaced);
    }

    boolean isMatching(Object original, Object value) {
        return Objects.equals(original, value);
    }

    boolean isRegexMatching(String original, String regex) {
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(original).find();
    }

    String replace(String original, String replacement, String term, boolean isCaseSensitive, int maxLevenshteinDistance, boolean tokenize, String wordSeparatorCharacterRE) {
        logger.debug("replace {} {} {} {} {}", new Object[]{original, replacement, term, isCaseSensitive, maxLevenshteinDistance});
        int caseSensitiveFlag = isCaseSensitive ? 0 : 2;
        Pattern pattern = tokenize ? Pattern.compile(wordSeparatorCharacterRE, caseSensitiveFlag) : Pattern.compile("\\s+");
        List<String> terms = KiePMMLTextIndex.splitText(replacement, pattern);
        String replacementToUse = String.join((CharSequence)" ", terms);
        List<String> texts = KiePMMLTextIndex.splitText(original, pattern);
        int batchSize = terms.size();
        int limit = texts.size() - batchSize + 1;
        LevenshteinDistance levenshteinDistance = new LevenshteinDistance(Integer.valueOf(maxLevenshteinDistance));
        String toReturn = original;
        for (int i = 0; i < limit; ++i) {
            String text = String.join((CharSequence)" ", texts.subList(i, i + batchSize));
            int distance = KiePMMLTextIndex.evaluateLevenshteinDistance(levenshteinDistance, term, text);
            if (distance <= -1) continue;
            toReturn = toReturn.replace(text, replacementToUse);
        }
        return toReturn;
    }

    String regexReplace(String original, String replacement, String regex) {
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(original).replaceAll(replacement);
    }
}

