/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.Collections;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.CLOSURE;
import org.kie.pmml.commons.model.expressions.KiePMMLDiscretizeBin;
import org.kie.pmml.commons.model.expressions.KiePMMLInterval;

public class KiePMMLDiscretizeBinTest {
    private static final String NAME = "name";
    private static final String BINVALUE = "binValue";

    @Test
    public void evaluateOpenOpen() {
        KiePMMLDiscretizeBin kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval(null, (Number)20, CLOSURE.OPEN_OPEN));
        Optional retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assert.assertFalse((boolean)retrieved.isPresent());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assert.assertFalse((boolean)retrieved.isPresent());
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, null, CLOSURE.OPEN_OPEN));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assert.assertFalse((boolean)retrieved.isPresent());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assert.assertFalse((boolean)retrieved.isPresent());
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, (Number)40, CLOSURE.OPEN_OPEN));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assert.assertFalse((boolean)retrieved.isPresent());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assert.assertFalse((boolean)retrieved.isPresent());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)40);
        Assert.assertFalse((boolean)retrieved.isPresent());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)50);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void evaluateOpenClosed() {
        KiePMMLDiscretizeBin kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval(null, (Number)20, CLOSURE.OPEN_CLOSED));
        Optional retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assert.assertFalse((boolean)retrieved.isPresent());
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, null, CLOSURE.OPEN_CLOSED));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assert.assertFalse((boolean)retrieved.isPresent());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assert.assertFalse((boolean)retrieved.isPresent());
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, (Number)40, CLOSURE.OPEN_CLOSED));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assert.assertFalse((boolean)retrieved.isPresent());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assert.assertFalse((boolean)retrieved.isPresent());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)40);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)50);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void evaluateClosedOpen() {
        KiePMMLDiscretizeBin kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval(null, (Number)20, CLOSURE.CLOSED_OPEN));
        Optional retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assert.assertFalse((boolean)retrieved.isPresent());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assert.assertFalse((boolean)retrieved.isPresent());
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, null, CLOSURE.CLOSED_OPEN));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assert.assertFalse((boolean)retrieved.isPresent());
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, (Number)40, CLOSURE.CLOSED_OPEN));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assert.assertFalse((boolean)retrieved.isPresent());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)40);
        Assert.assertFalse((boolean)retrieved.isPresent());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)50);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    @Test
    public void evaluateClosedClosed() {
        KiePMMLDiscretizeBin kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval(null, (Number)20, CLOSURE.CLOSED_CLOSED));
        Optional retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assert.assertFalse((boolean)retrieved.isPresent());
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, null, CLOSURE.CLOSED_CLOSED));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assert.assertFalse((boolean)retrieved.isPresent());
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, (Number)40, CLOSURE.CLOSED_CLOSED));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assert.assertFalse((boolean)retrieved.isPresent());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)40);
        Assert.assertTrue((boolean)retrieved.isPresent());
        Assert.assertEquals((Object)BINVALUE, retrieved.get());
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)50);
        Assert.assertFalse((boolean)retrieved.isPresent());
    }

    private KiePMMLDiscretizeBin getKiePMMLDiscretizeBin(KiePMMLInterval interval) {
        return new KiePMMLDiscretizeBin(NAME, Collections.emptyList(), BINVALUE, interval);
    }
}

