/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.CommonTestingUtility;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.expressions.KiePMMLNormDiscrete;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;

public class KiePMMLNormDiscreteTest {
    @Test
    public void evaluateMissingValue() {
        String fieldName = "fieldName";
        String fieldValue = "fieldValue";
        Double mapMissingTo = 1.0;
        KiePMMLNormDiscrete kiePMMLNormContinuous = this.getKiePMMLNormDiscrete(fieldName, fieldValue, mapMissingTo);
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList());
        Object retrieved = kiePMMLNormContinuous.evaluate(processingDTO);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)mapMissingTo, (Object)retrieved);
    }

    @Test
    public void evaluateSameValue() {
        String fieldName = "fieldName";
        String fieldValue = "fieldValue";
        Number mapMissingTo = null;
        KiePMMLNormDiscrete kiePMMLNormContinuous = this.getKiePMMLNormDiscrete(fieldName, fieldValue, mapMissingTo);
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.singletonList(new KiePMMLNameValue(fieldName, (Object)fieldValue)));
        Object retrieved = kiePMMLNormContinuous.evaluate(processingDTO);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)1.0, (Object)retrieved);
    }

    @Test
    public void evaluateDifferentValue() {
        String fieldName = "fieldName";
        String fieldValue = "fieldValue";
        Number mapMissingTo = null;
        KiePMMLNormDiscrete kiePMMLNormContinuous = this.getKiePMMLNormDiscrete(fieldName, fieldValue, mapMissingTo);
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.singletonList(new KiePMMLNameValue(fieldName, (Object)"anotherValue")));
        Object retrieved = kiePMMLNormContinuous.evaluate(processingDTO);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)0.0, (Object)retrieved);
    }

    private KiePMMLNormDiscrete getKiePMMLNormDiscrete(String name, String value, Number mapMissingTo) {
        return new KiePMMLNormDiscrete(name, Collections.emptyList(), value, mapMissingTo);
    }
}

