/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.expressions.KiePMMLRow;

public class KiePMMLInlineTable
extends AbstractKiePMMLComponent {
    private static final long serialVersionUID = -8218151315846757917L;
    private final List<KiePMMLRow> rows;

    public KiePMMLInlineTable(String name, List<KiePMMLExtension> extensions, List<KiePMMLRow> rows) {
        super(name, extensions);
        this.rows = rows;
    }

    public List<KiePMMLRow> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    public Optional<Object> evaluate(Map<String, Object> columnPairsMap, String outputColumn, String regexField) {
        return this.rows.stream().map(row -> row.evaluate(columnPairsMap, outputColumn, regexField)).filter(Optional::isPresent).findFirst().map(Optional::get);
    }

    public void replace(AtomicReference<String> text, String inField, String outField, String regexField, boolean isCaseSensitive, int maxLevenshteinDistance, boolean tokenize, String wordSeparatorCharacterRE) {
        this.rows.forEach(row -> row.replace(text, inField, outField, regexField, isCaseSensitive, maxLevenshteinDistance, tokenize, wordSeparatorCharacterRE));
    }
}

