/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.Collections;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.pmml.api.enums.CLOSURE;
import org.kie.pmml.commons.model.expressions.KiePMMLDiscretizeBin;
import org.kie.pmml.commons.model.expressions.KiePMMLInterval;

public class KiePMMLDiscretizeBinTest {
    private static final String NAME = "name";
    private static final String BINVALUE = "binValue";

    @Test
    public void evaluateOpenOpen() {
        KiePMMLDiscretizeBin kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval(null, (Number)20, CLOSURE.OPEN_OPEN));
        Optional retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, null, CLOSURE.OPEN_OPEN));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, (Number)40, CLOSURE.OPEN_OPEN));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)40);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)50);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
    }

    @Test
    public void evaluateOpenClosed() {
        KiePMMLDiscretizeBin kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval(null, (Number)20, CLOSURE.OPEN_CLOSED));
        Optional retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, null, CLOSURE.OPEN_CLOSED));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, (Number)40, CLOSURE.OPEN_CLOSED));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)40);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)50);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
    }

    @Test
    public void evaluateClosedOpen() {
        KiePMMLDiscretizeBin kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval(null, (Number)20, CLOSURE.CLOSED_OPEN));
        Optional retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, null, CLOSURE.CLOSED_OPEN));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, (Number)40, CLOSURE.CLOSED_OPEN));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)40);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)50);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
    }

    @Test
    public void evaluateClosedClosed() {
        KiePMMLDiscretizeBin kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval(null, (Number)20, CLOSURE.CLOSED_CLOSED));
        Optional retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, null, CLOSURE.CLOSED_CLOSED));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        kiePMMLDiscretizeBin = this.getKiePMMLDiscretizeBin(new KiePMMLInterval((Number)20, (Number)40, CLOSURE.CLOSED_CLOSED));
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)30);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)10);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)20);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)40);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(BINVALUE);
        retrieved = kiePMMLDiscretizeBin.evaluate((Number)50);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
    }

    private KiePMMLDiscretizeBin getKiePMMLDiscretizeBin(KiePMMLInterval interval) {
        return new KiePMMLDiscretizeBin(NAME, Collections.emptyList(), BINVALUE, interval);
    }
}

