/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.pmml.api.enums.CLOSURE;
import org.kie.pmml.commons.model.KiePMMLMiningField;
import org.kie.pmml.commons.model.expressions.KiePMMLInterval;

public class KiePMMLMiningFieldTest {
    @Test
    public void isAllowedValueNoLimit() {
        KiePMMLMiningField kiePMMLMiningField = (KiePMMLMiningField)KiePMMLMiningField.builder((String)"NAME", Collections.emptyList()).build();
        Assertions.assertThat((boolean)kiePMMLMiningField.isMatching(null)).isTrue();
        Assertions.assertThat((boolean)kiePMMLMiningField.isMatching((Object)"VALUE")).isTrue();
    }

    @Test
    public void isAllowedValueWithAllowedValues() {
        List<String> allowedValues = this.getCommonAllowedValues();
        KiePMMLMiningField kiePMMLMiningField = (KiePMMLMiningField)KiePMMLMiningField.builder((String)"NAME", Collections.emptyList()).withAllowedValues(allowedValues).build();
        Assertions.assertThat((boolean)kiePMMLMiningField.isMatching(null)).isFalse();
        Assertions.assertThat((boolean)kiePMMLMiningField.isMatching((Object)"VALUE")).isFalse();
        allowedValues.forEach(allowedValue -> Assertions.assertThat((boolean)kiePMMLMiningField.isMatching(allowedValue)).isTrue());
    }

    @Test
    public void isAllowedValueWithIntervals() {
        List<KiePMMLInterval> intervals = this.getCommonIntervals();
        KiePMMLMiningField kiePMMLMiningField = (KiePMMLMiningField)KiePMMLMiningField.builder((String)"NAME", Collections.emptyList()).withIntervals(intervals).build();
        Assertions.assertThat((boolean)kiePMMLMiningField.isMatching(null)).isFalse();
        Assertions.assertThat((boolean)kiePMMLMiningField.isMatching((Object)"VALUE")).isFalse();
        intervals.forEach(interval -> {
            double delta = (interval.getRightMargin().doubleValue() - interval.getLeftMargin().doubleValue()) / 2.0;
            Double toVerify = interval.getLeftMargin().doubleValue() + delta;
            Assertions.assertThat((boolean)kiePMMLMiningField.isMatching((Object)toVerify)).isTrue();
        });
    }

    @Test
    public void isAllowedValueWithAllowedValuesAndIntervals() {
        List<String> allowedValues = this.getCommonAllowedValues();
        List<KiePMMLInterval> intervals = this.getCommonIntervals();
        KiePMMLMiningField kiePMMLMiningField = (KiePMMLMiningField)KiePMMLMiningField.builder((String)"NAME", Collections.emptyList()).withAllowedValues(allowedValues).withIntervals(intervals).build();
        Assertions.assertThat((boolean)kiePMMLMiningField.isMatching(null)).isFalse();
        Assertions.assertThat((boolean)kiePMMLMiningField.isMatching((Object)"VALUE")).isFalse();
        allowedValues.forEach(allowedValue -> Assertions.assertThat((boolean)kiePMMLMiningField.isMatching(allowedValue)).isTrue());
        intervals.forEach(interval -> {
            double delta = (interval.getRightMargin().doubleValue() - interval.getLeftMargin().doubleValue()) / 2.0;
            Double toVerify = interval.getLeftMargin().doubleValue() + delta;
            Assertions.assertThat((boolean)kiePMMLMiningField.isMatching((Object)toVerify)).isFalse();
        });
    }

    private List<String> getCommonAllowedValues() {
        return IntStream.range(0, 3).mapToObj(i -> "ALLOWED-" + i).collect(Collectors.toList());
    }

    private List<KiePMMLInterval> getCommonIntervals() {
        Random rnd = new Random();
        return IntStream.range(0, 3).mapToObj(i -> {
            int leftMargin = rnd.nextInt(10);
            int rightMargin = leftMargin + (rnd.nextInt(10) + 10);
            CLOSURE closure = CLOSURE.values()[rnd.nextInt(CLOSURE.values().length)];
            return new KiePMMLInterval((Number)leftMargin, (Number)rightMargin, closure);
        }).collect(Collectors.toList());
    }
}

