/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.commons.model.KiePMMLFactoryModel;
import org.kie.pmml.commons.testingutility.PMMLContextTest;

public class KiePMMLFactoryModelTest {
    private KiePMMLFactoryModel kiePMMLFactoryModel;

    @BeforeEach
    public void setup() {
        this.kiePMMLFactoryModel = new KiePMMLFactoryModel("", "", new HashMap());
    }

    @Test
    void getSourcesMap() {
        AssertionsForClassTypes.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> {
            Map retrieved = this.kiePMMLFactoryModel.getSourcesMap();
            retrieved.put("KEY", "VALUE");
        });
    }

    @Test
    void addSourceMap() {
        Map retrieved = this.kiePMMLFactoryModel.getSourcesMap();
        Assertions.assertThat((Map)retrieved).isEmpty();
        this.kiePMMLFactoryModel.addSourceMap("KEY", "VALUE");
        retrieved = this.kiePMMLFactoryModel.getSourcesMap();
        Assertions.assertThat((Map)retrieved).containsKey((Object)"KEY");
        Assertions.assertThat((String)((String)retrieved.get("KEY"))).isEqualTo("VALUE");
    }

    @Test
    void evaluate() {
        AssertionsForClassTypes.assertThatExceptionOfType(KiePMMLException.class).isThrownBy(() -> this.kiePMMLFactoryModel.evaluate((Object)"", Collections.emptyMap(), (PMMLContext)new PMMLContextTest()));
    }
}

