/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.predicates;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.ARRAY_TYPE;
import org.kie.pmml.api.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.api.enums.IN_NOTIN;
import org.kie.pmml.commons.model.predicates.KiePMMLCompoundPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLSimpleSetPredicate;

public class KiePMMLCompoundPredicateTest {
    private final String COMPOUND_PREDICATE_NAME = "COMPOUNDPREDICATENAME";
    private final String SIMPLE_SET_PREDICATE_STRING_NAME = "SIMPLESETPREDICATESTRINGNAME";
    private final String SIMPLE_SET_PREDICATE_INT_NAME = "SIMPLESETPREDICATEINTNAME";

    @Test
    void evaluateCompoundPredicateSinglePredicate() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> stringValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateString = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATESTRINGNAME", stringValues, arrayType, IN_NOTIN.IN);
        KiePMMLCompoundPredicate kiePMMLCompoundPredicate = this.getKiePMMLCompoundPredicate(BOOLEAN_OPERATOR.AND, Collections.singletonList(kiePMMLSimpleSetPredicateString));
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", "NOT");
        Assertions.assertThat((boolean)kiePMMLCompoundPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", stringValues.get(0));
        Assertions.assertThat((boolean)kiePMMLCompoundPredicate.evaluate(inputData)).isTrue();
        arrayType = ARRAY_TYPE.INT;
        List<Object> intValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateInt = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATEINTNAME", intValues, arrayType, IN_NOTIN.NOT_IN);
        kiePMMLCompoundPredicate = this.getKiePMMLCompoundPredicate(BOOLEAN_OPERATOR.AND, Collections.singletonList(kiePMMLSimpleSetPredicateInt));
        inputData = new HashMap();
        inputData.put("SIMPLESETPREDICATEINTNAME", intValues.get(0));
        Assertions.assertThat((boolean)kiePMMLCompoundPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATEINTNAME", "234");
        Assertions.assertThat((boolean)kiePMMLCompoundPredicate.evaluate(inputData)).isTrue();
    }

    @Test
    void evaluateCompoundPredicateAnd() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> stringValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateString = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATESTRINGNAME", stringValues, arrayType, IN_NOTIN.IN);
        arrayType = ARRAY_TYPE.INT;
        List<Object> intValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateInt = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATEINTNAME", intValues, arrayType, IN_NOTIN.NOT_IN);
        KiePMMLCompoundPredicate kiePMMLCompoundPredicate = this.getKiePMMLCompoundPredicate(BOOLEAN_OPERATOR.AND, Arrays.asList(kiePMMLSimpleSetPredicateString, kiePMMLSimpleSetPredicateInt));
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", stringValues.get(0));
        inputData.put("SIMPLESETPREDICATEINTNAME", intValues.get(0));
        Assertions.assertThat((boolean)kiePMMLCompoundPredicate.evaluate(inputData)).isFalse();
        inputData = new HashMap();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", "NOT");
        inputData.put("SIMPLESETPREDICATEINTNAME", "234");
        Assertions.assertThat((boolean)kiePMMLCompoundPredicate.evaluate(inputData)).isFalse();
        inputData = new HashMap();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", stringValues.get(0));
        inputData.put("SIMPLESETPREDICATEINTNAME", "234");
        Assertions.assertThat((boolean)kiePMMLCompoundPredicate.evaluate(inputData)).isTrue();
    }

    @Test
    void evaluateCompoundPredicateOr() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> stringValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateString = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATESTRINGNAME", stringValues, arrayType, IN_NOTIN.IN);
        arrayType = ARRAY_TYPE.INT;
        List<Object> intValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateInt = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATEINTNAME", intValues, arrayType, IN_NOTIN.NOT_IN);
        KiePMMLCompoundPredicate kiePMMLCompoundPredicate = this.getKiePMMLCompoundPredicate(BOOLEAN_OPERATOR.OR, Arrays.asList(kiePMMLSimpleSetPredicateString, kiePMMLSimpleSetPredicateInt));
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", "NOT");
        inputData.put("SIMPLESETPREDICATEINTNAME", intValues.get(0));
        Assertions.assertThat((boolean)kiePMMLCompoundPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", stringValues.get(0));
        inputData.put("SIMPLESETPREDICATEINTNAME", intValues.get(0));
        Assertions.assertThat((boolean)kiePMMLCompoundPredicate.evaluate(inputData)).isTrue();
        inputData = new HashMap();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", "NOT");
        inputData.put("SIMPLESETPREDICATEINTNAME", "234");
        Assertions.assertThat((boolean)kiePMMLCompoundPredicate.evaluate(inputData)).isTrue();
        inputData = new HashMap();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", stringValues.get(0));
        inputData.put("SIMPLESETPREDICATEINTNAME", "234");
        Assertions.assertThat((boolean)kiePMMLCompoundPredicate.evaluate(inputData)).isTrue();
    }

    @Test
    void evaluateCompoundPredicateSurrogate() {
        ARRAY_TYPE arrayType = ARRAY_TYPE.STRING;
        List<Object> stringValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateString = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATESTRINGNAME", stringValues, arrayType, IN_NOTIN.IN);
        arrayType = ARRAY_TYPE.INT;
        List<Object> intValues = this.getObjects(arrayType, 4);
        KiePMMLSimpleSetPredicate kiePMMLSimpleSetPredicateInt = this.getKiePMMLSimpleSetPredicate("SIMPLESETPREDICATEINTNAME", intValues, arrayType, IN_NOTIN.NOT_IN);
        KiePMMLCompoundPredicate kiePMMLCompoundPredicate = this.getKiePMMLCompoundPredicate(BOOLEAN_OPERATOR.SURROGATE, Arrays.asList(kiePMMLSimpleSetPredicateString, kiePMMLSimpleSetPredicateInt));
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", "NOT");
        inputData.put("SIMPLESETPREDICATEINTNAME", intValues.get(0));
        Assertions.assertThat((boolean)kiePMMLCompoundPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", stringValues.get(0));
        inputData.put("SIMPLESETPREDICATEINTNAME", intValues.get(0));
        Assertions.assertThat((boolean)kiePMMLCompoundPredicate.evaluate(inputData)).isTrue();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", "NOT");
        inputData.put("SIMPLESETPREDICATEINTNAME", 1);
        Assertions.assertThat((boolean)kiePMMLCompoundPredicate.evaluate(inputData)).isFalse();
        inputData.put("SIMPLESETPREDICATESTRINGNAME", stringValues.get(0));
        inputData.put("SIMPLESETPREDICATEINTNAME", 1);
        Assertions.assertThat((boolean)kiePMMLCompoundPredicate.evaluate(inputData)).isTrue();
    }

    @Test
    void orOperator() {
        Boolean aBoolean = null;
        Boolean aBoolean2 = true;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.orOperator(aBoolean, (Boolean)aBoolean2)).isTrue();
        aBoolean2 = false;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.orOperator(aBoolean, (Boolean)aBoolean2)).isFalse();
        aBoolean = false;
        aBoolean2 = false;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.orOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isFalse();
        aBoolean = true;
        aBoolean2 = false;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.orOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isTrue();
        aBoolean = false;
        aBoolean2 = true;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.orOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isTrue();
        aBoolean = true;
        aBoolean2 = true;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.orOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isTrue();
    }

    @Test
    void andOperator() {
        Boolean aBoolean = null;
        Boolean aBoolean2 = true;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.andOperator(aBoolean, (Boolean)aBoolean2)).isTrue();
        aBoolean2 = false;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.andOperator(aBoolean, (Boolean)aBoolean2)).isFalse();
        aBoolean = false;
        aBoolean2 = false;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.andOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isFalse();
        aBoolean = true;
        aBoolean2 = false;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.andOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isFalse();
        aBoolean = false;
        aBoolean2 = true;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.andOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isFalse();
        aBoolean = true;
        aBoolean2 = true;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.andOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isTrue();
    }

    @Test
    void xorOperator() {
        Boolean aBoolean = null;
        Boolean aBoolean2 = true;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.xorOperator(aBoolean, (Boolean)aBoolean2)).isTrue();
        aBoolean2 = false;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.xorOperator(aBoolean, (Boolean)aBoolean2)).isFalse();
        aBoolean = false;
        aBoolean2 = false;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.xorOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isFalse();
        aBoolean = true;
        aBoolean2 = false;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.xorOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isTrue();
        aBoolean = false;
        aBoolean2 = true;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.xorOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isTrue();
        aBoolean = true;
        aBoolean2 = true;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.xorOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isFalse();
    }

    @Test
    void surrogateOperator() {
        Boolean aBoolean = null;
        Boolean aBoolean2 = true;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.surrogateOperator(aBoolean, (Boolean)aBoolean2)).isTrue();
        aBoolean2 = false;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.surrogateOperator(aBoolean, (Boolean)aBoolean2)).isFalse();
        aBoolean = false;
        aBoolean2 = false;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.surrogateOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isFalse();
        aBoolean = true;
        aBoolean2 = false;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.surrogateOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isTrue();
        aBoolean = false;
        aBoolean2 = true;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.surrogateOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isFalse();
        aBoolean = true;
        aBoolean2 = true;
        Assertions.assertThat((Boolean)KiePMMLCompoundPredicate.surrogateOperator((Boolean)aBoolean, (Boolean)aBoolean2)).isTrue();
    }

    private KiePMMLCompoundPredicate getKiePMMLCompoundPredicate(BOOLEAN_OPERATOR booleanOperator, List<KiePMMLPredicate> kiePMMLPredicates) {
        return (KiePMMLCompoundPredicate)KiePMMLCompoundPredicate.builder(Collections.emptyList(), (BOOLEAN_OPERATOR)booleanOperator).withKiePMMLPredicates(kiePMMLPredicates).build();
    }

    private KiePMMLSimpleSetPredicate getKiePMMLSimpleSetPredicate(String predicateName, List<Object> values, ARRAY_TYPE arrayType, IN_NOTIN inNotIn) {
        return (KiePMMLSimpleSetPredicate)KiePMMLSimpleSetPredicate.builder((String)predicateName, Collections.emptyList(), (ARRAY_TYPE)arrayType, (IN_NOTIN)inNotIn).withValues(values).build();
    }

    private List<Object> getObjects(ARRAY_TYPE arrayType, int size) {
        return IntStream.range(0, size).mapToObj(index -> {
            switch (arrayType) {
                case INT: {
                    return Integer.valueOf(new Random().nextInt(40));
                }
                case REAL: {
                    return Double.valueOf(new Random().nextDouble());
                }
                case STRING: {
                    return UUID.randomUUID().toString();
                }
            }
            return null;
        }).collect(Collectors.toList());
    }
}

