/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.CLOSURE;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.commons.CommonTestingUtility;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.expressions.KiePMMLDiscretize;
import org.kie.pmml.commons.model.expressions.KiePMMLDiscretizeBin;
import org.kie.pmml.commons.model.expressions.KiePMMLInterval;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;

public class KiePMMLDiscretizeTest {
    private static final String NAME = "name";
    private static final String MAP_MISSING_TO = "mapMissingTo";
    private static final String DEFAULTVALUE = "defaultValue";
    private static final DATA_TYPE DATATYPE = DATA_TYPE.INTEGER;
    private static KiePMMLDiscretizeBin kiePMMLDiscretizeBin1;
    private static KiePMMLDiscretizeBin kiePMMLDiscretizeBin2;
    private static KiePMMLDiscretizeBin kiePMMLDiscretizeBin3;
    private static KiePMMLDiscretizeBin kiePMMLDiscretizeBin4;
    private static KiePMMLDiscretizeBin kiePMMLDiscretizeBin5;
    private static List<KiePMMLDiscretizeBin> discretizeBins;

    @BeforeAll
    public static void setup() {
        kiePMMLDiscretizeBin1 = KiePMMLDiscretizeTest.getKiePMMLDiscretizeBin("kiePMMLDiscretizeBin1", new KiePMMLInterval(null, (Number)20, CLOSURE.OPEN_OPEN), "kiePMMLDiscretizeBin1");
        kiePMMLDiscretizeBin2 = KiePMMLDiscretizeTest.getKiePMMLDiscretizeBin("kiePMMLDiscretizeBin2", new KiePMMLInterval((Number)21, (Number)30, CLOSURE.OPEN_CLOSED), "kiePMMLDiscretizeBin2");
        kiePMMLDiscretizeBin3 = KiePMMLDiscretizeTest.getKiePMMLDiscretizeBin("kiePMMLDiscretizeBin3", new KiePMMLInterval((Number)31, (Number)40, CLOSURE.CLOSED_OPEN), "kiePMMLDiscretizeBin3");
        kiePMMLDiscretizeBin4 = KiePMMLDiscretizeTest.getKiePMMLDiscretizeBin("kiePMMLDiscretizeBin4", new KiePMMLInterval((Number)41, (Number)50, CLOSURE.CLOSED_CLOSED), "kiePMMLDiscretizeBin4");
        kiePMMLDiscretizeBin5 = KiePMMLDiscretizeTest.getKiePMMLDiscretizeBin("kiePMMLDiscretizeBin5", new KiePMMLInterval((Number)51, null, CLOSURE.CLOSED_CLOSED), "kiePMMLDiscretizeBin5");
        discretizeBins = Arrays.asList(kiePMMLDiscretizeBin1, kiePMMLDiscretizeBin2, kiePMMLDiscretizeBin3, kiePMMLDiscretizeBin4, kiePMMLDiscretizeBin5);
    }

    @Test
    void evaluateNoInput() {
        KiePMMLDiscretize kiePMMLDiscretize = this.getKiePMMLDiscretize(null, null);
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList());
        Object retrieved = kiePMMLDiscretize.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isNull();
        kiePMMLDiscretize = this.getKiePMMLDiscretize(MAP_MISSING_TO, null);
        retrieved = kiePMMLDiscretize.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)MAP_MISSING_TO);
    }

    @Test
    void evaluateDefaultValue() {
        KiePMMLDiscretize kiePMMLDiscretize = this.getKiePMMLDiscretize(null, null);
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Arrays.asList(new KiePMMLNameValue(NAME, (Object)20)));
        Object retrieved = kiePMMLDiscretize.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isNull();
        kiePMMLDiscretize = this.getKiePMMLDiscretize(MAP_MISSING_TO, DEFAULTVALUE);
        processingDTO = CommonTestingUtility.getProcessingDTO(Arrays.asList(new KiePMMLNameValue(NAME, (Object)20)));
        retrieved = kiePMMLDiscretize.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)DEFAULTVALUE);
        processingDTO = CommonTestingUtility.getProcessingDTO(Arrays.asList(new KiePMMLNameValue(NAME, (Object)21)));
        retrieved = kiePMMLDiscretize.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)DEFAULTVALUE);
        processingDTO = CommonTestingUtility.getProcessingDTO(Arrays.asList(new KiePMMLNameValue(NAME, (Object)40)));
        retrieved = kiePMMLDiscretize.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)DEFAULTVALUE);
    }

    @Test
    void getFromDiscretizeBins() {
        KiePMMLDiscretize kiePMMLDiscretize = this.getKiePMMLDiscretize(null, null);
        Optional retrieved = kiePMMLDiscretize.getFromDiscretizeBins((Number)10);
        Assertions.assertThat((Optional)retrieved).isPresent();
        retrieved = kiePMMLDiscretize.getFromDiscretizeBins((Number)20);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = kiePMMLDiscretize.getFromDiscretizeBins((Number)21);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = kiePMMLDiscretize.getFromDiscretizeBins((Number)29);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(kiePMMLDiscretizeBin2.getBinValue());
        retrieved = kiePMMLDiscretize.getFromDiscretizeBins((Number)30);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(kiePMMLDiscretizeBin2.getBinValue());
        retrieved = kiePMMLDiscretize.getFromDiscretizeBins((Number)31);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(kiePMMLDiscretizeBin3.getBinValue());
        retrieved = kiePMMLDiscretize.getFromDiscretizeBins((Number)32);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(kiePMMLDiscretizeBin3.getBinValue());
        retrieved = kiePMMLDiscretize.getFromDiscretizeBins((Number)40);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        retrieved = kiePMMLDiscretize.getFromDiscretizeBins((Number)41);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(kiePMMLDiscretizeBin4.getBinValue());
        retrieved = kiePMMLDiscretize.getFromDiscretizeBins((Number)42);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(kiePMMLDiscretizeBin4.getBinValue());
        retrieved = kiePMMLDiscretize.getFromDiscretizeBins((Number)49);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(kiePMMLDiscretizeBin4.getBinValue());
        retrieved = kiePMMLDiscretize.getFromDiscretizeBins((Number)50);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(kiePMMLDiscretizeBin4.getBinValue());
        retrieved = kiePMMLDiscretize.getFromDiscretizeBins((Number)51);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(kiePMMLDiscretizeBin5.getBinValue());
        retrieved = kiePMMLDiscretize.getFromDiscretizeBins((Number)52);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat((String)((String)retrieved.get())).isEqualTo(kiePMMLDiscretizeBin5.getBinValue());
    }

    private KiePMMLDiscretize getKiePMMLDiscretize(String mapMissingTo, String defaultValue) {
        Collections.shuffle(discretizeBins);
        return new KiePMMLDiscretize(NAME, Collections.emptyList(), discretizeBins, mapMissingTo, defaultValue, DATATYPE);
    }

    private static KiePMMLDiscretizeBin getKiePMMLDiscretizeBin(String name, KiePMMLInterval interval, String binValue) {
        return new KiePMMLDiscretizeBin(name, Collections.emptyList(), binValue, interval);
    }
}

