/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.commons.CommonTestingUtility;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;

public class KiePMMLOutputFieldTest {
    private static final String CUSTOM_FIELD = "CUSTOM_FIELD";
    private static final String PARAM_1 = "PARAM_1";
    private static final String PARAM_2 = "PARAM_2";
    private static final Double value1 = 100.0;
    private static final Double value2 = 5.0;

    @Test
    void getValueFromKiePMMLNameValuesByVariableName() {
        String variableName = "variableName";
        List kiePMMLNameValues = IntStream.range(0, 3).mapToObj(i -> new KiePMMLNameValue("val-" + i, (Object)i)).collect(Collectors.toList());
        Optional retrieved = KiePMMLOutputField.getValueFromKiePMMLNameValuesByVariableName((String)"variableName", kiePMMLNameValues);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        Double variableValue = 243.94;
        kiePMMLNameValues.add(new KiePMMLNameValue("variableName", (Object)variableValue));
        retrieved = KiePMMLOutputField.getValueFromKiePMMLNameValuesByVariableName((String)"variableName", kiePMMLNameValues);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat(retrieved.get()).isEqualTo((Object)variableValue);
    }

    @Test
    void getValueFromPMMLResultByVariableName() {
        String variableName = "variableName";
        HashMap<String, Double> resultsVariables = new HashMap<String, Double>();
        Optional retrieved = KiePMMLOutputField.getValueFromPMMLResultByVariableName((String)"variableName", resultsVariables);
        Assertions.assertThat((Optional)retrieved).isNotPresent();
        Double variableValue = 243.94;
        resultsVariables.put("variableName", variableValue);
        retrieved = KiePMMLOutputField.getValueFromPMMLResultByVariableName((String)"variableName", resultsVariables);
        Assertions.assertThat((Optional)retrieved).isPresent();
        Assertions.assertThat(retrieved.get()).isEqualTo((Object)variableValue);
    }

    @Test
    void evaluatePredictedValue() {
        String variableName = "variableName";
        KiePMMLOutputField kiePMMLOutputField = (KiePMMLOutputField)KiePMMLOutputField.builder((String)"outputfield", Collections.emptyList()).withResultFeature(RESULT_FEATURE.PREDICTED_VALUE).withTargetField("variableName").build();
        List<KiePMMLNameValue> kiePMMLNameValues = IntStream.range(0, 3).mapToObj(i -> new KiePMMLNameValue("val-" + i, (Object)i)).collect(Collectors.toList());
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), kiePMMLNameValues, Collections.emptyList());
        Assertions.assertThat((Object)kiePMMLOutputField.evaluate(processingDTO)).isNull();
        Double variableValue = 243.94;
        kiePMMLNameValues.add(new KiePMMLNameValue("variableName", (Object)variableValue));
        processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), kiePMMLNameValues, Collections.emptyList());
        Object retrieved = kiePMMLOutputField.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)variableValue);
    }

    @Test
    void evaluateReasonCodeValue() {
        KiePMMLOutputField kiePMMLOutputField = (KiePMMLOutputField)KiePMMLOutputField.builder((String)"outputfield", Collections.emptyList()).withResultFeature(RESULT_FEATURE.REASON_CODE).withRank(Integer.valueOf(4)).build();
        List<String> reasonCodes = IntStream.range(0, 3).mapToObj(i -> "reasonCode-" + i).collect(Collectors.toList());
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), Collections.emptyList(), reasonCodes);
        Assertions.assertThat((Object)kiePMMLOutputField.evaluate(processingDTO)).isNull();
        String variableValue = "reasonCode-3";
        reasonCodes.add("reasonCode-3");
        processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), Collections.emptyList(), reasonCodes);
        Object retrieved = kiePMMLOutputField.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)"reasonCode-3");
    }

    @Test
    void evaluateTransformedValueFromConstant() {
        KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant(PARAM_1, Collections.emptyList(), (Object)value1, null);
        KiePMMLOutputField outputField = (KiePMMLOutputField)KiePMMLOutputField.builder((String)CUSTOM_FIELD, Collections.emptyList()).withKiePMMLExpression((KiePMMLExpression)kiePMMLConstant1).withResultFeature(RESULT_FEATURE.TRANSFORMED_VALUE).build();
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), new ArrayList<KiePMMLNameValue>(), Collections.emptyList());
        Object retrieved = outputField.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)value1);
    }

    @Test
    void evaluateTransformedValueFromFieldRef() {
        KiePMMLFieldRef kiePMMLFieldRef = new KiePMMLFieldRef(PARAM_1, Collections.emptyList(), null);
        KiePMMLOutputField outputField = (KiePMMLOutputField)KiePMMLOutputField.builder((String)CUSTOM_FIELD, Collections.emptyList()).withKiePMMLExpression((KiePMMLExpression)kiePMMLFieldRef).withResultFeature(RESULT_FEATURE.TRANSFORMED_VALUE).build();
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), List.of(new KiePMMLNameValue(PARAM_1, (Object)value1)), Collections.emptyList());
        Object retrieved = outputField.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)value1);
    }

    @Test
    void evaluateTransformedValueFromApplyWithKiePMMLNameValues() {
        KiePMMLFieldRef kiePMMLFieldRef1 = new KiePMMLFieldRef(PARAM_1, Collections.emptyList(), null);
        KiePMMLFieldRef kiePMMLFieldRef2 = new KiePMMLFieldRef(PARAM_2, Collections.emptyList(), null);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"/").withKiePMMLExpressions(Arrays.asList(kiePMMLFieldRef1, kiePMMLFieldRef2)).build();
        KiePMMLOutputField outputField = (KiePMMLOutputField)KiePMMLOutputField.builder((String)CUSTOM_FIELD, Collections.emptyList()).withKiePMMLExpression((KiePMMLExpression)kiePMMLApply).withResultFeature(RESULT_FEATURE.TRANSFORMED_VALUE).build();
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), this.getKiePMMLNameValues(), Collections.emptyList());
        Object retrieved = outputField.evaluate(processingDTO);
        Double expected = value1 / value2;
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
    }

    @Test
    void evaluateTransformedValueFromApplyWithOutputFields() {
        KiePMMLFieldRef kiePMMLFieldRef1 = new KiePMMLFieldRef(PARAM_1, Collections.emptyList(), null);
        KiePMMLFieldRef kiePMMLFieldRef2 = new KiePMMLFieldRef(PARAM_2, Collections.emptyList(), null);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"/").withKiePMMLExpressions(Arrays.asList(kiePMMLFieldRef1, kiePMMLFieldRef2)).build();
        KiePMMLOutputField outputField = (KiePMMLOutputField)KiePMMLOutputField.builder((String)CUSTOM_FIELD, Collections.emptyList()).withKiePMMLExpression((KiePMMLExpression)kiePMMLApply).withResultFeature(RESULT_FEATURE.TRANSFORMED_VALUE).build();
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(this.getOutputFields(), new ArrayList<KiePMMLNameValue>(), Collections.emptyList());
        Object retrieved = outputField.evaluate(processingDTO);
        Double expected = value1 / value2;
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
    }

    private List<KiePMMLNameValue> getKiePMMLNameValues() {
        return Arrays.asList(new KiePMMLNameValue(PARAM_1, (Object)value1), new KiePMMLNameValue(PARAM_2, (Object)value2));
    }

    private List<KiePMMLOutputField> getOutputFields() {
        KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant(PARAM_1, Collections.emptyList(), (Object)value1, null);
        KiePMMLOutputField outputField1 = (KiePMMLOutputField)KiePMMLOutputField.builder((String)PARAM_1, Collections.emptyList()).withKiePMMLExpression((KiePMMLExpression)kiePMMLConstant1).withResultFeature(RESULT_FEATURE.TRANSFORMED_VALUE).build();
        KiePMMLConstant kiePMMLConstant2 = new KiePMMLConstant(PARAM_2, Collections.emptyList(), (Object)value2, null);
        KiePMMLOutputField outputField2 = (KiePMMLOutputField)KiePMMLOutputField.builder((String)PARAM_2, Collections.emptyList()).withKiePMMLExpression((KiePMMLExpression)kiePMMLConstant2).withResultFeature(RESULT_FEATURE.TRANSFORMED_VALUE).build();
        return Arrays.asList(outputField1, outputField2);
    }
}

