/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.commons.CommonTestingUtility;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.expressions.KiePMMLApply;
import org.kie.pmml.commons.model.expressions.KiePMMLConstant;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.expressions.KiePMMLFieldRef;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.kie.pmml.commons.transformations.KiePMMLParameterField;

public class KiePMMLApplyTest {
    private static final String FIELD_NAME = "FIELD_NAME";
    private static final String CUSTOM_FUNCTION = "CUSTOM_FUNCTION";
    private static final String OUTER_FUNCTION = "OUTER_FUNCTION";
    private static final String PARAM_1 = "PARAM_1";
    private static final String PARAM_2 = "PARAM_2";
    private static final Double value1 = 100.0;
    private static final Double value2 = 5.0;
    private static final Object expected = value1 / value2;

    @Test
    void evaluateUnknownFunction() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> {
            String name = "name";
            String function = "UNKNOWN";
            Object defaultValue = null;
            Object mapMissingTo = null;
            String invalidTreatmentValue = null;
            KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant("NAME-1", Collections.emptyList(), (Object)value1, null);
            KiePMMLConstant kiePMMLConstant2 = new KiePMMLConstant("NAME-1", Collections.emptyList(), (Object)value2, null);
            KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)name, Collections.emptyList(), (String)function).withKiePMMLExpressions(Arrays.asList(kiePMMLConstant1, kiePMMLConstant2)).withDefaultValue(defaultValue).withMapMissingTo(mapMissingTo).withInvalidValueTreatmentMethod(invalidTreatmentValue).build();
            ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            kiePMMLApply.evaluate(processingDTO);
        });
    }

    @Test
    void evaluateFromBuiltIn() {
        KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant("NAME-1", Collections.emptyList(), (Object)value1, null);
        KiePMMLConstant kiePMMLConstant2 = new KiePMMLConstant("NAME-1", Collections.emptyList(), (Object)value2, null);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"/").withKiePMMLExpressions(Arrays.asList(kiePMMLConstant1, kiePMMLConstant2)).build();
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        Object retrieved = kiePMMLApply.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isEqualTo(expected);
        KiePMMLFieldRef kiePMMLFieldRef = new KiePMMLFieldRef(FIELD_NAME, Collections.emptyList(), null);
        kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"/").withKiePMMLExpressions(Arrays.asList(kiePMMLConstant1, kiePMMLFieldRef)).build();
        List<KiePMMLNameValue> kiePMMLNameValues = Collections.singletonList(new KiePMMLNameValue(FIELD_NAME, (Object)value2));
        processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), Collections.emptyList(), kiePMMLNameValues, Collections.emptyList());
        retrieved = kiePMMLApply.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isEqualTo(expected);
        KiePMMLDerivedField kiePMMLDerivedField = (KiePMMLDerivedField)KiePMMLDerivedField.builder((String)FIELD_NAME, Collections.emptyList(), (DATA_TYPE)DATA_TYPE.DOUBLE, (OP_TYPE)OP_TYPE.CONTINUOUS, (KiePMMLExpression)kiePMMLConstant2).build();
        List<KiePMMLDerivedField> derivedFields = Collections.singletonList(kiePMMLDerivedField);
        kiePMMLNameValues = Collections.singletonList(new KiePMMLNameValue("UNKNOWN", (Object)"WRONG"));
        processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), derivedFields, kiePMMLNameValues, Collections.emptyList());
        retrieved = kiePMMLApply.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isEqualTo(expected);
        kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"isMissing").withKiePMMLExpressions(Collections.singletonList(kiePMMLFieldRef)).build();
        processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(this.getReferredByFieldRef(FIELD_NAME)));
        retrieved = kiePMMLApply.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isInstanceOf(Boolean.class);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isTrue();
        kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"isMissing").withKiePMMLExpressions(Collections.singletonList(kiePMMLFieldRef)).build();
        kiePMMLNameValues = Collections.singletonList(new KiePMMLNameValue(FIELD_NAME, (Object)value2));
        processingDTO = CommonTestingUtility.getProcessingDTO(Collections.emptyList(), Collections.emptyList(), kiePMMLNameValues, Collections.singletonList(this.getReferredByFieldRef(FIELD_NAME)));
        retrieved = kiePMMLApply.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isInstanceOf(Boolean.class);
        Assertions.assertThat((boolean)((Boolean)retrieved)).isFalse();
    }

    @Test
    void evaluateFromDefineFunction() {
        Double valueA = 33.0;
        Double valueB = 27.0;
        KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant("NAME-1", Collections.emptyList(), (Object)valueA, null);
        KiePMMLConstant kiePMMLConstant2 = new KiePMMLConstant("NAME-1", Collections.emptyList(), (Object)valueB, null);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)CUSTOM_FUNCTION).withKiePMMLExpressions(Arrays.asList(kiePMMLConstant1, kiePMMLConstant2)).build();
        List<KiePMMLDefineFunction> defineFunctions = Collections.singletonList(this.getDefineFunctionApplyFromConstant());
        ProcessingDTO processingDTO = CommonTestingUtility.getProcessingDTO(defineFunctions, Collections.emptyList(), new ArrayList<KiePMMLNameValue>(), Collections.emptyList());
        Object retrieved = kiePMMLApply.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isEqualTo(expected);
        defineFunctions = Collections.singletonList(this.getDefineFunctionApplyFromFieldRef());
        processingDTO = CommonTestingUtility.getProcessingDTO(defineFunctions, Collections.emptyList(), new ArrayList<KiePMMLNameValue>(), Collections.emptyList());
        retrieved = kiePMMLApply.evaluate(processingDTO);
        Double locallyExpected = value1 / valueB;
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)locallyExpected);
        kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)OUTER_FUNCTION).withKiePMMLExpressions(Arrays.asList(kiePMMLConstant1, kiePMMLConstant2)).build();
        defineFunctions = Arrays.asList(this.getDefineFunctionApplyFromFieldRef(), this.getDefineFunctionApplyFromCustomFunction());
        processingDTO = CommonTestingUtility.getProcessingDTO(defineFunctions, Collections.emptyList(), new ArrayList<KiePMMLNameValue>(), Collections.emptyList());
        retrieved = kiePMMLApply.evaluate(processingDTO);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)locallyExpected);
    }

    private KiePMMLDefineFunction getDefineFunctionApplyFromConstant() {
        KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant(PARAM_1, Collections.emptyList(), (Object)value1, null);
        KiePMMLConstant kiePMMLConstant2 = new KiePMMLConstant(PARAM_2, Collections.emptyList(), (Object)value2, null);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"/").withKiePMMLExpressions(Arrays.asList(kiePMMLConstant1, kiePMMLConstant2)).build();
        KiePMMLParameterField parameterField1 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_1, Collections.emptyList()).build();
        KiePMMLParameterField parameterField2 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_2, Collections.emptyList()).build();
        return new KiePMMLDefineFunction(CUSTOM_FUNCTION, Collections.emptyList(), null, OP_TYPE.CONTINUOUS, Arrays.asList(parameterField1, parameterField2), (KiePMMLExpression)kiePMMLApply);
    }

    private KiePMMLDefineFunction getDefineFunctionApplyFromFieldRef() {
        KiePMMLConstant kiePMMLConstant1 = new KiePMMLConstant(PARAM_1, Collections.emptyList(), (Object)value1, null);
        KiePMMLFieldRef kiePMMLFieldRef = new KiePMMLFieldRef(PARAM_2, Collections.emptyList(), null);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)"/").withKiePMMLExpressions(Arrays.asList(kiePMMLConstant1, kiePMMLFieldRef)).build();
        KiePMMLParameterField parameterField1 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_1, Collections.emptyList()).build();
        KiePMMLParameterField parameterField2 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_2, Collections.emptyList()).build();
        return new KiePMMLDefineFunction(CUSTOM_FUNCTION, Collections.emptyList(), null, OP_TYPE.CONTINUOUS, Arrays.asList(parameterField1, parameterField2), (KiePMMLExpression)kiePMMLApply);
    }

    private KiePMMLDefineFunction getDefineFunctionApplyFromCustomFunction() {
        KiePMMLFieldRef kiePMMLFieldRef1 = new KiePMMLFieldRef(PARAM_1, Collections.emptyList(), null);
        KiePMMLFieldRef kiePMMLFieldRef2 = new KiePMMLFieldRef(PARAM_2, Collections.emptyList(), null);
        KiePMMLApply kiePMMLApply = (KiePMMLApply)KiePMMLApply.builder((String)"NAME", Collections.emptyList(), (String)CUSTOM_FUNCTION).withKiePMMLExpressions(Arrays.asList(kiePMMLFieldRef1, kiePMMLFieldRef2)).build();
        KiePMMLParameterField parameterField1 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_1, Collections.emptyList()).build();
        KiePMMLParameterField parameterField2 = (KiePMMLParameterField)KiePMMLParameterField.builder((String)PARAM_2, Collections.emptyList()).build();
        return new KiePMMLDefineFunction(OUTER_FUNCTION, Collections.emptyList(), null, OP_TYPE.CONTINUOUS, Arrays.asList(parameterField1, parameterField2), (KiePMMLExpression)kiePMMLApply);
    }

    private MiningField getReferredByFieldRef(String name) {
        return new MiningField(name, null, null, null, null, null, null, null, null, null);
    }
}

