/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.OUTLIER_TREATMENT_METHOD;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.expressions.KiePMMLLinearNorm;
import org.kie.pmml.commons.model.expressions.KiePMMLNormContinuous;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;

public class KiePMMLNormContinuousTest {
    @Test
    void sortLinearNorms() {
        KiePMMLLinearNorm ln0 = new KiePMMLLinearNorm("0", Collections.emptyList(), 34.0, 45.0);
        KiePMMLLinearNorm ln1 = new KiePMMLLinearNorm("1", Collections.emptyList(), 32.0, 5.0);
        KiePMMLLinearNorm ln2 = new KiePMMLLinearNorm("2", Collections.emptyList(), 33.0, 34.0);
        List<KiePMMLLinearNorm> linearNorms = Arrays.asList(ln0, ln1, ln2);
        Assertions.assertThat((Object)linearNorms.get(0)).isEqualTo((Object)ln0);
        Assertions.assertThat((Object)linearNorms.get(1)).isEqualTo((Object)ln1);
        Assertions.assertThat((Object)linearNorms.get(2)).isEqualTo((Object)ln2);
        KiePMMLNormContinuous.sortLinearNorms(linearNorms);
        Assertions.assertThat((Object)linearNorms.get(0)).isEqualTo((Object)ln1);
        Assertions.assertThat((Object)linearNorms.get(1)).isEqualTo((Object)ln2);
        Assertions.assertThat((Object)linearNorms.get(2)).isEqualTo((Object)ln0);
    }

    @Test
    void evaluate() {
        String fieldName = "fieldName";
        Integer input = 24;
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(fieldName, null, null);
        ProcessingDTO processingDTO = new ProcessingDTO(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(new KiePMMLNameValue(fieldName, (Object)input)), Collections.emptyList(), Collections.emptyList());
        Number retrieved = (Number)kiePMMLNormContinuous.evaluate(processingDTO);
        Double expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
    }

    @Test
    void evaluateWithExpectedValue() {
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, null, null);
        Integer input = 24;
        Number retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        Double expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
        input = 28;
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm());
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
        input = 30;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
        input = 31;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
        input = 36;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
        input = 37;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
        input = 40;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
    }

    @Test
    void evaluateWithOutlierValueAsIs() {
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, OUTLIER_TREATMENT_METHOD.AS_IS, null);
        Integer input = 23;
        Number retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        Double expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
        input = 41;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
    }

    @Test
    void evaluateWithOutlierValueAsMissingValues() {
        Integer missingValue = 45;
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, OUTLIER_TREATMENT_METHOD.AS_MISSING_VALUES, missingValue);
        Integer input = 23;
        Number retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)missingValue);
        input = 41;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)missingValue);
    }

    @Test
    void evaluateWithOutlierValueAsExtremeValues() {
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, OUTLIER_TREATMENT_METHOD.AS_EXTREME_VALUES, null);
        Integer input = 23;
        Number retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm());
        input = 41;
        retrieved = kiePMMLNormContinuous.evaluate((Number)input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm());
    }

    @Test
    void evaluateExpectedValue() {
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, null, null);
        Integer input = 24;
        Number retrieved = kiePMMLNormContinuous.evaluateExpectedValue((Number)input);
        Double expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
        input = 28;
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm());
        retrieved = kiePMMLNormContinuous.evaluateExpectedValue((Number)input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
        input = 30;
        retrieved = kiePMMLNormContinuous.evaluateExpectedValue((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
        input = 31;
        retrieved = kiePMMLNormContinuous.evaluateExpectedValue((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
        input = 36;
        retrieved = kiePMMLNormContinuous.evaluateExpectedValue((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
        input = 37;
        retrieved = kiePMMLNormContinuous.evaluateExpectedValue((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
        input = 40;
        retrieved = kiePMMLNormContinuous.evaluateExpectedValue((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
    }

    @Test
    void evaluateOutlierValueAsIs() {
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, OUTLIER_TREATMENT_METHOD.AS_IS, null);
        Integer input = 23;
        Number retrieved = kiePMMLNormContinuous.evaluateOutlierValue((Number)input);
        Double expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(1)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
        input = 41;
        retrieved = kiePMMLNormContinuous.evaluateOutlierValue((Number)input);
        expected = ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm() + (((Number)input).doubleValue() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) / (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getOrig() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getOrig()) * (((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm() - ((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(2)).getNorm());
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
    }

    @Test
    void evaluateOutlierValueAsMissingValues() {
        Integer missingValue = 45;
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, OUTLIER_TREATMENT_METHOD.AS_MISSING_VALUES, missingValue);
        Integer input = 23;
        Number retrieved = kiePMMLNormContinuous.evaluateOutlierValue((Number)input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)missingValue);
        input = 41;
        retrieved = kiePMMLNormContinuous.evaluateOutlierValue((Number)input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)missingValue);
    }

    @Test
    void evaluateOutlierValueAsExtremeValues() {
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, OUTLIER_TREATMENT_METHOD.AS_EXTREME_VALUES, null);
        Integer input = 23;
        Number retrieved = kiePMMLNormContinuous.evaluateOutlierValue((Number)input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(0)).getNorm());
        input = 41;
        retrieved = kiePMMLNormContinuous.evaluateOutlierValue((Number)input);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)((KiePMMLLinearNorm)kiePMMLNormContinuous.linearNorms.get(3)).getNorm());
    }

    @Test
    void getLimitExpectedValue() {
        KiePMMLNormContinuous kiePMMLNormContinuous = this.getKiePMMLNormContinuous(null, null, null);
        Integer input = 24;
        KiePMMLLinearNorm[] retrieved = kiePMMLNormContinuous.getLimitExpectedValue((Number)input);
        Assertions.assertThat((Object)retrieved[0]).isEqualTo(kiePMMLNormContinuous.linearNorms.get(0));
        Assertions.assertThat((Object)retrieved[1]).isEqualTo(kiePMMLNormContinuous.linearNorms.get(1));
        input = 28;
        retrieved = kiePMMLNormContinuous.getLimitExpectedValue((Number)input);
        Assertions.assertThat((Object)retrieved[0]).isEqualTo(kiePMMLNormContinuous.linearNorms.get(0));
        Assertions.assertThat((Object)retrieved[1]).isEqualTo(kiePMMLNormContinuous.linearNorms.get(1));
        input = 30;
        retrieved = kiePMMLNormContinuous.getLimitExpectedValue((Number)input);
        Assertions.assertThat((Object)retrieved[0]).isEqualTo(kiePMMLNormContinuous.linearNorms.get(1));
        Assertions.assertThat((Object)retrieved[1]).isEqualTo(kiePMMLNormContinuous.linearNorms.get(2));
        input = 31;
        retrieved = kiePMMLNormContinuous.getLimitExpectedValue((Number)input);
        Assertions.assertThat((Object)retrieved[0]).isEqualTo(kiePMMLNormContinuous.linearNorms.get(1));
        Assertions.assertThat((Object)retrieved[1]).isEqualTo(kiePMMLNormContinuous.linearNorms.get(2));
        input = 36;
        retrieved = kiePMMLNormContinuous.getLimitExpectedValue((Number)input);
        Assertions.assertThat((Object)retrieved[0]).isEqualTo(kiePMMLNormContinuous.linearNorms.get(2));
        Assertions.assertThat((Object)retrieved[1]).isEqualTo(kiePMMLNormContinuous.linearNorms.get(3));
        input = 37;
        retrieved = kiePMMLNormContinuous.getLimitExpectedValue((Number)input);
        Assertions.assertThat((Object)retrieved[0]).isEqualTo(kiePMMLNormContinuous.linearNorms.get(2));
        Assertions.assertThat((Object)retrieved[1]).isEqualTo(kiePMMLNormContinuous.linearNorms.get(3));
        input = 40;
        retrieved = kiePMMLNormContinuous.getLimitExpectedValue((Number)input);
        Assertions.assertThat((Object)retrieved[0]).isEqualTo(kiePMMLNormContinuous.linearNorms.get(2));
        Assertions.assertThat((Object)retrieved[1]).isEqualTo(kiePMMLNormContinuous.linearNorms.get(3));
    }

    @Test
    void evaluateInputAndLimitLinearNorms() {
        double startOrig = 2.1;
        double startNorm = 2.6;
        double endOrig = 7.4;
        double endNorm = 6.9;
        KiePMMLLinearNorm startLinearNorm = new KiePMMLLinearNorm("start", Collections.emptyList(), startOrig, startNorm);
        KiePMMLLinearNorm endLinearNorm = new KiePMMLLinearNorm("end", Collections.emptyList(), endOrig, endNorm);
        KiePMMLLinearNorm[] limitLinearNorms = new KiePMMLLinearNorm[]{startLinearNorm, endLinearNorm};
        Double input = 3.5;
        Number retrieved = KiePMMLNormContinuous.evaluate((Number)input, (KiePMMLLinearNorm[])limitLinearNorms);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Double expected = startNorm + (input - startOrig) / (endOrig - startOrig) * (endNorm - startNorm);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)expected);
    }

    private KiePMMLNormContinuous getKiePMMLNormContinuous(String name, OUTLIER_TREATMENT_METHOD outlierTreatmentMethod, Number mapMissingTo) {
        KiePMMLLinearNorm ln0 = new KiePMMLLinearNorm("0", Collections.emptyList(), 24.0, 26.0);
        KiePMMLLinearNorm ln1 = new KiePMMLLinearNorm("1", Collections.emptyList(), 30.0, 32.0);
        KiePMMLLinearNorm ln2 = new KiePMMLLinearNorm("2", Collections.emptyList(), 36.0, 34.0);
        KiePMMLLinearNorm ln3 = new KiePMMLLinearNorm("3", Collections.emptyList(), 40.0, 39.0);
        List<KiePMMLLinearNorm> linearNorms = Arrays.asList(ln0, ln1, ln2, ln3);
        return new KiePMMLNormContinuous(name, Collections.emptyList(), linearNorms, outlierTreatmentMethod, mapMissingTo);
    }
}

