/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.command;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.evaluator.assembler.command.PMMLCommandExecutorImpl;

public class PMMLCommandExecutorImplTest {
    @Test(expected=KiePMMLException.class)
    public void validateNoSource() {
        PMMLRequestData pmmlRequestData = new PMMLRequestData();
        pmmlRequestData.setModelName("modelName");
        PMMLCommandExecutorImpl cmdExecutor = new PMMLCommandExecutorImpl();
        cmdExecutor.validate(pmmlRequestData);
    }

    @Test(expected=KiePMMLException.class)
    public void validateEmptySource() {
        PMMLRequestData pmmlRequestData = new PMMLRequestData();
        pmmlRequestData.setModelName("modelName");
        pmmlRequestData.setSource("");
        PMMLCommandExecutorImpl cmdExecutor = new PMMLCommandExecutorImpl();
        cmdExecutor.validate(pmmlRequestData);
    }

    @Test(expected=KiePMMLException.class)
    public void validateNoModelName() {
        PMMLRequestData pmmlRequestData = new PMMLRequestData();
        pmmlRequestData.setSource("source");
        PMMLCommandExecutorImpl cmdExecutor = new PMMLCommandExecutorImpl();
        cmdExecutor.validate(pmmlRequestData);
    }

    @Test(expected=KiePMMLException.class)
    public void validateEmptyModelName() {
        PMMLRequestData pmmlRequestData = new PMMLRequestData();
        pmmlRequestData.setSource("source");
        pmmlRequestData.setModelName("");
        PMMLCommandExecutorImpl cmdExecutor = new PMMLCommandExecutorImpl();
        cmdExecutor.validate(pmmlRequestData);
    }

    @Test
    public void getCleanedRequestData() {
        PMMLRequestData pmmlRequestData = this.getPMMLRequestData();
        PMMLCommandExecutorImpl cmdExecutor = new PMMLCommandExecutorImpl();
        PMMLRequestData retrieved = cmdExecutor.getCleanedRequestData(pmmlRequestData);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)pmmlRequestData.getSource(), (Object)retrieved.getSource());
        Assert.assertEquals((Object)pmmlRequestData.getCorrelationId(), (Object)retrieved.getCorrelationId());
        Assert.assertEquals((Object)pmmlRequestData.getModelName(), (Object)retrieved.getModelName());
        Map requestParams = retrieved.getMappedRequestParams();
        pmmlRequestData.getRequestParams().forEach(parameterInfo -> {
            Assert.assertTrue((boolean)requestParams.containsKey(parameterInfo.getName()));
            ParameterInfo cleaned = (ParameterInfo)requestParams.get(parameterInfo.getName());
            Assert.assertEquals((Object)parameterInfo.getName(), (Object)cleaned.getName());
            Assert.assertEquals((Object)parameterInfo.getCorrelationId(), (Object)cleaned.getCorrelationId());
            Assert.assertEquals((Object)parameterInfo.getType(), (Object)cleaned.getType());
            Assert.assertEquals((Object)parameterInfo.getValue(), (Object)cleaned.getValue().toString());
            Assert.assertEquals((Object)cleaned.getType(), cleaned.getValue().getClass());
        });
    }

    private PMMLRequestData getPMMLRequestData() {
        PMMLRequestData toReturn = new PMMLRequestData();
        String correlationId = "correlationId";
        toReturn.setSource("source");
        toReturn.setCorrelationId(correlationId);
        toReturn.setModelName("modelName");
        List<Class> classList = Arrays.asList(Integer.class, Double.class, Boolean.class, String.class);
        classList.forEach(aClass -> {
            String value = this.getRandomValue(aClass.getSimpleName()).toString();
            ParameterInfo toAdd = new ParameterInfo(correlationId, RandomStringUtils.random((int)4, (boolean)true, (boolean)false), aClass, (Object)value);
            toReturn.addRequestParam(toAdd);
        });
        return toReturn;
    }

    private Object getRandomValue(String type) {
        switch (type) {
            case "Integer": {
                return new Random().nextInt(40);
            }
            case "Double": {
                return new Random().nextDouble();
            }
            case "Boolean": {
                return new Random().nextBoolean();
            }
            case "String": {
                return RandomStringUtils.random((int)6, (boolean)true, (boolean)false);
            }
        }
        throw new RuntimeException();
    }
}

