/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.factories;

import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.evaluator.assembler.factories.PMMLRuleMapperFactory;

public class PMMLRuleMapperFactoryTest {
    @Test
    public void getPredictionRuleMapperSourceWithoutPackage() {
        String fullRuleName = "FULL_RULE_NAME";
        String retrieved = PMMLRuleMapperFactory.getPMMLRuleMapperSource((String)"FULL_RULE_NAME");
        Assert.assertNotNull((Object)retrieved);
        String expected = String.format("public final static Model model = new %s();", "FULL_RULE_NAME");
        Assert.assertTrue((boolean)retrieved.contains(expected));
    }

    @Test
    public void getPredictionRuleMapperSourceWithPackage() {
        String packageName = "PACKAGE";
        String ruleName = "RULE_NAME";
        String fullRuleName = "PACKAGE.RULE_NAME";
        String retrieved = PMMLRuleMapperFactory.getPMMLRuleMapperSource((String)"PACKAGE.RULE_NAME");
        Assert.assertNotNull((Object)retrieved);
        String expected = String.format("package %s;", "PACKAGE");
        Assert.assertTrue((boolean)retrieved.contains(expected));
        expected = String.format("public final static Model model = new %s();", "PACKAGE.RULE_NAME");
        Assert.assertTrue((boolean)retrieved.contains(expected));
    }
}

