/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.factories;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.evaluator.assembler.factories.PMMLRuleMappersFactory;

public class PMMLRuleMappersFactoryTest {
    @Test
    public void getPredictionRuleMapperSource() {
        String pmmlRuleMapper = "PMMLRuleMapperImpl";
        String packageName = "PACKAGE";
        List generatedRuleMappers = IntStream.range(0, 4).mapToObj(index -> "PACKAGE.subPack" + index + "." + "PMMLRuleMapperImpl").collect(Collectors.toList());
        String retrieved = PMMLRuleMappersFactory.getPMMLRuleMappersSource((String)"PACKAGE", generatedRuleMappers);
        Assert.assertNotNull((Object)retrieved);
        String expected = String.format("package %s;", "PACKAGE");
        Assert.assertTrue((boolean)retrieved.contains(expected));
        List mod = generatedRuleMappers.stream().map(gen -> "new " + gen + "()").collect(Collectors.toList());
        expected = "Arrays.asList(" + String.join((CharSequence)", ", mod) + ");";
        Assert.assertTrue((boolean)retrieved.contains(expected));
    }
}

