/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.factories;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.io.impl.DescrResource;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.modelcompiler.ExecutableModelProject;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.KiePackage;
import org.kie.api.internal.io.ResourceTypePackage;
import org.kie.api.io.ResourceType;
import org.kie.internal.utils.KieHelper;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.commons.model.HasNestedModels;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.testingutility.KiePMMLTestingModel;
import org.kie.pmml.evaluator.assembler.container.PMMLPackageImpl;
import org.kie.pmml.evaluator.assembler.factories.PMMLRuntimeFactoryInternal;
import org.kie.pmml.evaluator.core.service.PMMLRuntimeInternalImpl;
import org.kie.test.util.filesystem.FileUtils;
import org.kie.util.maven.support.ReleaseIdImpl;

public class PMMLRuntimeFactoryInternalTest {
    @Test
    public void getPMMLRuntimeFromFile() {
        File pmmlFile = FileUtils.getFile((String)"MissingDataRegression.pmml");
        PMMLRuntime retrieved = PMMLRuntimeFactoryInternal.getPMMLRuntime((File)pmmlFile);
        this.commonValidatePMMLRuntime(retrieved);
    }

    @Test
    public void testGetPMMLRuntimeFromFileAndReleaseId() {
        File pmmlFile = FileUtils.getFile((String)"MiningModel_Mixed.pmml");
        ReleaseIdImpl releaseId = new ReleaseIdImpl("org.dummy:dummy-artifact:1-0");
        PMMLRuntime retrieved = PMMLRuntimeFactoryInternal.getPMMLRuntime((File)pmmlFile, (ReleaseId)releaseId);
        this.commonValidatePMMLRuntime(retrieved);
    }

    @Test
    public void createKieBaseFromFile() {
        File pmmlFile = FileUtils.getFile((String)"MissingDataRegression.pmml");
        KieBase retrieved = PMMLRuntimeFactoryInternal.createKieBase((File)pmmlFile);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.getKiePackages().isEmpty());
    }

    @Test
    public void createKieBaseFromKnowledgeBuilder() {
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        knowledgeBuilder.addPackage((InternalKnowledgePackage)new KnowledgePackageImpl("namespace_1"));
        knowledgeBuilder.addPackage((InternalKnowledgePackage)new KnowledgePackageImpl("namespace_2"));
        PMMLPackageImpl pmmlPkg = new PMMLPackageImpl();
        pmmlPkg.addAll(Collections.singleton(new KiePMMLTestingModel("FAKE", Collections.emptyList())));
        KnowledgePackageImpl pmmlKnowledgePackage = new KnowledgePackageImpl("pmmled_package");
        pmmlKnowledgePackage.getResourceTypePackages().put(ResourceType.PMML, (ResourceTypePackage)pmmlPkg);
        KieBase retrieved = PMMLRuntimeFactoryInternal.createKieBase((KnowledgeBuilderImpl)knowledgeBuilder);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertFalse((boolean)retrieved.getKiePackages().isEmpty());
        Assert.assertEquals((long)knowledgeBuilder.getKnowledgePackages().size(), (long)retrieved.getKiePackages().size());
        knowledgeBuilder.getKnowledgePackages().forEach(kBuilderPackage -> {
            Assert.assertNotNull((Object)retrieved.getKiePackage(kBuilderPackage.getName()));
            ResourceTypePackage knowledgeBuilderResourceTypePackage = ((InternalKnowledgePackage)kBuilderPackage).getResourceTypePackages().get(ResourceType.PMML);
            if (((InternalKnowledgePackage)kBuilderPackage).getResourceTypePackages().get(ResourceType.PMML) != null) {
                InternalKnowledgePackage retrievedKiePackage = (InternalKnowledgePackage)retrieved.getKiePackage(kBuilderPackage.getName());
                ResourceTypePackage retrievedResourceTypePackage = retrievedKiePackage.getResourceTypePackages().get(ResourceType.PMML);
                Assert.assertNotNull((Object)retrievedKiePackage.getResourceTypePackages().get(ResourceType.PMML));
                Assert.assertEquals((Object)knowledgeBuilderResourceTypePackage, (Object)retrievedResourceTypePackage);
            }
        });
    }

    @Test
    public void getPMMLRuntimeFromFileAndKnowledgeBuilder() {
        File pmmlFile = FileUtils.getFile((String)"MiningModel_Mixed.pmml");
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        PMMLRuntime retrieved = PMMLRuntimeFactoryInternal.getPMMLRuntime((File)pmmlFile, (KnowledgeBuilderImpl)knowledgeBuilder);
        this.commonValidatePMMLRuntime(retrieved);
    }

    @Test
    public void createDescrResource() {
        PackageDescr packageDescr = new PackageDescr();
        DescrResource retrieved = PMMLRuntimeFactoryInternal.createDescrResource((PackageDescr)packageDescr);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)packageDescr, (Object)retrieved.getDescr());
        Assert.assertFalse((boolean)retrieved.hasURL());
        String retrievedSourcePath = retrieved.getSourcePath();
        Assert.assertTrue((boolean)retrievedSourcePath.startsWith("src/main/resources/file_"));
        Assert.assertTrue((boolean)retrievedSourcePath.endsWith(".descr"));
    }

    @Test
    public void populateNestedKiePackageList() {
        KiePMMLModel kiePMMLModel = this.getKiePMMLModelWithNested("FAKE");
        KnowledgePackageImpl pmmlKnowledgePackage = this.getKnowledgePackageWithPMMLResourceType(kiePMMLModel);
        List kiePackages = ((HasNestedModels)kiePMMLModel).getNestedModels().stream().map(this::getKnowledgePackageWithPMMLResourceType).collect(Collectors.toList());
        InternalKnowledgeBase kieBase = (InternalKnowledgeBase)new KieHelper().build(ExecutableModelProject.class, new KieBaseOption[0]);
        kieBase.addPackage((KiePackage)pmmlKnowledgePackage);
        kieBase.addPackages(kiePackages);
        ArrayList toPopulate = new ArrayList();
        PMMLRuntimeFactoryInternal.populateNestedKiePackageList(Collections.singleton(kiePMMLModel), toPopulate, (KieBase)kieBase);
        Assert.assertFalse((boolean)toPopulate.isEmpty());
        Assert.assertEquals((long)kiePackages.size(), (long)toPopulate.size());
    }

    @Test
    public void getKiePackageByFullClassNamePresent() {
        KiePMMLModelA kiePMMLModel = new KiePMMLModelA("FAKE");
        KnowledgePackageImpl pmmlKnowledgePackage = this.getKnowledgePackageWithPMMLResourceType((KiePMMLModel)kiePMMLModel);
        InternalKnowledgeBase kieBase = (InternalKnowledgeBase)new KieHelper().build(ExecutableModelProject.class, new KieBaseOption[0]);
        kieBase.addPackage((KiePackage)pmmlKnowledgePackage);
        Assert.assertNotNull((Object)PMMLRuntimeFactoryInternal.getKiePackageByFullClassName((String)((Object)((Object)kiePMMLModel)).getClass().getName(), (KieBase)kieBase));
    }

    @Test(expected=KiePMMLException.class)
    public void getKiePackageByFullClassNameNotPresent() {
        KnowledgePackageImpl pmmlKnowledgePackage = this.getKnowledgePackageWithPMMLResourceType((KiePMMLModel)new KiePMMLModelA("FAKE"));
        InternalKnowledgeBase kieBase = (InternalKnowledgeBase)new KieHelper().build(ExecutableModelProject.class, new KieBaseOption[0]);
        kieBase.addPackage((KiePackage)pmmlKnowledgePackage);
        PMMLRuntimeFactoryInternal.getKiePackageByFullClassName((String)KiePMMLModel.class.getName(), (KieBase)kieBase);
    }

    private void commonValidatePMMLRuntime(PMMLRuntime toValidate) {
        Assert.assertNotNull((Object)toValidate);
        Assert.assertTrue((boolean)(toValidate instanceof PMMLRuntimeInternalImpl));
        Assert.assertNotNull((Object)((PMMLRuntimeInternalImpl)toValidate).getKnowledgeBase());
    }

    private KnowledgePackageImpl getKnowledgePackageWithPMMLResourceType(KiePMMLModel kiePMMLModel) {
        PMMLPackageImpl pmmlPkg = new PMMLPackageImpl();
        pmmlPkg.addAll(Collections.singleton(kiePMMLModel));
        KnowledgePackageImpl pmmlKnowledgePackage = new KnowledgePackageImpl(kiePMMLModel.getKModulePackageName());
        pmmlKnowledgePackage.getResourceTypePackages().put(ResourceType.PMML, (ResourceTypePackage)pmmlPkg);
        return pmmlKnowledgePackage;
    }

    private KiePMMLModel getKiePMMLModelWithNested(String modelName) {
        ArrayList<KiePMMLModel> kiePmmlModels = new ArrayList<KiePMMLModel>();
        kiePmmlModels.add((KiePMMLModel)new KiePMMLModelA("FAKE-A"));
        kiePmmlModels.add((KiePMMLModel)new KiePMMLModelB("FAKE-B"));
        return new KiePMMLModelWithNested(modelName, kiePmmlModels);
    }

    private class KiePMMLModelWithNested
    extends KiePMMLTestingModel
    implements HasNestedModels {
        private static final long serialVersionUID = -3005462259673834598L;
        private final List<KiePMMLModel> nestedModels;

        public KiePMMLModelWithNested(String modelName, List<KiePMMLModel> nestedModels) {
            super(modelName, Collections.emptyList());
            this.nestedModels = nestedModels;
        }

        public List<KiePMMLModel> getNestedModels() {
            return this.nestedModels;
        }
    }

    private class KiePMMLModelB
    extends KiePMMLTestingModel {
        private static final long serialVersionUID = 8521110750870376450L;

        public KiePMMLModelB(String name) {
            super(name, Collections.emptyList());
        }
    }

    private class KiePMMLModelA
    extends KiePMMLTestingModel {
        private static final long serialVersionUID = -8174670245229417048L;

        public KiePMMLModelA(String name) {
            super(name, Collections.emptyList());
        }
    }
}

