/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.implementations;

import java.util.HashMap;
import java.util.stream.IntStream;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.evaluator.assembler.implementations.HasKnowledgeBuilderImpl;

public class HasKnowledgeBuilderImplTest {
    private static final String CLASS_SOURCE_NAME = "ClassSource";
    private static final String CLASS_SOURCE = String.format("public class %s {}", "ClassSource");
    private KnowledgeBuilderImpl knowledgeBuilder;
    private HasKnowledgeBuilderImpl hasKnowledgeBuilder;

    @Before
    public void setup() {
        this.knowledgeBuilder = new KnowledgeBuilderImpl();
        this.hasKnowledgeBuilder = new HasKnowledgeBuilderImpl(this.knowledgeBuilder);
    }

    @Test
    public void getClassLoader() {
        ClassLoader retrieved = this.hasKnowledgeBuilder.getClassLoader();
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)this.knowledgeBuilder.getRootClassLoader(), (Object)retrieved);
        Assert.assertTrue((boolean)(retrieved instanceof ProjectClassLoader));
    }

    @Test
    public void compileAndLoadClass() {
        HashMap<String, String> sourcesMap = new HashMap<String, String>();
        sourcesMap.put(CLASS_SOURCE_NAME, CLASS_SOURCE);
        Class retrieved = this.hasKnowledgeBuilder.compileAndLoadClass(sourcesMap, CLASS_SOURCE_NAME);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)CLASS_SOURCE_NAME, (Object)retrieved.getName());
    }

    @Test
    public void compileAndLoadClassMultipleTimes() {
        HashMap<String, String> sourcesMap = new HashMap<String, String>();
        sourcesMap.put(CLASS_SOURCE_NAME, CLASS_SOURCE);
        IntStream.range(0, 3).forEach(value -> {
            try {
                this.hasKnowledgeBuilder.compileAndLoadClass(sourcesMap, CLASS_SOURCE_NAME);
            }
            catch (Throwable t) {
                Assert.fail((String)t.getMessage());
            }
        });
    }
}

