/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.pmml.evaluator.assembler.service.PMMLAssemblerService;

public class PMMLAssemblerServiceTest {
    private static Map<String, String[]> resourcePathMap;

    @BeforeClass
    public static void setup() {
        resourcePathMap = new HashMap<String, String[]>();
        resourcePathMap.put("/a/linux/path/a-dashed-name.pmml", new String[]{"AdashednameFactory", "adashedname"});
        resourcePathMap.put("/a_/l inux/p-a_th/an_underscored_name.pmml", new String[]{"AnunderscorednameFactory", "anunderscoredname"});
        resourcePathMap.put("/a_/l inux/p-a_th/a spaced name.pmml", new String[]{"AspacednameFactory", "aspacedname"});
        resourcePathMap.put("/A_/L inux/pAtH/AnUpperCasedMame.pmml", new String[]{"AnUpperCasedMameFactory", "anuppercasedmame"});
        resourcePathMap.put("C:\\from\\window\\w-ind_ow Path\\AnUpperCasedMame.pmml", new String[]{"AnUpperCasedMameFactory", "anuppercasedmame"});
        resourcePathMap.put("C:\\from/window\\mixed Path/AnUpperCasedMame.pmml", new String[]{"AnUpperCasedMameFactory", "anuppercasedmame"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void getFactoryClassNamePackageNameResourceNoFile() {
        MockResource resource = new MockResource();
        PMMLAssemblerService.getFactoryClassNamePackageName((Resource)resource);
    }

    @Test
    public void getFactoryClassNamePackageNameResourceWithFile() {
        resourcePathMap.forEach((sourcePath, comparison) -> {
            MockResource resource = new MockResource((String)sourcePath);
            String[] retrieved = PMMLAssemblerService.getFactoryClassNamePackageName((Resource)resource);
            this.commonVerifyStrings(retrieved, (String[])comparison);
        });
    }

    @Test
    public void testGetFactoryClassNamePackageName() {
        resourcePathMap.forEach((sourcePath, comparison) -> {
            String[] retrieved = PMMLAssemblerService.getFactoryClassNamePackageName((String)sourcePath);
            this.commonVerifyStrings(retrieved, (String[])comparison);
        });
    }

    private void commonVerifyStrings(String[] toVerify, String[] comparison) {
        Assert.assertEquals((long)toVerify.length, (long)comparison.length);
        Assert.assertEquals((long)2L, (long)toVerify.length);
        for (int i = 0; i < toVerify.length; ++i) {
            Assert.assertEquals((Object)comparison[i], (Object)toVerify[i]);
        }
    }

    private static class MockResource
    implements Resource {
        private String sourcePath;

        public MockResource() {
        }

        public MockResource(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        public InputStream getInputStream() throws IOException {
            return null;
        }

        public Reader getReader() throws IOException {
            return null;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public String getTargetPath() {
            return null;
        }

        public ResourceType getResourceType() {
            return null;
        }

        public ResourceConfiguration getConfiguration() {
            return null;
        }

        public Resource setSourcePath(String path) {
            return null;
        }

        public Resource setTargetPath(String path) {
            return null;
        }

        public Resource setResourceType(ResourceType type) {
            return null;
        }

        public Resource setConfiguration(ResourceConfiguration conf) {
            return null;
        }
    }
}

