/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.service;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.core.io.impl.FileSystemResource;
import org.drools.core.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.io.Resource;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.HasRule;
import org.kie.pmml.commons.model.HasNestedModels;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.testingutility.KiePMMLTestingModel;
import org.kie.pmml.commons.testingutility.KiePMMLTestingModelWithSources;
import org.kie.pmml.evaluator.assembler.service.PMMLCompilerService;

public class PMMLCompilerServiceTest {
    @Test
    public void populateWithPMMLRuleMappers() {
        ArrayList<KiePMMLTestingModelWithSources> toPopulate = new ArrayList<KiePMMLTestingModelWithSources>();
        toPopulate.add(new KiePMMLTestingModelWithSources("TEST", "kmodulePackageName", Collections.emptyMap()));
        toPopulate.add(new KiePMMLModelHasRule("TEST", Collections.emptyList()));
        toPopulate.add(new KiePMMLModelHasNestedModelsHasRule("TEST", Collections.emptyList()));
        toPopulate.add(new KiePMMLModelHasNestedModelsHasSourceMap("TEST", Collections.emptyList()));
        toPopulate.forEach(kiePMMLModel -> Assert.assertTrue((boolean)((HasSourcesMap)kiePMMLModel).getSourcesMap().isEmpty()));
        File file = new File("foo.pmml");
        FileSystemResource resource = new FileSystemResource(file);
        PMMLCompilerService.populateWithPMMLRuleMappers(toPopulate, (Resource)resource);
        toPopulate.forEach(kiePmmlModel -> {
            if (kiePmmlModel instanceof HasRule || kiePmmlModel instanceof KiePMMLModelHasNestedModelsHasRule) {
                Assert.assertFalse((boolean)((HasSourcesMap)kiePmmlModel).getSourcesMap().isEmpty());
                String expected = kiePmmlModel.getKModulePackageName() + "." + "PMMLRuleMappersImpl";
                Assert.assertTrue((boolean)((HasSourcesMap)kiePmmlModel).getSourcesMap().containsKey(expected));
                if (kiePmmlModel instanceof HasRule) {
                    expected = kiePmmlModel.getKModulePackageName() + "." + "PMMLRuleMapperImpl";
                    Assert.assertTrue((boolean)((HasSourcesMap)kiePmmlModel).getSourcesMap().containsKey(expected));
                }
            } else {
                Assert.assertTrue((boolean)((HasSourcesMap)kiePmmlModel).getSourcesMap().isEmpty());
            }
        });
    }

    @Test
    public void addPMMLRuleMapperHasSourcesMap() {
        KiePMMLTestingModelWithSources kiePmmlModel = new KiePMMLTestingModelWithSources("TEST", "kmodulePackageName", Collections.emptyMap());
        Assert.assertTrue((boolean)kiePmmlModel.getSourcesMap().isEmpty());
        List generatedRuleMappers = IntStream.range(0, 3).mapToObj(i -> "apackage.Rule_" + i).collect(Collectors.toList());
        PMMLCompilerService.addPMMLRuleMapper((KiePMMLModel)kiePmmlModel, generatedRuleMappers, (String)"source_path");
        Assert.assertTrue((boolean)kiePmmlModel.getSourcesMap().isEmpty());
    }

    @Test
    public void addPMMLRuleMapperHasRule() {
        KiePMMLModelHasRule kiePmmlModel = new KiePMMLModelHasRule("TEST", Collections.emptyList());
        Assert.assertTrue((boolean)kiePmmlModel.getSourcesMap().isEmpty());
        ArrayList generatedRuleMappers = new ArrayList();
        PMMLCompilerService.addPMMLRuleMapper((KiePMMLModel)kiePmmlModel, generatedRuleMappers, (String)"source_path");
        String expected = kiePmmlModel.getKModulePackageName() + "." + "PMMLRuleMapperImpl";
        Assert.assertTrue((boolean)kiePmmlModel.getSourcesMap().containsKey(expected));
        expected = kiePmmlModel.getKModulePackageName() + "." + "PMMLRuleMapperImpl";
        Assert.assertTrue((boolean)generatedRuleMappers.contains(expected));
    }

    @Test
    public void addPMMLRuleMapperKiePMMLModelHasNestedModelsHasRule() {
        KiePMMLModelHasNestedModelsHasRule kiePmmlModel = new KiePMMLModelHasNestedModelsHasRule("TEST", Collections.emptyList());
        Assert.assertTrue((boolean)kiePmmlModel.getSourcesMap().isEmpty());
        ArrayList generatedRuleMappers = new ArrayList();
        PMMLCompilerService.addPMMLRuleMapper((KiePMMLModel)kiePmmlModel, generatedRuleMappers, (String)"source_path");
        Assert.assertTrue((boolean)kiePmmlModel.getSourcesMap().isEmpty());
        Assert.assertEquals((long)kiePmmlModel.nestedModels.size(), (long)generatedRuleMappers.size());
        generatedRuleMappers.forEach(ret -> Assert.assertEquals((Object)(kiePmmlModel.getKModulePackageName() + "." + "PMMLRuleMapperImpl"), (Object)ret));
        kiePmmlModel.nestedModels.forEach(nestedModel -> Assert.assertTrue((boolean)((HasSourcesMap)nestedModel).getSourcesMap().containsKey(nestedModel.getKModulePackageName() + "." + "PMMLRuleMapperImpl")));
    }

    @Test
    public void addPMMLRuleMapperKiePMMLModelHasNestedModelsHasSourceMap() {
        KiePMMLModelHasNestedModelsHasSourceMap kiePmmlModel = new KiePMMLModelHasNestedModelsHasSourceMap("TEST", Collections.emptyList());
        Assert.assertTrue((boolean)kiePmmlModel.getSourcesMap().isEmpty());
        ArrayList generatedRuleMappers = new ArrayList();
        PMMLCompilerService.addPMMLRuleMapper((KiePMMLModel)kiePmmlModel, generatedRuleMappers, (String)"source_path");
        Assert.assertTrue((boolean)kiePmmlModel.getSourcesMap().isEmpty());
        Assert.assertTrue((boolean)generatedRuleMappers.isEmpty());
        kiePmmlModel.nestedModels.forEach(nestedModel -> Assert.assertTrue((boolean)((HasSourcesMap)nestedModel).getSourcesMap().isEmpty()));
    }

    @Test(expected=KiePMMLException.class)
    public void addPMMLRuleMapperNoHasSourceMap() {
        KiePMMLTestingModel kiePmmlModel = new KiePMMLTestingModel("name", Collections.emptyList());
        PMMLCompilerService.addPMMLRuleMapper((KiePMMLModel)kiePmmlModel, new ArrayList(), (String)"source_path");
    }

    @Test
    public void addPMMLRuleMappersHasSourceMap() {
        KiePMMLTestingModelWithSources kiePmmlModel = new KiePMMLTestingModelWithSources("TEST", "kmodulePackageName", new HashMap());
        Assert.assertTrue((boolean)kiePmmlModel.getSourcesMap().isEmpty());
        List generatedRuleMappers = IntStream.range(0, 3).mapToObj(i -> "apackage" + i + "." + "PMMLRuleMapperImpl").collect(Collectors.toList());
        PMMLCompilerService.addPMMLRuleMappers((KiePMMLModel)kiePmmlModel, generatedRuleMappers, (String)"source_path");
        Assert.assertFalse((boolean)kiePmmlModel.getSourcesMap().isEmpty());
        String expected = kiePmmlModel.getKModulePackageName() + "." + "PMMLRuleMappersImpl";
        Assert.assertTrue((boolean)kiePmmlModel.getSourcesMap().containsKey(expected));
    }

    @Test(expected=KiePMMLException.class)
    public void addPMMLRuleMappersNotHasSourceMap() {
        KiePMMLModel kiePmmlModel = (KiePMMLModel)KiePMMLTestingModel.builder((String)"name", Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.REGRESSION).build();
        List generatedRuleMappers = IntStream.range(0, 3).mapToObj(i -> "apackage" + i + "." + "PMMLRuleMapperImpl").collect(Collectors.toList());
        PMMLCompilerService.addPMMLRuleMappers((KiePMMLModel)kiePmmlModel, generatedRuleMappers, (String)"source_path");
    }

    @Test
    public void getFileName() {
        String fileName = "TestFile.pmml";
        String fullPath = String.format("%1$sthis%1$sis%1$sfull%1$spath%1$s%2$s", File.separator, fileName);
        String retrieved = PMMLCompilerService.getFileName((String)fullPath);
        Assert.assertEquals((Object)fileName, (Object)retrieved);
        fullPath = String.format("%1$sthis%1$sis%1$sfull%1$spath%1$s%2$s", "/", fileName);
        retrieved = PMMLCompilerService.getFileName((String)fullPath);
        Assert.assertEquals((Object)fileName, (Object)retrieved);
    }

    private static class KiePMMLModelHasNestedModelsHasSourceMap
    extends KiePMMLTestingModelWithSources
    implements HasNestedModels {
        private static final long serialVersionUID = 2897025575666595935L;
        final List<KiePMMLModel> nestedModels = new ArrayList<KiePMMLModel>();

        public KiePMMLModelHasNestedModelsHasSourceMap(String name, List<KiePMMLExtension> extensions) {
            super(name, "kmodulePackageName", new HashMap());
            IntStream.range(0, 3).forEach(i -> this.nestedModels.add((KiePMMLModel)new KiePMMLTestingModelWithSources(name + "_" + i, "kmodulePackageName", Collections.emptyMap())));
        }

        public List<KiePMMLModel> getNestedModels() {
            return this.nestedModels;
        }
    }

    private static class KiePMMLModelHasNestedModelsHasRule
    extends KiePMMLTestingModelWithSources
    implements HasNestedModels {
        private static final long serialVersionUID = -2112335126983848047L;
        final List<KiePMMLModel> nestedModels = new ArrayList<KiePMMLModel>();

        public KiePMMLModelHasNestedModelsHasRule(String name, List<KiePMMLExtension> extensions) {
            super(name, "kmodulePackageName", new HashMap());
            IntStream.range(0, 3).forEach(i -> this.nestedModels.add((KiePMMLModel)new KiePMMLModelHasRule(name + "_" + i, Collections.emptyList())));
        }

        public List<KiePMMLModel> getNestedModels() {
            return this.nestedModels;
        }
    }

    private static class KiePMMLModelHasRule
    extends KiePMMLTestingModelWithSources
    implements HasRule {
        private static final long serialVersionUID = 5250975029393865181L;
        private final String pkgUUID = StringUtils.generateUUID();

        public KiePMMLModelHasRule(String name, List<KiePMMLExtension> extensions) {
            super(name, "kmodulePackageName", new HashMap());
        }

        public String getPkgUUID() {
            return this.pkgUUID;
        }
    }
}

