/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.service;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.model.EntryPoint;
import org.drools.model.Global;
import org.drools.model.Model;
import org.drools.model.Query;
import org.drools.model.Rule;
import org.drools.model.TypeMetaData;
import org.drools.model.impl.GlobalImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.commons.testingutility.KiePMMLTestingModel;
import org.kie.pmml.compiler.commons.factories.KiePMMLModelFactory;
import org.kie.pmml.evaluator.assembler.rulemapping.PMMLRuleMapper;
import org.kie.pmml.evaluator.assembler.service.PMMLLoaderService;

public class PMMLLoaderServiceTest {
    @Test
    public void getKiePMMLModelsLoadedFromFactory() {
        KnowledgeBuilderImpl kbuilderImpl = new KnowledgeBuilderImpl();
        Assert.assertTrue((boolean)kbuilderImpl.getPackageNames().isEmpty());
        Assert.assertNull((Object)kbuilderImpl.getPackage("PACKAGE_NAME"));
        KiePMMLModelFactory kiePMMLModelFactory = this.getKiePMMLModelFactory();
        List retrieved = PMMLLoaderService.getKiePMMLModelsLoadedFromFactory((KnowledgeBuilderImpl)kbuilderImpl, (KiePMMLModelFactory)kiePMMLModelFactory);
        Assert.assertEquals((Object)kiePMMLModelFactory.getKiePMMLModels(), (Object)retrieved);
        Assert.assertTrue((boolean)kbuilderImpl.getPackageNames().isEmpty());
        Assert.assertNull((Object)kbuilderImpl.getPackage("PACKAGE_NAME"));
    }

    @Test
    public void loadPMMLRuleMappersNotEmpty() {
        KnowledgeBuilderImpl kbuilderImpl = new KnowledgeBuilderImpl();
        Assert.assertTrue((boolean)kbuilderImpl.getPackageNames().isEmpty());
        Assert.assertNull((Object)kbuilderImpl.getPackage("PACKAGE_NAME"));
        List<PMMLRuleMapper> pmmlRuleMappers = this.getPMMLRuleMappers();
        PMMLLoaderService.loadPMMLRuleMappers((KnowledgeBuilderImpl)kbuilderImpl, pmmlRuleMappers);
        Assert.assertEquals((long)1L, (long)kbuilderImpl.getPackageNames().size());
        Assert.assertNotNull((Object)kbuilderImpl.getPackage("PACKAGE_NAME"));
    }

    @Test
    public void loadPMMLRuleMappersEmpty() {
        KnowledgeBuilderImpl kbuilderImpl = new KnowledgeBuilderImpl();
        Assert.assertTrue((boolean)kbuilderImpl.getPackageNames().isEmpty());
        Assert.assertNull((Object)kbuilderImpl.getPackage("PACKAGE_NAME"));
        List pmmlRuleMappers = Collections.emptyList();
        PMMLLoaderService.loadPMMLRuleMappers((KnowledgeBuilderImpl)kbuilderImpl, pmmlRuleMappers);
        Assert.assertTrue((boolean)kbuilderImpl.getPackageNames().isEmpty());
        Assert.assertNull((Object)kbuilderImpl.getPackage("PACKAGE_NAME"));
    }

    private List<PMMLRuleMapper> getPMMLRuleMappers() {
        return IntStream.range(0, 3).mapToObj(i -> new PMMLRuleMapperImpl(new ModelMock("PACKAGE_NAME"))).collect(Collectors.toList());
    }

    private KiePMMLModelFactory getKiePMMLModelFactory() {
        List kiePMMLModels = IntStream.range(0, 3).mapToObj(i -> (KiePMMLTestingModel)KiePMMLTestingModel.builder((String)("KiePMMLModel" + i), Collections.emptyList(), (MINING_FUNCTION)MINING_FUNCTION.REGRESSION).build()).collect(Collectors.toList());
        return () -> kiePMMLModels;
    }

    private static class PMMLRuleMapperImpl
    implements PMMLRuleMapper {
        private final Model model;

        public PMMLRuleMapperImpl(Model model) {
            this.model = model;
        }

        public Model getModel() {
            return this.model;
        }
    }

    private static class ModelMock
    implements Model {
        private final String name = UUID.randomUUID().toString();
        private final List<Global> globals = IntStream.range(0, 3).mapToObj(i -> new GlobalMock(packageName, i)).collect(Collectors.toList());

        public ModelMock(String packageName) {
        }

        public String getName() {
            return this.name;
        }

        public List<Global> getGlobals() {
            return this.globals;
        }

        public List<Rule> getRules() {
            return Collections.emptyList();
        }

        public List<Query> getQueries() {
            return Collections.emptyList();
        }

        public List<TypeMetaData> getTypeMetaDatas() {
            return Collections.emptyList();
        }

        public List<EntryPoint> getEntryPoints() {
            return Collections.emptyList();
        }
    }

    private static class GlobalMock
    extends GlobalImpl<Double> {
        public GlobalMock(String packageName, int id) {
            super(Double.class, packageName, "DOUBLE_GLOBAL_" + id);
        }
    }
}

