/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.ResourceTypePackageRegistry;
import org.drools.drl.ast.descr.PackageDescr;
import org.kie.api.internal.assembler.KieAssemblerService;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.io.ResourceWithConfiguration;
import org.kie.internal.pmml.PMMLImplementationsUtil;
import org.kie.pmml.commons.model.HasNestedModels;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.evaluator.api.container.PMMLPackage;
import org.kie.pmml.evaluator.assembler.container.PMMLPackageImpl;
import org.kie.pmml.evaluator.assembler.service.PMMLCompilerService;
import org.kie.pmml.evaluator.assembler.service.PMMLLoaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLAssemblerService
implements KieAssemblerService {
    public static final String PMML_COMPILER_CACHE_KEY = "PMML_COMPILER_CACHE_KEY";
    private static final Logger logger = LoggerFactory.getLogger(PMMLAssemblerService.class);
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";

    private static boolean isBuildFromMaven() {
        String property = System.getProperty("kie-maven-plugin-launcher", "false");
        return property.equals("true");
    }

    public static String[] getFactoryClassNamePackageName(Resource resource) {
        String sourcePath = resource.getSourcePath();
        if (sourcePath == null || sourcePath.isEmpty()) {
            throw new IllegalArgumentException("Missing required sourcePath in resource " + resource + " -> " + resource.getClass().getName());
        }
        return PMMLAssemblerService.getFactoryClassNamePackageName(sourcePath);
    }

    static String[] getFactoryClassNamePackageName(String sourcePath) {
        sourcePath = sourcePath.replace(WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        String fileName = sourcePath.substring(sourcePath.lastIndexOf(FOLDER_SEPARATOR) + 1);
        fileName = fileName.replace(".pmml", "");
        String packageName = KiePMMLModelUtils.getSanitizedPackageName((String)fileName);
        String factoryClassName = KiePMMLModelUtils.getSanitizedClassName((String)(fileName + "Factory"));
        return new String[]{factoryClassName, packageName};
    }

    public ResourceType getResourceType() {
        return ResourceType.PMML;
    }

    public void addResourcesAfterRules(Object kbuilder, Collection<ResourceWithConfiguration> resources, ResourceType type) {
        KnowledgeBuilderImpl kbuilderImpl = (KnowledgeBuilderImpl)kbuilder;
        if (PMMLImplementationsUtil.isjPMMLAvailableToClassLoader((ClassLoader)kbuilderImpl.getRootClassLoader())) {
            return;
        }
        if (PMMLAssemblerService.isBuildFromMaven()) {
            this.addModels(kbuilderImpl, PMMLCompilerService.getKiePMMLModelsFromResourcesWithConfigurationsWithSources(kbuilderImpl, resources));
        } else {
            List<KiePMMLModel> toAdd = PMMLLoaderService.getKiePMMLModelsLoadedFromResourcesWithConfigurations(kbuilderImpl, resources);
            if (toAdd.isEmpty()) {
                toAdd = PMMLCompilerService.getKiePMMLModelsCompiledFromResourcesWithConfigurations(kbuilderImpl, resources);
            }
            this.addModels(kbuilderImpl, toAdd);
        }
    }

    public void addResourceAfterRules(Object kbuilder, Resource resource, ResourceType type, ResourceConfiguration configuration) {
        logger.warn("invoked legacy addResourceAfterRules (no control on the order of the assembler compilation): {}", (Object)resource.getSourcePath());
        KnowledgeBuilderImpl kbuilderImpl = (KnowledgeBuilderImpl)kbuilder;
        if (PMMLImplementationsUtil.isjPMMLAvailableToClassLoader((ClassLoader)kbuilderImpl.getRootClassLoader())) {
            return;
        }
        if (PMMLAssemblerService.isBuildFromMaven()) {
            this.addModels(kbuilderImpl, PMMLCompilerService.getKiePMMLModelsFromResourceWithSources(kbuilderImpl, resource));
        } else {
            List<KiePMMLModel> toAdd = PMMLLoaderService.getKiePMMLModelsLoadedFromResource(kbuilderImpl, resource);
            if (toAdd.isEmpty()) {
                toAdd = PMMLCompilerService.getKiePMMLModelsCompiledFromResource(kbuilderImpl, resource);
            }
            this.addModels(kbuilderImpl, toAdd);
        }
    }

    protected void addModels(KnowledgeBuilderImpl kbuilderImpl, List<KiePMMLModel> toAdd) {
        for (KiePMMLModel kiePMMLModel : toAdd) {
            PackageDescr pkgDescr = new PackageDescr(kiePMMLModel.getKModulePackageName());
            PackageRegistry pkgReg = kbuilderImpl.getOrCreatePackageRegistry(pkgDescr);
            InternalKnowledgePackage kpkgs = pkgReg.getPackage();
            ResourceTypePackageRegistry rpkg = kpkgs.getResourceTypePackages();
            PMMLPackage pmmlPkg = (PMMLPackage)rpkg.computeIfAbsent(ResourceType.PMML, rtp -> new PMMLPackageImpl());
            pmmlPkg.addAll(Collections.singletonList(kiePMMLModel));
            if (!(kiePMMLModel instanceof HasNestedModels)) continue;
            this.addModels(kbuilderImpl, ((HasNestedModels)kiePMMLModel).getNestedModels());
        }
    }
}

