/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.clustering.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.data.Percentage;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

public class MultipleClustersSameClassTest
extends AbstractPMMLTest {
    private static final double DOUBLE_VALID_PERCENTAGE = 0.99999;
    private static final String FILE_NAME_NO_SUFFIX = "multipleClustersSameClass";
    private static final String MODEL_NAME = "multipleClusterSameClassModel";
    private static final String AFFINITY_FIELD = "predictedAffinity";
    private static final String CLUSTER_AFFINITY_FIELD = "predictedClusterAffinity";
    private static final String CLUSTER_ID_FIELD = "predictedValue";
    private static final String CLUSTER_NAME_FIELD = "predictedDisplayValue";
    protected static PMMLRuntime pmmlRuntime;
    private double dimension1;
    private double dimension2;
    private String classId;
    private String className;
    private double affinity;

    public void initMultipleClustersSameClassTest(double dimension1, double dimension2, String classId, String className, double affinity) {
        this.dimension1 = dimension1;
        this.dimension2 = dimension2;
        this.classId = classId;
        this.className = className;
        this.affinity = affinity;
    }

    @BeforeAll
    public static void setupClass() {
        pmmlRuntime = MultipleClustersSameClassTest.getPMMLRuntime((String)FILE_NAME_NO_SUFFIX);
    }

    public static Collection<Object[]> data() {
        return Arrays.asList({0.0, 0.0, "1", "classA", 0.0}, {0.5, 0.0, "1", "classA", 0.25}, {1.0, 1.0, "2", "classB", 0.0}, {1.0, 3.0, "2", "classB", 4.0}, {-1, -1, "3", "classA", 0.0}, {-1.3, -1.4, "3", "classA", 0.25}, {5.0, 5.0, "4", "classB", 0.0}, {8.0, 9.0, "4", "classB", 25.0}, {-3.0, 5.0, "5", "classC", 0.0}, {-2.0, 5.0, "5", "classC", 1.0});
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void test(double dimension1, double dimension2, String classId, String className, double affinity) {
        this.initMultipleClustersSameClassTest(dimension1, dimension2, classId, className, affinity);
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("Dimension1", dimension1);
        inputData.put("Dimension2", dimension2);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, FILE_NAME_NO_SUFFIX, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(CLUSTER_ID_FIELD)).isEqualTo((Object)classId);
        Assertions.assertThat(pmml4Result.getResultVariables().get(CLUSTER_NAME_FIELD)).isEqualTo((Object)className);
        MultipleClustersSameClassTest.assertDoubleVariable(pmml4Result, AFFINITY_FIELD, affinity);
        MultipleClustersSameClassTest.assertDoubleVariable(pmml4Result, CLUSTER_AFFINITY_FIELD, affinity);
    }

    private static void assertDoubleVariable(PMML4Result pmml4Result, String variableName, double expectedValue) {
        ((AbstractDoubleAssert)Assertions.assertThat(pmml4Result.getResultVariables().get(variableName)).asInstanceOf(InstanceOfAssertFactories.DOUBLE)).isCloseTo(expectedValue, Percentage.withPercentage((double)0.99999));
    }
}

