/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.clustering.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

public class SingleIrisKMeansClusteringTest
extends AbstractPMMLTest {
    private static final String FILE_NAME_NO_SUFFIX = "SingleIrisKMeansClustering";
    private static final String MODEL_NAME = "SingleIrisKMeansClustering";
    private static final String TARGET_FIELD = "class";
    private static final String OUT_NORMCONTINUOUS_FIELD = "out_normcontinuous_field";
    private static final String OUT_NORMDISCRETE_FIELD = "out_normdiscrete_field";
    private static final String OUT_DISCRETIZE_FIELD = "out_discretize_field";
    private static final String OUT_MAPVALUED_FIELD = "out_mapvalued_field";
    private static final String PREDICTED_CLUSTER_NAME_FIELD = "predicted_cluster_name";
    private static final String PREDICTED_CLUSTER_INDEX_FIELD = "predicted_cluster_index";
    private static final String PREDICTED_CLUSTER_AFFINITY_FIELD = "predicted_cluster_affinity";
    private static PMMLRuntime pmmlRuntime;
    private double sepalLength;
    private double sepalWidth;
    private double petalLength;
    private double petalWidth;
    private double outNormcontinuousField;
    private String predictedDisplayValue;
    private int predictedEntityId;
    private double predictedAffinity;
    private String irisClass;

    public static Collection<Object[]> data() {
        return Arrays.asList({4.4, 3.0, 1.3, 0.2, 4.966666666666667, "cluster_3", 3, 0.5707919999999993, "3"}, {5.0, 3.3, 1.4, 0.2, 5.433333333333334, "cluster_3", 3, 0.019992000000000173, "3"}, {7.0, 3.2, 4.7, 1.4, 6.950000000000001, "cluster_2", 2, 0.7601784651992836, "2"}, {5.7, 2.8, 4.1, 1.3, 5.937500000000001, "cluster_4", 4, 0.09263374485596694, "4"}, {6.3, 3.3, 6.0, 2.5, 6.1625, "cluster_1", 1, 0.5745800781250017, "1"}, {6.7, 3.0, 5.2, 2.3, 6.575, "cluster_1", 1, 0.5020800781249984, "1"});
    }

    public void initSingleIrisKMeansClusteringTest(double sepalLength, double sepalWidth, double petalLength, double petalWidth, double outNormcontinuousField, String predictedDisplayValue, int predictedEntityId, double predictedAffinity, String irisClass) {
        this.sepalLength = sepalLength;
        this.sepalWidth = sepalWidth;
        this.petalLength = petalLength;
        this.petalWidth = petalWidth;
        this.irisClass = irisClass;
        this.outNormcontinuousField = outNormcontinuousField;
        this.predictedDisplayValue = predictedDisplayValue;
        this.predictedEntityId = predictedEntityId;
        this.predictedAffinity = predictedAffinity;
    }

    @BeforeAll
    public static void setupClass() {
        pmmlRuntime = SingleIrisKMeansClusteringTest.getPMMLRuntime((String)"SingleIrisKMeansClustering");
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testLogisticRegressionIrisData(double sepalLength, double sepalWidth, double petalLength, double petalWidth, double outNormcontinuousField, String predictedDisplayValue, int predictedEntityId, double predictedAffinity, String irisClass) throws Exception {
        String expected;
        this.initSingleIrisKMeansClusteringTest(sepalLength, sepalWidth, petalLength, petalWidth, outNormcontinuousField, predictedDisplayValue, predictedEntityId, predictedAffinity, irisClass);
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("sepal_length", sepalLength);
        inputData.put("sepal_width", sepalWidth);
        inputData.put("petal_length", petalLength);
        inputData.put("petal_width", petalWidth);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, "SingleIrisKMeansClustering", "SingleIrisKMeansClustering");
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)irisClass);
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMCONTINUOUS_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMCONTINUOUS_FIELD)).isEqualTo((Object)outNormcontinuousField);
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMDISCRETE_FIELD)).isNotNull();
        if (irisClass.equals("1")) {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMDISCRETE_FIELD)).isEqualTo((Object)1.0);
        } else {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMDISCRETE_FIELD)).isEqualTo((Object)0.0);
        }
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isNotNull();
        if (sepalLength > 4.7 && sepalLength < 5.2) {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isEqualTo((Object)"abc");
        } else if (sepalLength >= 5.6 && sepalLength < 5.9) {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isEqualTo((Object)"def");
        } else {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isEqualTo((Object)"defaultValue");
        }
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_MAPVALUED_FIELD)).isNotNull();
        switch (irisClass) {
            case "1": 
            case "C_ONE": {
                expected = "virginica";
                break;
            }
            case "2": 
            case "C_TWO": {
                expected = "versicolor";
                break;
            }
            case "3": 
            case "C_THREE": {
                expected = "setosa";
                break;
            }
            case "4": 
            case "C_FOUR": {
                expected = "unknown";
                break;
            }
            default: {
                throw new Exception("Unexpected irisClass " + irisClass);
            }
        }
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_MAPVALUED_FIELD)).isEqualTo((Object)expected);
        Assertions.assertThat(pmml4Result.getResultVariables().get(PREDICTED_CLUSTER_NAME_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(PREDICTED_CLUSTER_NAME_FIELD)).isEqualTo((Object)predictedDisplayValue);
        Assertions.assertThat(pmml4Result.getResultVariables().get(PREDICTED_CLUSTER_INDEX_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(PREDICTED_CLUSTER_INDEX_FIELD)).isEqualTo((Object)predictedEntityId);
        Assertions.assertThat(pmml4Result.getResultVariables().get(PREDICTED_CLUSTER_AFFINITY_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(PREDICTED_CLUSTER_AFFINITY_FIELD)).isEqualTo((Object)predictedAffinity);
    }
}

