/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.utils;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Model;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.enums.MINING_FUNCTION;
import org.kie.pmml.commons.model.enums.PMML_MODEL;
import org.kie.pmml.commons.model.enums.RESULT_FEATURE;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.factories.KiePMMLOutputFieldFactory;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.ModelUtils;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLDroolsModelFactoryUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLDroolsModelFactoryUtils.class.getName());

    private KiePMMLDroolsModelFactoryUtils() {
    }

    public static CompilationUnit getKiePMMLModelCompilationUnit(DataDictionary dataDictionary, Model model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, String packageName, String javaTemplate, String modelClassName) {
        logger.trace("getKiePMMLModelCompilationUnit {} {} {}", new Object[]{dataDictionary, model, packageName});
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        String targetField = ModelUtils.getTargetFieldName((DataDictionary)dataDictionary, (Model)model).orElse(null);
        List outputFields = KiePMMLOutputFieldFactory.getOutputFields((Model)model);
        CompilationUnit templateCU = JavaParserUtils.getFromFileName((String)javaTemplate);
        CompilationUnit cloneCU = templateCU.clone();
        cloneCU.setPackageDeclaration(packageName);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(modelClassName).orElseThrow(() -> new KiePMMLException("Main class not found: " + modelClassName));
        modelTemplate.setName(className);
        MINING_FUNCTION miningFunction = MINING_FUNCTION.byName((String)model.getMiningFunction().value());
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        KiePMMLDroolsModelFactoryUtils.setConstructor(model, constructorDeclaration, modelTemplate.getName(), targetField, miningFunction);
        KiePMMLDroolsModelFactoryUtils.addOutputFieldsPopulation(constructorDeclaration.getBody(), outputFields);
        KiePMMLDroolsModelFactoryUtils.addFieldTypeMapPopulation(constructorDeclaration.getBody(), fieldTypeMap);
        return cloneCU;
    }

    static void setConstructor(Model model, ConstructorDeclaration constructorDeclaration, SimpleName tableName, String targetField, MINING_FUNCTION miningFunction) {
        constructorDeclaration.setName(tableName);
        BlockStmt body = constructorDeclaration.getBody();
        List assignExprs = body.findAll(AssignExpr.class);
        assignExprs.forEach(assignExpr -> {
            if (assignExpr.getTarget().asNameExpr().getNameAsString().equals("targetField")) {
                assignExpr.setValue((Expression)new StringLiteralExpr(targetField));
            } else if (assignExpr.getTarget().asNameExpr().getNameAsString().equals("miningFunction")) {
                assignExpr.setValue((Expression)new NameExpr(miningFunction.getClass().getName() + "." + miningFunction.name()));
            } else if (assignExpr.getTarget().asNameExpr().getNameAsString().equals("pmmlMODEL")) {
                PMML_MODEL pmmlModel = PMML_MODEL.byName((String)model.getClass().getSimpleName());
                assignExpr.setValue((Expression)new NameExpr(pmmlModel.getClass().getName() + "." + pmmlModel.name()));
            }
        });
    }

    static void addOutputFieldsPopulation(BlockStmt body, List<KiePMMLOutputField> outputFields) {
        for (KiePMMLOutputField outputField : outputFields) {
            NodeList expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(outputField.getName()), new NameExpr("Collections.emptyList()")});
            MethodCallExpr builder = new MethodCallExpr((Expression)new NameExpr("KiePMMLOutputField"), "builder", expressions);
            if (outputField.getRank() != null) {
                expressions = NodeList.nodeList((Node[])new Expression[]{new IntegerLiteralExpr(outputField.getRank().intValue())});
                builder = new MethodCallExpr((Expression)builder, "withRank", expressions);
            }
            if (outputField.getValue() != null) {
                expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(outputField.getValue().toString())});
                builder = new MethodCallExpr((Expression)builder, "withValue", expressions);
            }
            if (outputField.getTargetField().isPresent()) {
                expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr((String)outputField.getTargetField().get())});
                builder = new MethodCallExpr((Expression)builder, "withTargetField", expressions);
            }
            if (outputField.getResultFeature() != null) {
                expressions = NodeList.nodeList((Node[])new Expression[]{new NameExpr(RESULT_FEATURE.class.getName() + "." + outputField.getResultFeature().toString())});
                builder = new MethodCallExpr((Expression)builder, "withResultFeature", expressions);
            }
            MethodCallExpr newOutputField = new MethodCallExpr((Expression)builder, "build");
            expressions = NodeList.nodeList((Node[])new Expression[]{newOutputField});
            body.addStatement((Expression)new MethodCallExpr((Expression)new NameExpr("outputFields"), "add", expressions));
        }
    }

    static void addFieldTypeMapPopulation(BlockStmt body, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        for (Map.Entry<String, KiePMMLOriginalTypeGeneratedType> entry : fieldTypeMap.entrySet()) {
            KiePMMLOriginalTypeGeneratedType kiePMMLOriginalTypeGeneratedType = entry.getValue();
            NodeList expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(kiePMMLOriginalTypeGeneratedType.getOriginalType()), new StringLiteralExpr(kiePMMLOriginalTypeGeneratedType.getGeneratedType())});
            ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
            objectCreationExpr.setType(KiePMMLOriginalTypeGeneratedType.class.getName());
            objectCreationExpr.setArguments(expressions);
            expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(entry.getKey()), objectCreationExpr});
            body.addStatement((Expression)new MethodCallExpr((Expression)new NameExpr("fieldTypeMap"), "put", expressions));
        }
    }
}

