/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.commons.model.enums.DATA_TYPE;
import org.kie.pmml.commons.model.enums.OPERATOR;
import org.kie.pmml.models.drools.ast.KiePMMLFieldOperatorValue;
import org.kie.pmml.models.drools.commons.utils.KiePMMLDroolsModelUtils;
import org.kie.pmml.models.drools.tuples.KiePMMLOperatorValue;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;

public class KiePMMLASTFactoryUtils {
    private KiePMMLASTFactoryUtils() {
    }

    public static List<KiePMMLFieldOperatorValue> getConstraintEntriesFromAndOrCompoundPredicate(CompoundPredicate compoundPredicate, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        List simplePredicates = compoundPredicate.getPredicates().stream().filter(predicate -> predicate instanceof SimplePredicate).collect(Collectors.toList());
        if (!CompoundPredicate.BooleanOperator.AND.equals((Object)compoundPredicate.getBooleanOperator()) && !CompoundPredicate.BooleanOperator.OR.equals((Object)compoundPredicate.getBooleanOperator())) {
            throw new KiePMMLException(String.format("getConstraintEntriesFromAndOrCompoundPredicate invoked with %s CompoundPredicate", compoundPredicate.getBooleanOperator()));
        }
        Map<String, List<SimplePredicate>> predicatesByField = simplePredicates.stream().map(child -> (SimplePredicate)child).collect(Collectors.groupingBy(child -> ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get(child.getField().getValue())).getGeneratedType()));
        LinkedList<KiePMMLFieldOperatorValue> toReturn = new LinkedList<KiePMMLFieldOperatorValue>();
        KiePMMLASTFactoryUtils.populateKiePMMLFieldOperatorValueListWithSimplePredicates(toReturn, compoundPredicate.getBooleanOperator(), predicatesByField, fieldTypeMap);
        List<CompoundPredicate> compoundPredicates = compoundPredicate.getPredicates().stream().filter(predicate -> predicate instanceof CompoundPredicate).map(predicate -> (CompoundPredicate)predicate).collect(Collectors.toList());
        KiePMMLASTFactoryUtils.populateKiePMMLFieldOperatorValueListWithCompoundPredicates(toReturn, compoundPredicates, fieldTypeMap);
        return toReturn;
    }

    public static List<KiePMMLFieldOperatorValue> getConstraintEntriesFromXOrCompoundPredicate(CompoundPredicate compoundPredicate, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        if (!CompoundPredicate.BooleanOperator.XOR.equals((Object)compoundPredicate.getBooleanOperator())) {
            throw new KiePMMLException(String.format("getConstraintEntriesFromXOrCompoundPredicate invoked with %s CompoundPredicate", compoundPredicate.getBooleanOperator()));
        }
        List<Predicate> simplePredicates = compoundPredicate.getPredicates().stream().filter(predicate -> predicate instanceof SimplePredicate).collect(Collectors.toList());
        if (simplePredicates.size() < 2) {
            throw new KiePMMLException("At least two elements expected for XOR operations");
        }
        if (simplePredicates.size() > 2) {
            throw new KiePMMLException("More then two elements not managed, yet, for XOR operations");
        }
        return KiePMMLASTFactoryUtils.getXORConstraintEntryFromSimplePredicates(simplePredicates, fieldTypeMap);
    }

    public static KiePMMLFieldOperatorValue getConstraintEntryFromSimplePredicates(String fieldName, BOOLEAN_OPERATOR containerOperator, List<SimplePredicate> simplePredicates, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        List<KiePMMLOperatorValue> kiePMMLOperatorValues = simplePredicates.stream().map(simplePredicate -> new KiePMMLOperatorValue(OPERATOR.byName((String)simplePredicate.getOperator().value()), KiePMMLASTFactoryUtils.getCorrectlyFormattedObject(simplePredicate, fieldTypeMap))).collect(Collectors.toList());
        return new KiePMMLFieldOperatorValue(fieldName, containerOperator, kiePMMLOperatorValues, null);
    }

    public static List<KiePMMLFieldOperatorValue> getXORConstraintEntryFromSimplePredicates(List<Predicate> predicates, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        return predicates.stream().filter(predicate -> predicate instanceof SimplePredicate).map(predicate -> {
            SimplePredicate simplePredicate = (SimplePredicate)predicate;
            String fieldName = ((KiePMMLOriginalTypeGeneratedType)fieldTypeMap.get(simplePredicate.getField().getValue())).getGeneratedType();
            OPERATOR operator = OPERATOR.byName((String)simplePredicate.getOperator().value());
            Object value = KiePMMLASTFactoryUtils.getCorrectlyFormattedObject(simplePredicate, fieldTypeMap);
            return new KiePMMLFieldOperatorValue(fieldName, null, Collections.singletonList(new KiePMMLOperatorValue(operator, value)), null);
        }).collect(Collectors.toList());
    }

    public static Object getCorrectlyFormattedObject(SimplePredicate simplePredicate, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        DATA_TYPE dataType = DATA_TYPE.byName((String)fieldTypeMap.get(simplePredicate.getField().getValue()).getOriginalType());
        return KiePMMLDroolsModelUtils.getCorrectlyFormattedResult(simplePredicate.getValue(), dataType);
    }

    static void populateKiePMMLFieldOperatorValueListWithSimplePredicates(List<KiePMMLFieldOperatorValue> toPopulate, CompoundPredicate.BooleanOperator booleanOperator, Map<String, List<SimplePredicate>> predicatesByField, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        switch (booleanOperator) {
            case AND: {
                predicatesByField.forEach((fieldName, predicates) -> toPopulate.add(KiePMMLASTFactoryUtils.getConstraintEntryFromSimplePredicates(fieldName, BOOLEAN_OPERATOR.AND, predicates, fieldTypeMap)));
                break;
            }
            case OR: {
                predicatesByField.forEach((fieldName, predicates) -> toPopulate.add(KiePMMLASTFactoryUtils.getConstraintEntryFromSimplePredicates(fieldName, BOOLEAN_OPERATOR.OR, predicates, fieldTypeMap)));
                break;
            }
            default: {
                throw new IllegalStateException(String.format("CompoundPredicate.booleanOperator should never be %s at this point", booleanOperator));
            }
        }
    }

    static void populateKiePMMLFieldOperatorValueListWithCompoundPredicates(List<KiePMMLFieldOperatorValue> toPopulate, List<CompoundPredicate> compoundPredicates, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        LinkedList<KiePMMLFieldOperatorValue> nestedAndPredicates = new LinkedList<KiePMMLFieldOperatorValue>();
        LinkedList<KiePMMLFieldOperatorValue> nestedOrPredicates = new LinkedList<KiePMMLFieldOperatorValue>();
        compoundPredicates.forEach(nestedCompoundPredicate -> {
            switch (nestedCompoundPredicate.getBooleanOperator()) {
                case OR: {
                    nestedOrPredicates.addAll(KiePMMLASTFactoryUtils.getConstraintEntriesFromAndOrCompoundPredicate(nestedCompoundPredicate, fieldTypeMap));
                    break;
                }
                case AND: {
                    nestedAndPredicates.addAll(KiePMMLASTFactoryUtils.getConstraintEntriesFromAndOrCompoundPredicate(nestedCompoundPredicate, fieldTypeMap));
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unmanaged CompoundPredicate.booleanOperator %s at populateKiePMMLFieldOperatorValueListWithCompoundPredicates", nestedCompoundPredicate.getBooleanOperator()));
                }
            }
        });
        if (!nestedAndPredicates.isEmpty()) {
            toPopulate.add(new KiePMMLFieldOperatorValue(null, BOOLEAN_OPERATOR.AND, Collections.emptyList(), nestedAndPredicates));
        }
        if (!nestedOrPredicates.isEmpty()) {
            toPopulate.add(new KiePMMLFieldOperatorValue(null, BOOLEAN_OPERATOR.OR, Collections.emptyList(), nestedOrPredicates));
        }
    }
}

