/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.factories;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeature;
import org.drools.compiler.lang.api.DescrFactory;
import org.drools.compiler.lang.api.PackageDescrBuilder;
import org.drools.compiler.lang.api.RuleDescrBuilder;
import org.drools.compiler.lang.descr.RuleDescr;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrRhsFactory;

public class KiePMMLDescrRhsFactoryTest {
    private static final String CURRENT_RULE = "currentRule";
    private RuleDescrBuilder ruleBuilder;

    @Before
    public void setUp() throws Exception {
        PackageDescrBuilder builder = DescrFactory.newPackage().name("PACKAGE_NAME");
        this.ruleBuilder = builder.newRule().name(CURRENT_RULE);
        Assertions.assertThat((String)((RuleDescr)this.ruleBuilder.getDescr()).getName()).isEqualTo(CURRENT_RULE);
    }

    @Test
    public void declareRhsWithoutIfBreak() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).build();
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).declareRhs(rule);
        Assertions.assertThat((Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence()).isNotNull();
        String expectedConsequence = String.format("\r\n$statusHolder.setStatus(\"%s\");", statusToSet);
        Assertions.assertThat((String)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence().toString()).contains(new CharSequence[]{expectedConsequence});
        Assertions.assertThat((Map)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences()).isNotNull();
        Assertions.assertThat((Map)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences()).isEmpty();
    }

    @Test
    public void declareRhsWithIfBreak() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        String ifBreakField = "ifBreakField";
        String ifBreakOperator = "ifBreakOperator";
        String ifBreakValue = "ifBreakValue";
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).withIfBreak(ifBreakField, ifBreakOperator, (Object)ifBreakValue).build();
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).declareRhs(rule);
        Assertions.assertThat((Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence()).isNotNull();
        String expectedConsequence = String.format("\r\n$statusHolder.setStatus(\"%s\");", statusToSet);
        Assertions.assertThat((String)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence().toString()).contains(new CharSequence[]{expectedConsequence});
        Assertions.assertThat((Map)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences()).isNotNull();
        Assertions.assertThat((Map)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences()).hasSize(1);
        Assertions.assertThat(((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().get("match")).isNotNull();
    }

    @Test
    public void declareDefaultThenWithoutResult() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).build();
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).declareDefaultThen(rule);
        Assertions.assertThat((Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence()).isNotNull();
        String expectedConsequence = String.format("\r\n$statusHolder.setStatus(\"%s\");", statusToSet);
        Assertions.assertThat((String)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence().toString()).contains(new CharSequence[]{expectedConsequence});
        Assertions.assertThat((Map)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences()).isNotNull();
        Assertions.assertThat((Map)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences()).isEmpty();
    }

    @Test
    public void declareDefaultThenWithResult() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        String result = "RESULT";
        ResultCode resultCode = ResultCode.OK;
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).withResultCode(resultCode).withResult((Object)result).build();
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).declareDefaultThen(rule);
        Assertions.assertThat((Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence()).isNotNull();
        String retrievedConsequence = ((RuleDescr)this.ruleBuilder.getDescr()).getConsequence().toString();
        Assertions.assertThat((String)retrievedConsequence).contains(new CharSequence[]{String.format("\r\n$statusHolder.setStatus(\"%s\");", statusToSet)});
        Assertions.assertThat((String)retrievedConsequence).contains(new CharSequence[]{String.format("\r\n$pmml4Result.setResultCode(\"%s\");", resultCode)});
        Assertions.assertThat((String)retrievedConsequence).contains(new CharSequence[]{String.format("\r\n$pmml4Result.addResultVariable($pmml4Result.getResultObjectName(), %s);", result)});
        Assertions.assertThat((Map)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences()).isNotNull();
        Assertions.assertThat((Map)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences()).isEmpty();
    }

    @Test
    public void declareIfThenWithoutResult() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).build();
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).declareIfThen(rule);
        Assertions.assertThat((Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence()).isNotNull();
        String expectedConsequence = String.format("\r\n$statusHolder.setStatus(\"%s\");", statusToSet);
        Assertions.assertThat((Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence()).isEqualTo((Object)expectedConsequence);
        Assertions.assertThat((Map)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences()).isNotNull();
        Assertions.assertThat((Map)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences()).hasSize(1);
        Assertions.assertThat(((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().get("match")).isNotNull();
        expectedConsequence = String.format("\r\n$statusHolder.setStatus(\"%s\");", "DONE");
        ((AbstractStringAssert)Assertions.assertThat((String)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().get("match").toString()).as(expectedConsequence, new Object[0])).contains(new CharSequence[]{expectedConsequence});
    }

    @Test
    public void declareIfThenWithResult() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        String result = "RESULT";
        ResultCode resultCode = ResultCode.OK;
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).withResultCode(resultCode).withResult((Object)result).build();
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).declareIfThen(rule);
        Assertions.assertThat((Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence()).isNotNull();
        String expectedConsequence = String.format("\r\n$statusHolder.setStatus(\"%s\");", statusToSet);
        Assertions.assertThat((Object)((RuleDescr)this.ruleBuilder.getDescr()).getConsequence()).isEqualTo((Object)expectedConsequence);
        Assertions.assertThat((Map)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences()).isNotNull();
        Assertions.assertThat((Map)((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences()).hasSize(1);
        Assertions.assertThat(((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().get("match")).isNotNull();
        String retrievedConsequence = ((RuleDescr)this.ruleBuilder.getDescr()).getNamedConsequences().get("match").toString();
        Assertions.assertThat((String)retrievedConsequence).contains(new CharSequence[]{String.format("\r\n$statusHolder.setStatus(\"%s\");", "DONE")});
        Assertions.assertThat((String)retrievedConsequence).contains(new CharSequence[]{String.format("\r\n$pmml4Result.setResultCode(\"%s\");", resultCode)});
        Assertions.assertThat((String)retrievedConsequence).contains(new CharSequence[]{String.format("\r\n$pmml4Result.addResultVariable($pmml4Result.getResultObjectName(), %s);", result)});
    }

    @Test
    public void commonDeclareThen() {
        String ruleName = "RULENAME";
        String statusToSet = "STATUSTOSET";
        String outputFieldName = "OUTPUTFIELDNAME";
        String result = "RESULT";
        OutputField outputField = new OutputField();
        outputField.setName(FieldName.create((String)outputFieldName));
        outputField.setResultFeature(ResultFeature.PREDICTED_VALUE);
        List<OutputField> outputFields = Collections.singletonList(outputField);
        KiePMMLDroolsRule.Builder builder = KiePMMLDroolsRule.builder((String)ruleName, (String)statusToSet, outputFields);
        KiePMMLDroolsRule rule = builder.build();
        StringJoiner joiner = new StringJoiner("");
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).commonDeclareThen(rule, joiner);
        String retrieved = joiner.toString();
        Assertions.assertThat((String)retrieved).isEmpty();
        ResultCode resultCode = ResultCode.OK;
        builder = builder.withResultCode(resultCode);
        rule = builder.build();
        joiner = new StringJoiner("");
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).commonDeclareThen(rule, joiner);
        retrieved = joiner.toString();
        String expected = String.format("\r\n$pmml4Result.setResultCode(\"%s\");", resultCode);
        Assertions.assertThat((String)retrieved).contains(new CharSequence[]{expected});
        builder = builder.withResult((Object)result);
        rule = builder.build();
        joiner = new StringJoiner("");
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).commonDeclareThen(rule, joiner);
        retrieved = joiner.toString();
        expected = String.format("\r\n$pmml4Result.addResultVariable($pmml4Result.getResultObjectName(), %s);", result);
        Assertions.assertThat((String)retrieved).contains(new CharSequence[]{expected});
        expected = String.format("\r\n$pmml4Result.addResultVariable(\"%s\", %s);", outputFieldName, result);
        Assertions.assertThat((String)retrieved).contains(new CharSequence[]{expected});
        String focusedAgendaGroup = "FOCUSEDAGENDAGROUP";
        builder = builder.withFocusedAgendaGroup(focusedAgendaGroup);
        rule = builder.build();
        joiner = new StringJoiner("");
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).commonDeclareThen(rule, joiner);
        retrieved = joiner.toString();
        expected = String.format("\r\nkcontext.getKieRuntime().getAgenda().getAgendaGroup( \"%s\" ).setFocus();", focusedAgendaGroup);
        Assertions.assertThat((String)retrieved).contains(new CharSequence[]{expected});
    }

    @Test
    public void commonDeclareOutputFields() {
        String outputFieldName = "OUTPUTFIELDNAME";
        String result = "RESULT";
        OutputField outputField = new OutputField();
        outputField.setName(FieldName.create((String)outputFieldName));
        outputField.setResultFeature(ResultFeature.PREDICTED_VALUE);
        List<OutputField> outputFields = Collections.singletonList(outputField);
        StringJoiner joiner = new StringJoiner("");
        KiePMMLDescrRhsFactory.factory((RuleDescrBuilder)this.ruleBuilder).commonDeclareOutputFields(outputFields, (Object)result, joiner);
        String retrieved = joiner.toString();
        String expected = String.format("\r\n$pmml4Result.addResultVariable(\"%s\", %s);", outputFieldName, result);
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
    }
}

