/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.provider;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.scorecard.Scorecard;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.CommonTestingUtils;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.testutils.TestUtils;
import org.kie.pmml.compiler.commons.mocks.HasClassLoaderMock;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.commons.implementations.HasKnowledgeBuilderMock;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModel;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModelWithSources;
import org.kie.pmml.models.drools.dto.DroolsCompilationDTO;
import org.kie.pmml.models.drools.provider.DroolsModelProvider;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;

public class DroolsModelProviderTest {
    private static final String SOURCE_1 = "SimpleScorecardWithTransformations.pmml";
    private static final Map<String, String> SOURCE_MAP = new HashMap<String, String>();
    private static PMML pmml;
    private static Scorecard scorecard;
    private static DroolsModelProvider<Scorecard, ? extends KiePMMLDroolsModel> droolsModelProvider;

    @BeforeClass
    public static void setup() throws Exception {
        pmml = TestUtils.loadFromFile((String)SOURCE_1);
        Assertions.assertThat((Object)pmml).isNotNull();
        scorecard = (Scorecard)pmml.getModels().get(0);
        Assertions.assertThat((Object)scorecard).isNotNull();
        droolsModelProvider = new DroolsModelProvider<Scorecard, KiePMMLDroolsModel>(){

            public KiePMMLDroolsModel getKiePMMLDroolsModel(DroolsCompilationDTO<Scorecard> compilationDTO) {
                return new KiePMMLDroolsModelTest(compilationDTO.getFields(), compilationDTO.getTransformationDictionary(), (Scorecard)compilationDTO.getModel(), compilationDTO.getFieldTypeMap());
            }

            public KiePMMLDroolsAST getKiePMMLDroolsAST(List<Field<?>> fields, Scorecard model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, List<KiePMMLDroolsType> types) {
                return new KiePMMLDroolsASTTest(fields, model, fieldTypeMap, types);
            }

            public Map<String, String> getKiePMMLDroolsModelSourcesMap(DroolsCompilationDTO<Scorecard> compilationDTO) throws IOException {
                return SOURCE_MAP;
            }

            public PMML_MODEL getPMMLModelType() {
                return PMML_MODEL.SCORECARD_MODEL;
            }
        };
    }

    @Test
    public void getKiePMMLModelWithKnowledgeBuilder() {
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)scorecard, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        KiePMMLDroolsModel retrieved = droolsModelProvider.getKiePMMLModel((CompilationDTO)compilationDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Object)retrieved).isInstanceOf(KiePMMLDroolsModelTest.class);
        KiePMMLDroolsModelTest retrievedTest = (KiePMMLDroolsModelTest)retrieved;
        List originalDataFields = pmml.getDataDictionary().getDataFields();
        List retrievedDataFields = retrievedTest.dataDictionary.getDataFields();
        Assertions.assertThat((List)retrievedTest.dataDictionary.getDataFields()).hasSameSizeAs((Iterable)originalDataFields);
        originalDataFields.forEach(dataField -> {
            Optional<DataField> optRet = retrievedDataFields.stream().filter(retrievedDataField -> dataField.getName().equals((Object)retrievedDataField.getName())).findFirst();
            Assertions.assertThat(optRet).isPresent();
            Assertions.assertThat((Comparable)optRet.get().getDataType()).isEqualTo((Object)dataField.getDataType());
        });
        Assertions.assertThat((Object)retrievedTest.transformationDictionary).isEqualTo((Object)pmml.getTransformationDictionary());
        Assertions.assertThat((Object)retrievedTest.model).isEqualTo((Object)scorecard);
        String expectedPackageName = KiePMMLModelUtils.getSanitizedPackageName((String)"PACKAGE_NAME");
        Assertions.assertThat((String)retrievedTest.getKModulePackageName()).isEqualTo(expectedPackageName);
        Assertions.assertThat((String)retrievedTest.getName()).isEqualTo("PACKAGE_NAME");
        PackageDescr packageDescr = (PackageDescr)knowledgeBuilder.getPackageDescrs("packagename").get(0);
        Assertions.assertThat((Object)packageDescr).isInstanceOf(CompositePackageDescr.class);
    }

    @Test(expected=KiePMMLException.class)
    public void getKiePMMLModelNoKnowledgeBuilder() {
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)scorecard, (HasClassLoader)new HasClassLoaderMock());
        droolsModelProvider.getKiePMMLModel((CompilationDTO)compilationDTO);
    }

    @Test
    public void getKiePMMLModelWithSourcesWithKnowledgeBuilder() {
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)scorecard, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        KiePMMLDroolsModelWithSources retrieved = droolsModelProvider.getKiePMMLModelWithSources((CompilationDTO)compilationDTO);
        Assertions.assertThat((Object)retrieved).isNotNull();
        Assertions.assertThat((Map)retrieved.getSourcesMap()).isEqualTo(SOURCE_MAP);
        String expectedPackageName = compilationDTO.getPackageName();
        Assertions.assertThat((String)retrieved.getKModulePackageName()).isEqualTo(expectedPackageName);
        Assertions.assertThat((String)retrieved.getName()).isEqualTo(scorecard.getModelName());
        PackageDescr packageDescr = (PackageDescr)knowledgeBuilder.getPackageDescrs(expectedPackageName).get(0);
        this.commonVerifyPackageDescr(packageDescr, expectedPackageName);
        Assertions.assertThat((Object)retrieved).isNotNull();
        String rootPath = expectedPackageName + ".";
        this.commonVerifyRulesSourcesMap(retrieved.getRulesSourcesMap(), packageDescr, rootPath);
    }

    @Test(expected=KiePMMLException.class)
    public void getKiePMMLModelWithSourcesNoKnowledgeBuilder() {
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)scorecard, (HasClassLoader)new HasClassLoaderMock());
        droolsModelProvider.getKiePMMLModelWithSources((CompilationDTO)compilationDTO);
    }

    @Test
    public void getPackageDescr() {
        KiePMMLDroolsAST kiePMMLDroolsAST = new KiePMMLDroolsAST(Collections.emptyList(), Collections.emptyList());
        PackageDescr retrieved = droolsModelProvider.getPackageDescr(kiePMMLDroolsAST, "PACKAGE_NAME");
        this.commonVerifyPackageDescr(retrieved, "PACKAGE_NAME");
    }

    @Test
    public void getKiePMMLDroolsASTCommon() {
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        List fields = CommonTestingUtils.getFieldsFromDataDictionaryAndTransformationDictionaryAndLocalTransformations((DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (LocalTransformations)scorecard.getLocalTransformations());
        KiePMMLDroolsAST retrieved = droolsModelProvider.getKiePMMLDroolsASTCommon(fields, (Model)scorecard, fieldTypeMap);
        this.commonVerifyKiePMMLDroolsAST(retrieved, fieldTypeMap);
        this.commonVerifyFieldTypeMap(fieldTypeMap, pmml.getDataDictionary().getDataFields(), pmml.getTransformationDictionary().getDerivedFields(), scorecard.getLocalTransformations().getDerivedFields());
    }

    @Test
    public void getRulesSourceMap() {
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)scorecard, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        droolsModelProvider.getKiePMMLModelWithSources((CompilationDTO)compilationDTO);
        String expectedPackageName = compilationDTO.getPackageName();
        PackageDescr packageDescr = (PackageDescr)knowledgeBuilder.getPackageDescrs(expectedPackageName).get(0);
        Map retrieved = droolsModelProvider.getRulesSourceMap(packageDescr);
        Assertions.assertThat((Map)retrieved).isNotNull();
        String rootPath = expectedPackageName + ".";
        this.commonVerifyRulesSourcesMap(retrieved, packageDescr, rootPath);
    }

    @Test
    public void generateRulesFiles() {
        KnowledgeBuilderImpl knowledgeBuilder = new KnowledgeBuilderImpl();
        CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)"PACKAGE_NAME", (PMML)pmml, (Model)scorecard, (HasClassLoader)new HasKnowledgeBuilderMock(knowledgeBuilder));
        droolsModelProvider.getKiePMMLModelWithSources((CompilationDTO)compilationDTO);
        String expectedPackageName = compilationDTO.getPackageName();
        PackageDescr packageDescr = (PackageDescr)knowledgeBuilder.getPackageDescrs(expectedPackageName).get(0);
        List retrieved = droolsModelProvider.generateRulesFiles(packageDescr);
        Assertions.assertThat((List)retrieved).isNotNull();
        String rootPath = expectedPackageName.replace('.', '/') + "/";
        packageDescr.getTypeDeclarations().forEach(typeDeclarationDescr -> {
            String expectedPath = rootPath + typeDeclarationDescr.getTypeName() + ".java";
            Assertions.assertThat((boolean)retrieved.stream().anyMatch(generatedFile -> generatedFile.getPath().equals(expectedPath))).isTrue();
        });
        String pkgUUID = (String)packageDescr.getPreferredPkgUUID().get();
        String expectedRule = rootPath + "Rules" + pkgUUID + ".java";
        Assertions.assertThat((boolean)retrieved.stream().anyMatch(generatedFile -> generatedFile.getPath().equals(expectedRule))).isTrue();
        String expectedDomain = rootPath + "DomainClassesMetadata" + pkgUUID + ".java";
        Assertions.assertThat((boolean)retrieved.stream().anyMatch(generatedFile -> generatedFile.getPath().equals(expectedDomain))).isTrue();
    }

    private void commonVerifyRulesSourcesMap(Map<String, String> toVerify, PackageDescr packageDescr, String rootPath) {
        packageDescr.getTypeDeclarations().forEach(typeDeclarationDescr -> {
            String expectedPath = rootPath + typeDeclarationDescr.getTypeName();
            Assertions.assertThat((boolean)toVerify.keySet().stream().anyMatch(className -> className.equals(expectedPath))).isTrue();
        });
        String pkgUUID = (String)packageDescr.getPreferredPkgUUID().get();
        String expectedRule = rootPath + "Rules" + pkgUUID;
        Assertions.assertThat((boolean)toVerify.keySet().stream().anyMatch(className -> className.equals(expectedRule))).isTrue();
        String expectedDomain = rootPath + "DomainClassesMetadata" + pkgUUID;
        Assertions.assertThat((boolean)toVerify.keySet().stream().anyMatch(className -> className.equals(expectedDomain))).isTrue();
    }

    private void commonVerifyPackageDescr(PackageDescr toVerify, String expectedPackageName) {
        Assertions.assertThat((String)toVerify.getName()).isEqualTo(expectedPackageName);
    }

    private void commonVerifyKiePMMLDroolsAST(KiePMMLDroolsAST toVerify, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        Assertions.assertThat((Object)toVerify).isNotNull();
        Assertions.assertThat((Object)toVerify).isInstanceOf(KiePMMLDroolsASTTest.class);
        KiePMMLDroolsASTTest toVerifyTest = (KiePMMLDroolsASTTest)toVerify;
        List originalDataFields = pmml.getDataDictionary().getDataFields();
        List retrievedDataFields = toVerifyTest.dataDictionary.getDataFields();
        Assertions.assertThat((List)toVerifyTest.dataDictionary.getDataFields()).hasSameSizeAs((Iterable)originalDataFields);
        originalDataFields.forEach(dataField -> {
            Optional<DataField> optRet = retrievedDataFields.stream().filter(retrievedDataField -> dataField.getName().equals((Object)retrievedDataField.getName())).findFirst();
            Assertions.assertThat(optRet).isPresent();
            Assertions.assertThat((Comparable)optRet.get().getDataType()).isEqualTo((Object)dataField.getDataType());
        });
        Assertions.assertThat((Object)toVerifyTest.model).isEqualTo((Object)scorecard);
        if (fieldTypeMap != null) {
            Assertions.assertThat(toVerifyTest.fieldTypeMap).isEqualTo(fieldTypeMap);
        }
        this.commonVerifyTypesList(toVerify.getTypes(), pmml.getDataDictionary().getDataFields(), pmml.getTransformationDictionary().getDerivedFields(), scorecard.getLocalTransformations().getDerivedFields());
    }

    private void commonVerifyTypesList(List<KiePMMLDroolsType> toVerify, List<DataField> dataFields, List<DerivedField> transformationsFields, List<DerivedField> localTransformationsFields) {
        int expectedEntries = dataFields.size() + transformationsFields.size() + localTransformationsFields.size();
        Assertions.assertThat(toVerify).hasSize(expectedEntries);
        dataFields.forEach(dataField -> this.commonVerifyTypesList((Field<?>)dataField, toVerify));
        transformationsFields.forEach(derivedField -> this.commonVerifyTypesList((Field<?>)derivedField, toVerify));
        localTransformationsFields.forEach(derivedField -> this.commonVerifyTypesList((Field<?>)derivedField, toVerify));
    }

    private void commonVerifyTypesList(Field<?> toVerify, List<KiePMMLDroolsType> types) {
        Assertions.assertThat((boolean)types.stream().anyMatch(type -> {
            String expectedName = KiePMMLModelUtils.getSanitizedClassName((String)toVerify.getName().getValue());
            if (!type.getName().startsWith(expectedName)) {
                return false;
            }
            String expectedType = DATA_TYPE.byName((String)toVerify.getDataType().value()).getMappedClass().getSimpleName();
            Assertions.assertThat((String)type.getType()).isEqualTo(expectedType);
            return true;
        })).isTrue();
    }

    private void commonVerifyFieldTypeMap(Map<String, KiePMMLOriginalTypeGeneratedType> toVerify, List<DataField> dataFields, List<DerivedField> transformationsFields, List<DerivedField> localTransformationsFields) {
        int expectedEntries = dataFields.size() + transformationsFields.size() + localTransformationsFields.size();
        Assertions.assertThat(toVerify).hasSize(expectedEntries);
        dataFields.forEach(dataField -> this.commonVerifyFieldTypeMap((Field<?>)dataField, toVerify));
        transformationsFields.forEach(derivedField -> this.commonVerifyFieldTypeMap((Field<?>)derivedField, toVerify));
        localTransformationsFields.forEach(derivedField -> this.commonVerifyFieldTypeMap((Field<?>)derivedField, toVerify));
    }

    private void commonVerifyFieldTypeMap(Field<?> toVerify, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        Assertions.assertThat((boolean)fieldTypeMap.entrySet().stream().anyMatch(entry -> {
            if (!((String)entry.getKey()).equals(toVerify.getName().getValue())) {
                return false;
            }
            KiePMMLOriginalTypeGeneratedType value = (KiePMMLOriginalTypeGeneratedType)entry.getValue();
            Assertions.assertThat((String)value.getOriginalType()).isEqualTo(toVerify.getDataType().value());
            String expectedGeneratedType = KiePMMLModelUtils.getSanitizedClassName((String)toVerify.getName().getValue());
            Assertions.assertThat((String)value.getGeneratedType()).startsWith((CharSequence)expectedGeneratedType);
            return true;
        })).isTrue();
    }

    private static class KiePMMLDroolsASTTest
    extends KiePMMLDroolsAST {
        final DataDictionary dataDictionary = new DataDictionary();
        final Scorecard model;
        final Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap;

        public KiePMMLDroolsASTTest(List<Field<?>> fields, Scorecard model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, List<KiePMMLDroolsType> types) {
            super(types, Collections.emptyList());
            fields.stream().filter(DataField.class::isInstance).map(DataField.class::cast).forEach(xva$0 -> this.dataDictionary.addDataFields(new DataField[]{xva$0}));
            this.model = model;
            this.fieldTypeMap = fieldTypeMap;
        }
    }

    private static class KiePMMLDroolsModelTest
    extends KiePMMLDroolsModel {
        final DataDictionary dataDictionary = new DataDictionary();
        final TransformationDictionary transformationDictionary;
        final Scorecard model;
        final Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap;

        public KiePMMLDroolsModelTest(List<Field<?>> fields, TransformationDictionary transformationDictionary, Scorecard model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
            super("PACKAGE_NAME", Collections.emptyList());
            fields.stream().filter(DataField.class::isInstance).map(DataField.class::cast).forEach(xva$0 -> this.dataDictionary.addDataFields(new DataField[]{xva$0}));
            this.transformationDictionary = transformationDictionary;
            this.model = model;
            this.fieldTypeMap = fieldTypeMap;
            this.kModulePackageName = KiePMMLModelUtils.getSanitizedPackageName((String)"PACKAGE_NAME");
        }
    }
}

