/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.factories;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.compiler.lang.api.CEDescrBuilder;
import org.drools.compiler.lang.api.DescrFactory;
import org.drools.compiler.lang.api.PackageDescrBuilder;
import org.drools.compiler.lang.api.RuleDescrBuilder;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ConditionalBranchDescr;
import org.drools.compiler.lang.descr.ExistsDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.NotDescr;
import org.drools.compiler.lang.descr.OrDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.api.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.api.enums.OPERATOR;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.KiePMMLFieldOperatorValue;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrLhsFactory;
import org.kie.pmml.models.drools.executor.KiePMMLStatusHolder;
import org.kie.pmml.models.drools.tuples.KiePMMLOperatorValue;

public class KiePMMLDescrLhsFactoryTest {
    private static final String CURRENT_RULE = "currentRule";
    private CEDescrBuilder<RuleDescrBuilder, AndDescr> lhsBuilder;

    @Before
    public void setUp() throws Exception {
        PackageDescrBuilder builder = DescrFactory.newPackage().name("PACKAGE_NAME");
        RuleDescrBuilder ruleBuilder = builder.newRule().name(CURRENT_RULE);
        this.lhsBuilder = ruleBuilder.lhs();
    }

    @Test
    public void declareLhs() {
        String name = "NAME";
        String statusToSet = "STATUS_TO_SET";
        KiePMMLDroolsRule rule = KiePMMLDroolsRule.builder((String)name, (String)statusToSet, Collections.emptyList()).build();
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareLhs(rule);
        Assertions.assertThat((Object)((AndDescr)this.lhsBuilder.getDescr())).isNotNull();
        Assertions.assertThat((List)((AndDescr)this.lhsBuilder.getDescr()).getDescrs()).isNotNull();
        Assertions.assertThat((List)((AndDescr)this.lhsBuilder.getDescr()).getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0))).isInstanceOf(PatternDescr.class);
        PatternDescr patternDescr = (PatternDescr)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(KiePMMLStatusHolder.class.getSimpleName());
        Assertions.assertThat((String)patternDescr.getIdentifier()).isEqualTo("$statusHolder");
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assertions.assertThat((List)andDescr.getDescrs()).isEmpty();
    }

    @Test
    public void declareConstraintAnd() {
        String temperatureField = "TEMPERATURE";
        String humidityField = "HUMIDITY";
        List<KiePMMLFieldOperatorValue> kiePMMLOperatorValues = Arrays.asList(new KiePMMLFieldOperatorValue(temperatureField, BOOLEAN_OPERATOR.AND, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35)), null), new KiePMMLFieldOperatorValue(humidityField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)85)), null));
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareConstraintsAndOr(kiePMMLOperatorValues, this.lhsBuilder.and());
        Assertions.assertThat((Object)((AndDescr)this.lhsBuilder.getDescr())).isNotNull();
        Assertions.assertThat((List)((AndDescr)this.lhsBuilder.getDescr()).getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0))).isInstanceOf(AndDescr.class);
        AndDescr baseAndDescr = (AndDescr)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0);
        List descrs = baseAndDescr.getDescrs();
        Assertions.assertThat((List)descrs).isNotNull();
        Assertions.assertThat((List)descrs).hasSize(2);
        Assertions.assertThat((Object)((BaseDescr)descrs.get(0))).isInstanceOf(PatternDescr.class);
        PatternDescr patternDescr = (PatternDescr)descrs.get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(temperatureField);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isNull();
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assertions.assertThat((List)andDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)andDescr.getDescrs().get(0))).isInstanceOf(ExprConstraintDescr.class);
        ExprConstraintDescr exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assertions.assertThat((boolean)exprConstraintDescr.isNegated()).isFalse();
        Assertions.assertThat((Comparable)exprConstraintDescr.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
        String expected = "value < 35";
        Assertions.assertThat((String)exprConstraintDescr.getExpression()).isEqualTo(expected);
        Assertions.assertThat((Object)((BaseDescr)descrs.get(1))).isInstanceOf(PatternDescr.class);
        patternDescr = (PatternDescr)descrs.get(1);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(humidityField);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isNull();
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        andDescr = (AndDescr)patternDescr.getConstraint();
        Assertions.assertThat((List)andDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)andDescr.getDescrs().get(0))).isInstanceOf(ExprConstraintDescr.class);
        exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assertions.assertThat((boolean)exprConstraintDescr.isNegated()).isFalse();
        Assertions.assertThat((Comparable)exprConstraintDescr.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
        expected = "value > 85";
        Assertions.assertThat((String)exprConstraintDescr.getExpression()).isEqualTo(expected);
    }

    @Test
    public void declareNestedConstraintAnd() {
        String temperatureField = "TEMPERATURE";
        String humidityField = "HUMIDITY";
        List<KiePMMLFieldOperatorValue> nestedKiePMMLFieldOperatorValues = Arrays.asList(new KiePMMLFieldOperatorValue(humidityField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)56)), null), new KiePMMLFieldOperatorValue(humidityField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)91)), null));
        List<KiePMMLFieldOperatorValue> kiePMMLOperatorValues = Collections.singletonList(new KiePMMLFieldOperatorValue(temperatureField, BOOLEAN_OPERATOR.AND, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35)), nestedKiePMMLFieldOperatorValues));
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareConstraintsAndOr(kiePMMLOperatorValues, this.lhsBuilder.and());
        Assertions.assertThat((Object)((AndDescr)this.lhsBuilder.getDescr())).isNotNull();
        Assertions.assertThat((List)((AndDescr)this.lhsBuilder.getDescr()).getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0))).isInstanceOf(AndDescr.class);
        AndDescr baseAndDescr = (AndDescr)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0);
        List descrs = baseAndDescr.getDescrs();
        Assertions.assertThat((List)descrs).isNotNull();
        Assertions.assertThat((List)descrs).hasSize(2);
        Assertions.assertThat((Object)((BaseDescr)descrs.get(0))).isInstanceOf(PatternDescr.class);
        PatternDescr patternDescr = (PatternDescr)descrs.get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(temperatureField);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isNull();
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assertions.assertThat((List)andDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)andDescr.getDescrs().get(0))).isInstanceOf(ExprConstraintDescr.class);
        ExprConstraintDescr exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assertions.assertThat((boolean)exprConstraintDescr.isNegated()).isFalse();
        Assertions.assertThat((Comparable)exprConstraintDescr.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
        String expected = "value < 35";
        Assertions.assertThat((String)exprConstraintDescr.getExpression()).isEqualTo(expected);
        Assertions.assertThat((Object)((BaseDescr)descrs.get(1))).isInstanceOf(AndDescr.class);
        AndDescr nestedAndDescr = (AndDescr)descrs.get(1);
        Assertions.assertThat((List)nestedAndDescr.getDescrs()).hasSize(2);
        List nestedDescrs = nestedAndDescr.getDescrs();
        Assertions.assertThat((Object)((BaseDescr)nestedDescrs.get(0))).isInstanceOf(PatternDescr.class);
        patternDescr = (PatternDescr)nestedDescrs.get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(humidityField);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isNull();
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        andDescr = (AndDescr)patternDescr.getConstraint();
        Assertions.assertThat((List)andDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)andDescr.getDescrs().get(0))).isInstanceOf(ExprConstraintDescr.class);
        exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assertions.assertThat((boolean)exprConstraintDescr.isNegated()).isFalse();
        Assertions.assertThat((Comparable)exprConstraintDescr.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
        expected = "value < 56";
        Assertions.assertThat((String)exprConstraintDescr.getExpression()).isEqualTo(expected);
        Assertions.assertThat((Object)((BaseDescr)nestedDescrs.get(1))).isInstanceOf(PatternDescr.class);
        patternDescr = (PatternDescr)nestedDescrs.get(1);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(humidityField);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isNull();
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        andDescr = (AndDescr)patternDescr.getConstraint();
        Assertions.assertThat((List)andDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)andDescr.getDescrs().get(0))).isInstanceOf(ExprConstraintDescr.class);
        exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assertions.assertThat((boolean)exprConstraintDescr.isNegated()).isFalse();
        Assertions.assertThat((Comparable)exprConstraintDescr.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
        expected = "value > 91";
        Assertions.assertThat((String)exprConstraintDescr.getExpression()).isEqualTo(expected);
    }

    @Test
    public void declareConstraintsOr() {
        String temperatureField = "TEMPERATURE";
        String humidityField = "HUMIDITY";
        List<KiePMMLFieldOperatorValue> kiePMMLOperatorValues = Arrays.asList(new KiePMMLFieldOperatorValue(temperatureField, BOOLEAN_OPERATOR.AND, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35)), null), new KiePMMLFieldOperatorValue(humidityField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)85)), null));
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareConstraintsAndOr(kiePMMLOperatorValues, this.lhsBuilder.or());
        Assertions.assertThat((Object)((AndDescr)this.lhsBuilder.getDescr())).isNotNull();
        Assertions.assertThat((List)((AndDescr)this.lhsBuilder.getDescr()).getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0))).isInstanceOf(OrDescr.class);
        OrDescr baseOrDescr = (OrDescr)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0);
        List descrs = baseOrDescr.getDescrs();
        Assertions.assertThat((List)descrs).isNotNull();
        Assertions.assertThat((List)descrs).hasSize(2);
        Assertions.assertThat((Object)((BaseDescr)descrs.get(0))).isInstanceOf(PatternDescr.class);
        PatternDescr patternDescr = (PatternDescr)descrs.get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(temperatureField);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isNull();
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assertions.assertThat((List)andDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)andDescr.getDescrs().get(0))).isInstanceOf(ExprConstraintDescr.class);
        ExprConstraintDescr exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assertions.assertThat((boolean)exprConstraintDescr.isNegated()).isFalse();
        Assertions.assertThat((Comparable)exprConstraintDescr.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
        String expected = "value < 35";
        Assertions.assertThat((String)exprConstraintDescr.getExpression()).isEqualTo(expected);
        Assertions.assertThat((Object)((BaseDescr)descrs.get(1))).isInstanceOf(PatternDescr.class);
        patternDescr = (PatternDescr)descrs.get(1);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(humidityField);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isNull();
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        andDescr = (AndDescr)patternDescr.getConstraint();
        Assertions.assertThat((List)andDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)andDescr.getDescrs().get(0))).isInstanceOf(ExprConstraintDescr.class);
        exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assertions.assertThat((boolean)exprConstraintDescr.isNegated()).isFalse();
        Assertions.assertThat((Comparable)exprConstraintDescr.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
        expected = "value > 85";
        Assertions.assertThat((String)exprConstraintDescr.getExpression()).isEqualTo(expected);
    }

    @Test(expected=KiePMMLException.class)
    public void declareConstraintsXorWrongInput() {
        String temperatureField = "TEMPERATURE";
        String humidityField = "HUMIDITY";
        List<KiePMMLFieldOperatorValue> xorConstraints = Arrays.asList(new KiePMMLFieldOperatorValue(temperatureField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35)), null), new KiePMMLFieldOperatorValue(temperatureField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)85)), null), new KiePMMLFieldOperatorValue(humidityField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)56)), null), new KiePMMLFieldOperatorValue(humidityField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)91)), null));
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareConstraintsXor(xorConstraints);
    }

    @Test
    public void declareConstraintsXor() {
        String temperatureField = "TEMPERATURE";
        List<KiePMMLFieldOperatorValue> xorConstraints = Arrays.asList(new KiePMMLFieldOperatorValue(temperatureField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.LESS_THAN, (Object)35)), null), new KiePMMLFieldOperatorValue(temperatureField, BOOLEAN_OPERATOR.OR, Collections.singletonList(new KiePMMLOperatorValue(OPERATOR.GREATER_THAN, (Object)85)), null));
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareConstraintsXor(xorConstraints);
        Assertions.assertThat((Object)((AndDescr)this.lhsBuilder.getDescr())).isNotNull();
        Assertions.assertThat((List)((AndDescr)this.lhsBuilder.getDescr()).getDescrs()).isNotNull();
        Assertions.assertThat((List)((AndDescr)this.lhsBuilder.getDescr()).getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0))).isInstanceOf(AndDescr.class);
        AndDescr rootAndDescr = (AndDescr)((AndDescr)this.lhsBuilder.getDescr()).getDescrs().get(0);
        Assertions.assertThat((List)rootAndDescr.getDescrs()).hasSize(2);
        Assertions.assertThat((Object)((BaseDescr)rootAndDescr.getDescrs().get(0))).isInstanceOf(NotDescr.class);
        Assertions.assertThat((Object)((BaseDescr)rootAndDescr.getDescrs().get(1))).isInstanceOf(ExistsDescr.class);
        NotDescr notDescr = (NotDescr)rootAndDescr.getDescrs().get(0);
        Assertions.assertThat((List)notDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)notDescr.getDescrs().get(0))).isInstanceOf(AndDescr.class);
        AndDescr notAndDescr = (AndDescr)notDescr.getDescrs().get(0);
        Assertions.assertThat((Object)((BaseDescr)notAndDescr.getDescrs().get(0))).isInstanceOf(PatternDescr.class);
        Assertions.assertThat((Object)((BaseDescr)notAndDescr.getDescrs().get(1))).isInstanceOf(PatternDescr.class);
        PatternDescr patternDescr = (PatternDescr)notAndDescr.getDescrs().get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(temperatureField);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isNull();
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assertions.assertThat((List)andDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)andDescr.getDescrs().get(0))).isInstanceOf(ExprConstraintDescr.class);
        ExprConstraintDescr exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assertions.assertThat((boolean)exprConstraintDescr.isNegated()).isFalse();
        Assertions.assertThat((Comparable)exprConstraintDescr.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
        String expected = "value < 35";
        Assertions.assertThat((String)exprConstraintDescr.getExpression()).isEqualTo(expected);
        patternDescr = (PatternDescr)notAndDescr.getDescrs().get(1);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(temperatureField);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isNull();
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        andDescr = (AndDescr)patternDescr.getConstraint();
        Assertions.assertThat((List)andDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)andDescr.getDescrs().get(0))).isInstanceOf(ExprConstraintDescr.class);
        exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assertions.assertThat((boolean)exprConstraintDescr.isNegated()).isFalse();
        Assertions.assertThat((Comparable)exprConstraintDescr.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
        expected = "value > 85";
        Assertions.assertThat((String)exprConstraintDescr.getExpression()).isEqualTo(expected);
        ExistsDescr existsDescr = (ExistsDescr)rootAndDescr.getDescrs().get(1);
        Assertions.assertThat((List)existsDescr.getDescrs()).hasSize(1);
        Assertions.assertThat(existsDescr.getDescrs().get(0)).isInstanceOf(OrDescr.class);
        OrDescr existsOrDescr = (OrDescr)existsDescr.getDescrs().get(0);
        Assertions.assertThat((List)existsOrDescr.getDescrs()).hasSize(2);
        Assertions.assertThat((Object)((BaseDescr)existsOrDescr.getDescrs().get(0))).isInstanceOf(PatternDescr.class);
        Assertions.assertThat((Object)((BaseDescr)existsOrDescr.getDescrs().get(1))).isInstanceOf(OrDescr.class);
        patternDescr = (PatternDescr)existsOrDescr.getDescrs().get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(temperatureField);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isNull();
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        andDescr = (AndDescr)patternDescr.getConstraint();
        Assertions.assertThat((List)andDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)andDescr.getDescrs().get(0))).isInstanceOf(ExprConstraintDescr.class);
        exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assertions.assertThat((boolean)exprConstraintDescr.isNegated()).isFalse();
        Assertions.assertThat((Comparable)exprConstraintDescr.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
        expected = "value < 35";
        Assertions.assertThat((String)exprConstraintDescr.getExpression()).isEqualTo(expected);
        OrDescr nestedOrDescr = (OrDescr)existsOrDescr.getDescrs().get(1);
        Assertions.assertThat((List)nestedOrDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)nestedOrDescr.getDescrs().get(0))).isInstanceOf(PatternDescr.class);
        patternDescr = (PatternDescr)nestedOrDescr.getDescrs().get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(temperatureField);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isNull();
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        andDescr = (AndDescr)patternDescr.getConstraint();
        Assertions.assertThat((List)andDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)andDescr.getDescrs().get(0))).isInstanceOf(ExprConstraintDescr.class);
        exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assertions.assertThat((boolean)exprConstraintDescr.isNegated()).isFalse();
        Assertions.assertThat((Comparable)exprConstraintDescr.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
        expected = "value > 85";
        Assertions.assertThat((String)exprConstraintDescr.getExpression()).isEqualTo(expected);
    }

    @Test
    public void commonDeclarePatternWithConstraint() {
        String patternType = "TEMPERATURE";
        String constraintsString = "value < 35";
        CEDescrBuilder existsBuilder = this.lhsBuilder.not().exists();
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).commonDeclarePatternWithConstraint(existsBuilder, patternType, constraintsString);
        Assertions.assertThat((Object)((ExistsDescr)existsBuilder.getDescr())).isNotNull();
        List descrs = ((ExistsDescr)existsBuilder.getDescr()).getDescrs();
        Assertions.assertThat((List)descrs).isNotNull();
        Assertions.assertThat((List)descrs).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)descrs.get(0))).isInstanceOf(PatternDescr.class);
        PatternDescr patternDescr = (PatternDescr)descrs.get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(patternType);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isNull();
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assertions.assertThat((List)andDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)andDescr.getDescrs().get(0))).isInstanceOf(ExprConstraintDescr.class);
        ExprConstraintDescr exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assertions.assertThat((boolean)exprConstraintDescr.isNegated()).isFalse();
        Assertions.assertThat((Comparable)exprConstraintDescr.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
        Assertions.assertThat((String)exprConstraintDescr.getExpression()).isEqualTo(constraintsString);
    }

    @Test
    public void declareConstraintIn() {
        List<Object> values = Arrays.asList("-5", "0.5", "1", "10");
        String patternType = "INPUT1";
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareConstraintIn(patternType, values);
        List descrs = ((AndDescr)this.lhsBuilder.getDescr()).getDescrs();
        Assertions.assertThat((List)descrs).isNotNull();
        Assertions.assertThat((List)descrs).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)descrs.get(0))).isInstanceOf(PatternDescr.class);
        PatternDescr patternDescr = (PatternDescr)descrs.get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(patternType);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isNull();
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assertions.assertThat((List)andDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)andDescr.getDescrs().get(0))).isInstanceOf(ExprConstraintDescr.class);
        ExprConstraintDescr exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assertions.assertThat((boolean)exprConstraintDescr.isNegated()).isFalse();
        Assertions.assertThat((Comparable)exprConstraintDescr.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
        String expected = "value in (-5, 0.5, 1, 10)";
        Assertions.assertThat((String)exprConstraintDescr.getExpression()).isEqualTo(expected);
    }

    @Test
    public void declareConstraintNotIn() {
        List<Object> values = Arrays.asList("3", "8.5");
        String patternType = "INPUT2";
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareConstraintNotIn(patternType, values);
        List descrs = ((AndDescr)this.lhsBuilder.getDescr()).getDescrs();
        Assertions.assertThat((List)descrs).isNotNull();
        Assertions.assertThat((List)descrs).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)descrs.get(0))).isInstanceOf(NotDescr.class);
        NotDescr notDescr = (NotDescr)descrs.get(0);
        Assertions.assertThat((List)notDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)notDescr.getDescrs().get(0))).isInstanceOf(PatternDescr.class);
        PatternDescr patternDescr = (PatternDescr)notDescr.getDescrs().get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(patternType);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isNull();
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        AndDescr andDescr = (AndDescr)patternDescr.getConstraint();
        Assertions.assertThat((List)andDescr.getDescrs()).hasSize(1);
        Assertions.assertThat((Object)((BaseDescr)andDescr.getDescrs().get(0))).isInstanceOf(ExprConstraintDescr.class);
        ExprConstraintDescr exprConstraintDescr = (ExprConstraintDescr)andDescr.getDescrs().get(0);
        Assertions.assertThat((boolean)exprConstraintDescr.isNegated()).isFalse();
        Assertions.assertThat((Comparable)exprConstraintDescr.getType()).isEqualTo((Object)ExprConstraintDescr.Type.NAMED);
        String expected = "value in (3, 8.5)";
        Assertions.assertThat((String)exprConstraintDescr.getExpression()).isEqualTo(expected);
    }

    @Test
    public void declareIfBreak() {
        String ifBreakField = "TEMPERATURE";
        String ifBreakOperator = "<";
        Integer ifBreakValue = 24;
        KiePMMLDescrLhsFactory.factory(this.lhsBuilder).declareIfBreak(ifBreakField, ifBreakOperator, (Object)ifBreakValue);
        Assertions.assertThat((Object)((AndDescr)this.lhsBuilder.getDescr())).isNotNull();
        List descrs = ((AndDescr)this.lhsBuilder.getDescr()).getDescrs();
        Assertions.assertThat((List)descrs).isNotNull();
        Assertions.assertThat((List)descrs).hasSize(2);
        Assertions.assertThat((Object)((BaseDescr)descrs.get(0))).isInstanceOf(PatternDescr.class);
        Assertions.assertThat((Object)((BaseDescr)descrs.get(1))).isInstanceOf(ConditionalBranchDescr.class);
        PatternDescr patternDescr = (PatternDescr)descrs.get(0);
        Assertions.assertThat((String)patternDescr.getObjectType()).isEqualTo(ifBreakField);
        Assertions.assertThat((String)patternDescr.getIdentifier()).isEqualTo("$inputField");
        Assertions.assertThat((Object)patternDescr.getConstraint()).isInstanceOf(AndDescr.class);
        ConditionalBranchDescr conditionalBranchDescr = (ConditionalBranchDescr)descrs.get(1);
        String expectedCondition = String.format("$inputField.getValue() %s %s", ifBreakOperator, ifBreakValue);
        Assertions.assertThat((Object)conditionalBranchDescr.getCondition().getContent()).isEqualTo((Object)expectedCondition);
        Assertions.assertThat((boolean)conditionalBranchDescr.getConsequence().isBreaking()).isTrue();
        Assertions.assertThat((String)conditionalBranchDescr.getConsequence().getText()).isEqualTo("match");
    }

    @Test
    public void getInNotInConstraint() {
        List<Object> values = Arrays.asList("-5", "0.5", "1", "10");
        String retrieved = KiePMMLDescrLhsFactory.factory(this.lhsBuilder).getInNotInConstraint(values);
        String expected = "value in (-5, 0.5, 1, 10)";
        Assertions.assertThat((String)retrieved).isEqualTo(expected);
    }
}

