/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.factories;

import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.IntStream;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.TypeDeclarationDescr;
import org.drools.drl.ast.descr.TypeFieldDescr;
import org.drools.drl.ast.dsl.DescrFactory;
import org.drools.drl.ast.dsl.PackageDescrBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrTestUtils;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrTypesFactory;

public class KiePMMLDescrTypesFactoryTest {
    private PackageDescrBuilder builder;

    @Before
    public void setUp() throws Exception {
        this.builder = DescrFactory.newPackage().name("PACKAGE_NAME");
    }

    @Test
    public void declareTypes() {
        ArrayList<KiePMMLDroolsType> types = new ArrayList<KiePMMLDroolsType>();
        types.add(KiePMMLDescrTestUtils.getDroolsType());
        types.add(KiePMMLDescrTestUtils.getDottedDroolsType());
        Assert.assertTrue((boolean)((PackageDescr)this.builder.getDescr()).getTypeDeclarations().isEmpty());
        KiePMMLDescrTypesFactory.factory((PackageDescrBuilder)this.builder).declareTypes(types);
        Assert.assertEquals((long)2L, (long)((PackageDescr)this.builder.getDescr()).getTypeDeclarations().size());
        IntStream.range(0, types.size()).forEach(i -> this.commonVerifyTypeDeclarationDescr(Objects.requireNonNull((KiePMMLDroolsType)types.get(i)), (TypeDeclarationDescr)((PackageDescr)this.builder.getDescr()).getTypeDeclarations().get(i)));
    }

    @Test
    public void declareType() {
        KiePMMLDroolsType type = KiePMMLDescrTestUtils.getDroolsType();
        KiePMMLDescrTypesFactory.factory((PackageDescrBuilder)this.builder).declareType(type);
        Assert.assertEquals((long)1L, (long)((PackageDescr)this.builder.getDescr()).getTypeDeclarations().size());
        this.commonVerifyTypeDeclarationDescr(type, (TypeDeclarationDescr)((PackageDescr)this.builder.getDescr()).getTypeDeclarations().get(0));
    }

    private void commonVerifyTypeDeclarationDescr(KiePMMLDroolsType type, TypeDeclarationDescr typeDeclarationDescr) {
        String expectedGeneratedType = type.getName();
        String expectedMappedOriginalType = type.getType();
        Assert.assertEquals((Object)expectedGeneratedType, (Object)typeDeclarationDescr.getTypeName());
        Assert.assertEquals((long)1L, (long)typeDeclarationDescr.getFields().size());
        Assert.assertTrue((boolean)typeDeclarationDescr.getFields().containsKey("value"));
        Assert.assertEquals((Object)expectedMappedOriginalType, (Object)((TypeFieldDescr)typeDeclarationDescr.getFields().get("value")).getPattern().getObjectType());
    }
}

