/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.utils;

import java.util.List;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.pmml.models.drools.executor.KiePMMLStatusHolder;
import org.kie.pmml.models.drools.utils.KiePMMLSessionUtils;

public class KiePMMLSessionUtilsTest {
    private static final KieBase KIE_BASE = KnowledgeBaseFactory.newKnowledgeBase((String)"PMML", null);
    private static final String MODEL_NAME = "MODELNAME";
    private static final PMML4Result PMML4_RESULT = new PMML4Result();
    private KiePMMLSessionUtils.Builder builder;
    private KiePMMLSessionUtils kiePMMLSessionUtils;

    @Before
    public void setup() {
        this.builder = KiePMMLSessionUtils.builder((KieBase)KIE_BASE, (String)MODEL_NAME, (String)"PACKAGE_NAME", (PMML4Result)PMML4_RESULT);
        this.kiePMMLSessionUtils = this.builder.build();
    }

    @Test
    public void builder() {
        Assert.assertNotNull((Object)this.builder);
        Assert.assertNotNull((Object)this.kiePMMLSessionUtils);
    }

    @Test
    public void kiePMMLSessionUtils() {
        List retrieved = this.kiePMMLSessionUtils.commands;
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)3L, (long)retrieved.size());
        Assert.assertTrue((boolean)(retrieved.get(0) instanceof InsertObjectCommand));
        InsertObjectCommand insertObjectCommand = (InsertObjectCommand)retrieved.get(0);
        Assert.assertEquals((Object)"DEFAULT", (Object)insertObjectCommand.getEntryPoint());
        Assert.assertNotNull((Object)insertObjectCommand.getObject());
        Assert.assertTrue((boolean)(insertObjectCommand.getObject() instanceof KiePMMLStatusHolder));
        KiePMMLStatusHolder kiePMMLStatusHolder = (KiePMMLStatusHolder)insertObjectCommand.getObject();
        Assert.assertEquals((double)0.0, (double)kiePMMLStatusHolder.getAccumulator(), (double)0.0);
        Assert.assertNull((Object)kiePMMLStatusHolder.getStatus());
        Assert.assertTrue((boolean)(retrieved.get(1) instanceof InsertObjectCommand));
        insertObjectCommand = (InsertObjectCommand)retrieved.get(1);
        Assert.assertEquals((Object)"DEFAULT", (Object)insertObjectCommand.getEntryPoint());
        Assert.assertNotNull((Object)insertObjectCommand.getObject());
        Assert.assertTrue((boolean)(insertObjectCommand.getObject() instanceof PMML4Result));
        Assert.assertEquals((Object)PMML4_RESULT, (Object)insertObjectCommand.getObject());
        Assert.assertTrue((boolean)(retrieved.get(2) instanceof SetGlobalCommand));
        SetGlobalCommand setGlobalCommand = (SetGlobalCommand)retrieved.get(2);
        Assert.assertEquals((Object)"$pmml4Result", (Object)setGlobalCommand.getIdentifier());
        Assert.assertTrue((boolean)(setGlobalCommand.getObject() instanceof PMML4Result));
        Assert.assertEquals((Object)PMML4_RESULT, (Object)setGlobalCommand.getObject());
    }

    @Test
    public void getKieSession() {
        StatelessKieSession retrieved = this.kiePMMLSessionUtils.getKieSession(KIE_BASE);
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void insertObjectInSession() {
        List retrieved = this.kiePMMLSessionUtils.commands;
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)3L, (long)retrieved.size());
        String toInsert = "TO_INSERT";
        String globalName = "GLOBAL_NAME";
        this.kiePMMLSessionUtils.insertObjectInSession((Object)toInsert, "GLOBAL_NAME");
        Assert.assertEquals((long)5L, (long)retrieved.size());
        Assert.assertTrue((boolean)(retrieved.get(3) instanceof InsertObjectCommand));
        InsertObjectCommand insertObjectCommand = (InsertObjectCommand)retrieved.get(3);
        Assert.assertEquals((Object)"DEFAULT", (Object)insertObjectCommand.getEntryPoint());
        Assert.assertNotNull((Object)insertObjectCommand.getObject());
        Assert.assertEquals((Object)toInsert, (Object)insertObjectCommand.getObject());
        Assert.assertTrue((boolean)(retrieved.get(4) instanceof SetGlobalCommand));
        SetGlobalCommand setGlobalCommand = (SetGlobalCommand)retrieved.get(4);
        Assert.assertEquals((Object)"GLOBAL_NAME", (Object)setGlobalCommand.getIdentifier());
        Assert.assertEquals((Object)toInsert, (Object)setGlobalCommand.getObject());
    }
}

